/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdgroupMetadata
extends APINode {
    @SerializedName(value="carousel_style")
    private String mCarouselStyle = null;
    @SerializedName(value="carousel_with_static_card_style")
    private String mCarouselWithStaticCardStyle = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdgroupMetadata loadJSON(String json, APIContext context) {
        AdgroupMetadata adgroupMetadata = (AdgroupMetadata)AdgroupMetadata.getGson().fromJson(json, AdgroupMetadata.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adgroupMetadata.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adgroupMetadata.context = context;
        adgroupMetadata.rawValue = json;
        return adgroupMetadata;
    }

    public static APINodeList<AdgroupMetadata> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdgroupMetadata> adgroupMetadatas = new APINodeList<AdgroupMetadata>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adgroupMetadatas.add(AdgroupMetadata.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adgroupMetadatas;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adgroupMetadatas.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adgroupMetadatas.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adgroupMetadatas.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adgroupMetadatas.add(AdgroupMetadata.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adgroupMetadatas.add(AdgroupMetadata.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adgroupMetadatas.add(AdgroupMetadata.loadJSON(obj.toString(), context));
                        }
                    }
                    return adgroupMetadatas;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adgroupMetadatas.add(AdgroupMetadata.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adgroupMetadatas;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adgroupMetadatas.add(AdgroupMetadata.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adgroupMetadatas;
                }
                adgroupMetadatas.clear();
                adgroupMetadatas.add(AdgroupMetadata.loadJSON(json, context));
                return adgroupMetadatas;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdgroupMetadata.getGson().toJson((Object)this);
    }

    public String getFieldCarouselStyle() {
        return this.mCarouselStyle;
    }

    public AdgroupMetadata setFieldCarouselStyle(String value) {
        this.mCarouselStyle = value;
        return this;
    }

    public String getFieldCarouselWithStaticCardStyle() {
        return this.mCarouselWithStaticCardStyle;
    }

    public AdgroupMetadata setFieldCarouselWithStaticCardStyle(String value) {
        this.mCarouselWithStaticCardStyle = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public AdgroupMetadata setFieldId(String value) {
        this.mId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdgroupMetadata copyFrom(AdgroupMetadata instance) {
        this.mCarouselStyle = instance.mCarouselStyle;
        this.mCarouselWithStaticCardStyle = instance.mCarouselWithStaticCardStyle;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdgroupMetadata> getParser() {
        return new APIRequest.ResponseParser<AdgroupMetadata>(){

            @Override
            public APINodeList<AdgroupMetadata> parseResponse(String response, APIContext context, APIRequest<AdgroupMetadata> request) throws APIException.MalformedResponseException {
                return AdgroupMetadata.parseResponse(response, context, request);
            }
        };
    }
}

