/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdCreativeCollectionThumbnailInfo;
import com.facebook.ads.sdk.AdCreativeLinkDataAppLinkSpec;
import com.facebook.ads.sdk.AdCreativeLinkDataCallToAction;
import com.facebook.ads.sdk.AdCreativeLinkDataChildAttachment;
import com.facebook.ads.sdk.AdCreativeLinkDataCustomOverlaySpec;
import com.facebook.ads.sdk.AdCreativeLinkDataImageLayerSpec;
import com.facebook.ads.sdk.AdCreativeLinkDataImageOverlaySpec;
import com.facebook.ads.sdk.AdCreativeLinkDataSponsorshipInfoSpec;
import com.facebook.ads.sdk.AdCreativePostClickConfiguration;
import com.facebook.ads.sdk.AdCreativeStaticFallbackSpec;
import com.facebook.ads.sdk.AdCustomizationRuleSpec;
import com.facebook.ads.sdk.AdsImageCrops;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdCreativeLinkData
extends APINode {
    @SerializedName(value="additional_image_index")
    private Long mAdditionalImageIndex = null;
    @SerializedName(value="app_link_spec")
    private AdCreativeLinkDataAppLinkSpec mAppLinkSpec = null;
    @SerializedName(value="attachment_style")
    private EnumAttachmentStyle mAttachmentStyle = null;
    @SerializedName(value="branded_content_shared_to_sponsor_status")
    private String mBrandedContentSharedToSponsorStatus = null;
    @SerializedName(value="branded_content_sponsor_page_id")
    private String mBrandedContentSponsorPageId = null;
    @SerializedName(value="branded_content_sponsor_relationship")
    private String mBrandedContentSponsorRelationship = null;
    @SerializedName(value="call_to_action")
    private AdCreativeLinkDataCallToAction mCallToAction = null;
    @SerializedName(value="caption")
    private String mCaption = null;
    @SerializedName(value="child_attachments")
    private List<AdCreativeLinkDataChildAttachment> mChildAttachments = null;
    @SerializedName(value="collection_thumbnails")
    private List<AdCreativeCollectionThumbnailInfo> mCollectionThumbnails = null;
    @SerializedName(value="custom_overlay_spec")
    private AdCreativeLinkDataCustomOverlaySpec mCustomOverlaySpec = null;
    @SerializedName(value="customization_rules_spec")
    private List<AdCustomizationRuleSpec> mCustomizationRulesSpec = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="event_id")
    private String mEventId = null;
    @SerializedName(value="force_single_link")
    private Boolean mForceSingleLink = null;
    @SerializedName(value="format_option")
    private EnumFormatOption mFormatOption = null;
    @SerializedName(value="image_crops")
    private AdsImageCrops mImageCrops = null;
    @SerializedName(value="image_hash")
    private String mImageHash = null;
    @SerializedName(value="image_layer_specs")
    private List<AdCreativeLinkDataImageLayerSpec> mImageLayerSpecs = null;
    @SerializedName(value="image_overlay_spec")
    private AdCreativeLinkDataImageOverlaySpec mImageOverlaySpec = null;
    @SerializedName(value="link")
    private String mLink = null;
    @SerializedName(value="message")
    private String mMessage = null;
    @SerializedName(value="multi_share_end_card")
    private Boolean mMultiShareEndCard = null;
    @SerializedName(value="multi_share_optimized")
    private Boolean mMultiShareOptimized = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="offer_id")
    private String mOfferId = null;
    @SerializedName(value="page_welcome_message")
    private String mPageWelcomeMessage = null;
    @SerializedName(value="picture")
    private String mPicture = null;
    @SerializedName(value="post_click_configuration")
    private AdCreativePostClickConfiguration mPostClickConfiguration = null;
    @SerializedName(value="preferred_image_tags")
    private List<String> mPreferredImageTags = null;
    @SerializedName(value="retailer_item_ids")
    private List<String> mRetailerItemIds = null;
    @SerializedName(value="show_multiple_images")
    private Boolean mShowMultipleImages = null;
    @SerializedName(value="sponsorship_info")
    private AdCreativeLinkDataSponsorshipInfoSpec mSponsorshipInfo = null;
    @SerializedName(value="static_fallback_spec")
    private AdCreativeStaticFallbackSpec mStaticFallbackSpec = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdCreativeLinkData loadJSON(String json, APIContext context) {
        AdCreativeLinkData adCreativeLinkData = (AdCreativeLinkData)AdCreativeLinkData.getGson().fromJson(json, AdCreativeLinkData.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adCreativeLinkData.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adCreativeLinkData.context = context;
        adCreativeLinkData.rawValue = json;
        return adCreativeLinkData;
    }

    public static APINodeList<AdCreativeLinkData> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdCreativeLinkData> adCreativeLinkDatas = new APINodeList<AdCreativeLinkData>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adCreativeLinkDatas.add(AdCreativeLinkData.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adCreativeLinkDatas;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adCreativeLinkDatas.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adCreativeLinkDatas.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adCreativeLinkDatas.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adCreativeLinkDatas.add(AdCreativeLinkData.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adCreativeLinkDatas.add(AdCreativeLinkData.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adCreativeLinkDatas.add(AdCreativeLinkData.loadJSON(obj.toString(), context));
                        }
                    }
                    return adCreativeLinkDatas;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adCreativeLinkDatas.add(AdCreativeLinkData.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adCreativeLinkDatas;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adCreativeLinkDatas.add(AdCreativeLinkData.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adCreativeLinkDatas;
                }
                adCreativeLinkDatas.clear();
                adCreativeLinkDatas.add(AdCreativeLinkData.loadJSON(json, context));
                return adCreativeLinkDatas;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdCreativeLinkData.getGson().toJson((Object)this);
    }

    public Long getFieldAdditionalImageIndex() {
        return this.mAdditionalImageIndex;
    }

    public AdCreativeLinkData setFieldAdditionalImageIndex(Long value) {
        this.mAdditionalImageIndex = value;
        return this;
    }

    public AdCreativeLinkDataAppLinkSpec getFieldAppLinkSpec() {
        return this.mAppLinkSpec;
    }

    public AdCreativeLinkData setFieldAppLinkSpec(AdCreativeLinkDataAppLinkSpec value) {
        this.mAppLinkSpec = value;
        return this;
    }

    public AdCreativeLinkData setFieldAppLinkSpec(String value) {
        Type type = new TypeToken<AdCreativeLinkDataAppLinkSpec>(){}.getType();
        this.mAppLinkSpec = (AdCreativeLinkDataAppLinkSpec)AdCreativeLinkDataAppLinkSpec.getGson().fromJson(value, type);
        return this;
    }

    public EnumAttachmentStyle getFieldAttachmentStyle() {
        return this.mAttachmentStyle;
    }

    public AdCreativeLinkData setFieldAttachmentStyle(EnumAttachmentStyle value) {
        this.mAttachmentStyle = value;
        return this;
    }

    public String getFieldBrandedContentSharedToSponsorStatus() {
        return this.mBrandedContentSharedToSponsorStatus;
    }

    public AdCreativeLinkData setFieldBrandedContentSharedToSponsorStatus(String value) {
        this.mBrandedContentSharedToSponsorStatus = value;
        return this;
    }

    public String getFieldBrandedContentSponsorPageId() {
        return this.mBrandedContentSponsorPageId;
    }

    public AdCreativeLinkData setFieldBrandedContentSponsorPageId(String value) {
        this.mBrandedContentSponsorPageId = value;
        return this;
    }

    public String getFieldBrandedContentSponsorRelationship() {
        return this.mBrandedContentSponsorRelationship;
    }

    public AdCreativeLinkData setFieldBrandedContentSponsorRelationship(String value) {
        this.mBrandedContentSponsorRelationship = value;
        return this;
    }

    public AdCreativeLinkDataCallToAction getFieldCallToAction() {
        return this.mCallToAction;
    }

    public AdCreativeLinkData setFieldCallToAction(AdCreativeLinkDataCallToAction value) {
        this.mCallToAction = value;
        return this;
    }

    public AdCreativeLinkData setFieldCallToAction(String value) {
        Type type = new TypeToken<AdCreativeLinkDataCallToAction>(){}.getType();
        this.mCallToAction = (AdCreativeLinkDataCallToAction)AdCreativeLinkDataCallToAction.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldCaption() {
        return this.mCaption;
    }

    public AdCreativeLinkData setFieldCaption(String value) {
        this.mCaption = value;
        return this;
    }

    public List<AdCreativeLinkDataChildAttachment> getFieldChildAttachments() {
        return this.mChildAttachments;
    }

    public AdCreativeLinkData setFieldChildAttachments(List<AdCreativeLinkDataChildAttachment> value) {
        this.mChildAttachments = value;
        return this;
    }

    public AdCreativeLinkData setFieldChildAttachments(String value) {
        Type type = new TypeToken<List<AdCreativeLinkDataChildAttachment>>(){}.getType();
        this.mChildAttachments = (List)AdCreativeLinkDataChildAttachment.getGson().fromJson(value, type);
        return this;
    }

    public List<AdCreativeCollectionThumbnailInfo> getFieldCollectionThumbnails() {
        return this.mCollectionThumbnails;
    }

    public AdCreativeLinkData setFieldCollectionThumbnails(List<AdCreativeCollectionThumbnailInfo> value) {
        this.mCollectionThumbnails = value;
        return this;
    }

    public AdCreativeLinkData setFieldCollectionThumbnails(String value) {
        Type type = new TypeToken<List<AdCreativeCollectionThumbnailInfo>>(){}.getType();
        this.mCollectionThumbnails = (List)AdCreativeCollectionThumbnailInfo.getGson().fromJson(value, type);
        return this;
    }

    public AdCreativeLinkDataCustomOverlaySpec getFieldCustomOverlaySpec() {
        return this.mCustomOverlaySpec;
    }

    public AdCreativeLinkData setFieldCustomOverlaySpec(AdCreativeLinkDataCustomOverlaySpec value) {
        this.mCustomOverlaySpec = value;
        return this;
    }

    public AdCreativeLinkData setFieldCustomOverlaySpec(String value) {
        Type type = new TypeToken<AdCreativeLinkDataCustomOverlaySpec>(){}.getType();
        this.mCustomOverlaySpec = (AdCreativeLinkDataCustomOverlaySpec)AdCreativeLinkDataCustomOverlaySpec.getGson().fromJson(value, type);
        return this;
    }

    public List<AdCustomizationRuleSpec> getFieldCustomizationRulesSpec() {
        return this.mCustomizationRulesSpec;
    }

    public AdCreativeLinkData setFieldCustomizationRulesSpec(List<AdCustomizationRuleSpec> value) {
        this.mCustomizationRulesSpec = value;
        return this;
    }

    public AdCreativeLinkData setFieldCustomizationRulesSpec(String value) {
        Type type = new TypeToken<List<AdCustomizationRuleSpec>>(){}.getType();
        this.mCustomizationRulesSpec = (List)AdCustomizationRuleSpec.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public AdCreativeLinkData setFieldDescription(String value) {
        this.mDescription = value;
        return this;
    }

    public String getFieldEventId() {
        return this.mEventId;
    }

    public AdCreativeLinkData setFieldEventId(String value) {
        this.mEventId = value;
        return this;
    }

    public Boolean getFieldForceSingleLink() {
        return this.mForceSingleLink;
    }

    public AdCreativeLinkData setFieldForceSingleLink(Boolean value) {
        this.mForceSingleLink = value;
        return this;
    }

    public EnumFormatOption getFieldFormatOption() {
        return this.mFormatOption;
    }

    public AdCreativeLinkData setFieldFormatOption(EnumFormatOption value) {
        this.mFormatOption = value;
        return this;
    }

    public AdsImageCrops getFieldImageCrops() {
        return this.mImageCrops;
    }

    public AdCreativeLinkData setFieldImageCrops(AdsImageCrops value) {
        this.mImageCrops = value;
        return this;
    }

    public AdCreativeLinkData setFieldImageCrops(String value) {
        Type type = new TypeToken<AdsImageCrops>(){}.getType();
        this.mImageCrops = (AdsImageCrops)AdsImageCrops.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldImageHash() {
        return this.mImageHash;
    }

    public AdCreativeLinkData setFieldImageHash(String value) {
        this.mImageHash = value;
        return this;
    }

    public List<AdCreativeLinkDataImageLayerSpec> getFieldImageLayerSpecs() {
        return this.mImageLayerSpecs;
    }

    public AdCreativeLinkData setFieldImageLayerSpecs(List<AdCreativeLinkDataImageLayerSpec> value) {
        this.mImageLayerSpecs = value;
        return this;
    }

    public AdCreativeLinkData setFieldImageLayerSpecs(String value) {
        Type type = new TypeToken<List<AdCreativeLinkDataImageLayerSpec>>(){}.getType();
        this.mImageLayerSpecs = (List)AdCreativeLinkDataImageLayerSpec.getGson().fromJson(value, type);
        return this;
    }

    public AdCreativeLinkDataImageOverlaySpec getFieldImageOverlaySpec() {
        return this.mImageOverlaySpec;
    }

    public AdCreativeLinkData setFieldImageOverlaySpec(AdCreativeLinkDataImageOverlaySpec value) {
        this.mImageOverlaySpec = value;
        return this;
    }

    public AdCreativeLinkData setFieldImageOverlaySpec(String value) {
        Type type = new TypeToken<AdCreativeLinkDataImageOverlaySpec>(){}.getType();
        this.mImageOverlaySpec = (AdCreativeLinkDataImageOverlaySpec)AdCreativeLinkDataImageOverlaySpec.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldLink() {
        return this.mLink;
    }

    public AdCreativeLinkData setFieldLink(String value) {
        this.mLink = value;
        return this;
    }

    public String getFieldMessage() {
        return this.mMessage;
    }

    public AdCreativeLinkData setFieldMessage(String value) {
        this.mMessage = value;
        return this;
    }

    public Boolean getFieldMultiShareEndCard() {
        return this.mMultiShareEndCard;
    }

    public AdCreativeLinkData setFieldMultiShareEndCard(Boolean value) {
        this.mMultiShareEndCard = value;
        return this;
    }

    public Boolean getFieldMultiShareOptimized() {
        return this.mMultiShareOptimized;
    }

    public AdCreativeLinkData setFieldMultiShareOptimized(Boolean value) {
        this.mMultiShareOptimized = value;
        return this;
    }

    public String getFieldName() {
        return this.mName;
    }

    public AdCreativeLinkData setFieldName(String value) {
        this.mName = value;
        return this;
    }

    public String getFieldOfferId() {
        return this.mOfferId;
    }

    public AdCreativeLinkData setFieldOfferId(String value) {
        this.mOfferId = value;
        return this;
    }

    public String getFieldPageWelcomeMessage() {
        return this.mPageWelcomeMessage;
    }

    public AdCreativeLinkData setFieldPageWelcomeMessage(String value) {
        this.mPageWelcomeMessage = value;
        return this;
    }

    public String getFieldPicture() {
        return this.mPicture;
    }

    public AdCreativeLinkData setFieldPicture(String value) {
        this.mPicture = value;
        return this;
    }

    public AdCreativePostClickConfiguration getFieldPostClickConfiguration() {
        return this.mPostClickConfiguration;
    }

    public AdCreativeLinkData setFieldPostClickConfiguration(AdCreativePostClickConfiguration value) {
        this.mPostClickConfiguration = value;
        return this;
    }

    public AdCreativeLinkData setFieldPostClickConfiguration(String value) {
        Type type = new TypeToken<AdCreativePostClickConfiguration>(){}.getType();
        this.mPostClickConfiguration = (AdCreativePostClickConfiguration)AdCreativePostClickConfiguration.getGson().fromJson(value, type);
        return this;
    }

    public List<String> getFieldPreferredImageTags() {
        return this.mPreferredImageTags;
    }

    public AdCreativeLinkData setFieldPreferredImageTags(List<String> value) {
        this.mPreferredImageTags = value;
        return this;
    }

    public List<String> getFieldRetailerItemIds() {
        return this.mRetailerItemIds;
    }

    public AdCreativeLinkData setFieldRetailerItemIds(List<String> value) {
        this.mRetailerItemIds = value;
        return this;
    }

    public Boolean getFieldShowMultipleImages() {
        return this.mShowMultipleImages;
    }

    public AdCreativeLinkData setFieldShowMultipleImages(Boolean value) {
        this.mShowMultipleImages = value;
        return this;
    }

    public AdCreativeLinkDataSponsorshipInfoSpec getFieldSponsorshipInfo() {
        return this.mSponsorshipInfo;
    }

    public AdCreativeLinkData setFieldSponsorshipInfo(AdCreativeLinkDataSponsorshipInfoSpec value) {
        this.mSponsorshipInfo = value;
        return this;
    }

    public AdCreativeLinkData setFieldSponsorshipInfo(String value) {
        Type type = new TypeToken<AdCreativeLinkDataSponsorshipInfoSpec>(){}.getType();
        this.mSponsorshipInfo = (AdCreativeLinkDataSponsorshipInfoSpec)AdCreativeLinkDataSponsorshipInfoSpec.getGson().fromJson(value, type);
        return this;
    }

    public AdCreativeStaticFallbackSpec getFieldStaticFallbackSpec() {
        return this.mStaticFallbackSpec;
    }

    public AdCreativeLinkData setFieldStaticFallbackSpec(AdCreativeStaticFallbackSpec value) {
        this.mStaticFallbackSpec = value;
        return this;
    }

    public AdCreativeLinkData setFieldStaticFallbackSpec(String value) {
        Type type = new TypeToken<AdCreativeStaticFallbackSpec>(){}.getType();
        this.mStaticFallbackSpec = (AdCreativeStaticFallbackSpec)AdCreativeStaticFallbackSpec.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public AdCreativeLinkData setFieldId(String value) {
        this.mId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdCreativeLinkData copyFrom(AdCreativeLinkData instance) {
        this.mAdditionalImageIndex = instance.mAdditionalImageIndex;
        this.mAppLinkSpec = instance.mAppLinkSpec;
        this.mAttachmentStyle = instance.mAttachmentStyle;
        this.mBrandedContentSharedToSponsorStatus = instance.mBrandedContentSharedToSponsorStatus;
        this.mBrandedContentSponsorPageId = instance.mBrandedContentSponsorPageId;
        this.mBrandedContentSponsorRelationship = instance.mBrandedContentSponsorRelationship;
        this.mCallToAction = instance.mCallToAction;
        this.mCaption = instance.mCaption;
        this.mChildAttachments = instance.mChildAttachments;
        this.mCollectionThumbnails = instance.mCollectionThumbnails;
        this.mCustomOverlaySpec = instance.mCustomOverlaySpec;
        this.mCustomizationRulesSpec = instance.mCustomizationRulesSpec;
        this.mDescription = instance.mDescription;
        this.mEventId = instance.mEventId;
        this.mForceSingleLink = instance.mForceSingleLink;
        this.mFormatOption = instance.mFormatOption;
        this.mImageCrops = instance.mImageCrops;
        this.mImageHash = instance.mImageHash;
        this.mImageLayerSpecs = instance.mImageLayerSpecs;
        this.mImageOverlaySpec = instance.mImageOverlaySpec;
        this.mLink = instance.mLink;
        this.mMessage = instance.mMessage;
        this.mMultiShareEndCard = instance.mMultiShareEndCard;
        this.mMultiShareOptimized = instance.mMultiShareOptimized;
        this.mName = instance.mName;
        this.mOfferId = instance.mOfferId;
        this.mPageWelcomeMessage = instance.mPageWelcomeMessage;
        this.mPicture = instance.mPicture;
        this.mPostClickConfiguration = instance.mPostClickConfiguration;
        this.mPreferredImageTags = instance.mPreferredImageTags;
        this.mRetailerItemIds = instance.mRetailerItemIds;
        this.mShowMultipleImages = instance.mShowMultipleImages;
        this.mSponsorshipInfo = instance.mSponsorshipInfo;
        this.mStaticFallbackSpec = instance.mStaticFallbackSpec;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdCreativeLinkData> getParser() {
        return new APIRequest.ResponseParser<AdCreativeLinkData>(){

            @Override
            public APINodeList<AdCreativeLinkData> parseResponse(String response, APIContext context, APIRequest<AdCreativeLinkData> request) throws APIException.MalformedResponseException {
                return AdCreativeLinkData.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumFormatOption {
        VALUE_CAROUSEL_IMAGES_MULTI_ITEMS("carousel_images_multi_items"),
        VALUE_CAROUSEL_IMAGES_SINGLE_ITEM("carousel_images_single_item"),
        VALUE_CAROUSEL_SLIDESHOWS("carousel_slideshows"),
        VALUE_SINGLE_IMAGE("single_image"),
        NULL(null);

        private String value;

        private EnumFormatOption(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumAttachmentStyle {
        VALUE_LINK("link"),
        VALUE_DEFAULT("default"),
        NULL(null);

        private String value;

        private EnumAttachmentStyle(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

