/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserNuxStatuses
extends APINode {
    @SerializedName(value="max_views")
    private Long mMaxViews = null;
    @SerializedName(value="nux_data")
    private Object mNuxData = null;
    @SerializedName(value="nux_id")
    private String mNuxId = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    UserNuxStatuses() {
    }

    public UserNuxStatuses(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public UserNuxStatuses(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public UserNuxStatuses fetch() throws APIException {
        UserNuxStatuses newInstance = UserNuxStatuses.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static UserNuxStatuses fetchById(Long id, APIContext context) throws APIException {
        return UserNuxStatuses.fetchById(id.toString(), context);
    }

    public static ListenableFuture<UserNuxStatuses> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return UserNuxStatuses.fetchByIdAsync(id.toString(), context);
    }

    public static UserNuxStatuses fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<UserNuxStatuses> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<UserNuxStatuses> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<UserNuxStatuses>(context, "", "/", "GET", UserNuxStatuses.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<UserNuxStatuses>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<UserNuxStatuses>(context, "", "/", "GET", UserNuxStatuses.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static UserNuxStatuses loadJSON(String json, APIContext context) {
        UserNuxStatuses userNuxStatuses = (UserNuxStatuses)UserNuxStatuses.getGson().fromJson(json, UserNuxStatuses.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(userNuxStatuses.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        userNuxStatuses.context = context;
        userNuxStatuses.rawValue = json;
        return userNuxStatuses;
    }

    public static APINodeList<UserNuxStatuses> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<UserNuxStatuses> userNuxStatusess = new APINodeList<UserNuxStatuses>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        userNuxStatusess.add(UserNuxStatuses.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return userNuxStatusess;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            userNuxStatusess.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        userNuxStatusess.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            userNuxStatusess.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            userNuxStatusess.add(UserNuxStatuses.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                userNuxStatusess.add(UserNuxStatuses.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            userNuxStatusess.add(UserNuxStatuses.loadJSON(obj.toString(), context));
                        }
                    }
                    return userNuxStatusess;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        userNuxStatusess.add(UserNuxStatuses.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return userNuxStatusess;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        userNuxStatusess.add(UserNuxStatuses.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return userNuxStatusess;
                }
                userNuxStatusess.clear();
                userNuxStatusess.add(UserNuxStatuses.loadJSON(json, context));
                return userNuxStatusess;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return UserNuxStatuses.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Long getFieldMaxViews() {
        return this.mMaxViews;
    }

    public Object getFieldNuxData() {
        return this.mNuxData;
    }

    public String getFieldNuxId() {
        return this.mNuxId;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public UserNuxStatuses copyFrom(UserNuxStatuses instance) {
        this.mMaxViews = instance.mMaxViews;
        this.mNuxData = instance.mNuxData;
        this.mNuxId = instance.mNuxId;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<UserNuxStatuses> getParser() {
        return new APIRequest.ResponseParser<UserNuxStatuses>(){

            @Override
            public APINodeList<UserNuxStatuses> parseResponse(String response, APIContext context, APIRequest<UserNuxStatuses> request) throws APIException.MalformedResponseException {
                return UserNuxStatuses.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<UserNuxStatuses> {
        UserNuxStatuses lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"max_views", "nux_data", "nux_id", "id"};

        @Override
        public UserNuxStatuses getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public UserNuxStatuses parseResponse(String response) throws APIException {
            return UserNuxStatuses.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public UserNuxStatuses execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public UserNuxStatuses execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<UserNuxStatuses> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<UserNuxStatuses> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, UserNuxStatuses>(){

                public UserNuxStatuses apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestMaxViewsField() {
            return this.requestMaxViewsField(true);
        }

        public APIRequestGet requestMaxViewsField(boolean value) {
            this.requestField("max_views", value);
            return this;
        }

        public APIRequestGet requestNuxDataField() {
            return this.requestNuxDataField(true);
        }

        public APIRequestGet requestNuxDataField(boolean value) {
            this.requestField("nux_data", value);
            return this;
        }

        public APIRequestGet requestNuxIdField() {
            return this.requestNuxIdField(true);
        }

        public APIRequestGet requestNuxIdField(boolean value) {
            this.requestField("nux_id", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

