/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimezoneOffset
extends APINode {
    @SerializedName(value="abbr")
    private String mAbbr = null;
    @SerializedName(value="isdst")
    private Boolean mIsdst = null;
    @SerializedName(value="offset")
    private Long mOffset = null;
    @SerializedName(value="time")
    private String mTime = null;
    @SerializedName(value="ts")
    private Long mTs = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    TimezoneOffset() {
    }

    public TimezoneOffset(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public TimezoneOffset(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public TimezoneOffset fetch() throws APIException {
        TimezoneOffset newInstance = TimezoneOffset.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static TimezoneOffset fetchById(Long id, APIContext context) throws APIException {
        return TimezoneOffset.fetchById(id.toString(), context);
    }

    public static ListenableFuture<TimezoneOffset> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return TimezoneOffset.fetchByIdAsync(id.toString(), context);
    }

    public static TimezoneOffset fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<TimezoneOffset> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<TimezoneOffset> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<TimezoneOffset>(context, "", "/", "GET", TimezoneOffset.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<TimezoneOffset>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<TimezoneOffset>(context, "", "/", "GET", TimezoneOffset.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static TimezoneOffset loadJSON(String json, APIContext context) {
        TimezoneOffset timezoneOffset = (TimezoneOffset)TimezoneOffset.getGson().fromJson(json, TimezoneOffset.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(timezoneOffset.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        timezoneOffset.context = context;
        timezoneOffset.rawValue = json;
        return timezoneOffset;
    }

    public static APINodeList<TimezoneOffset> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<TimezoneOffset> timezoneOffsets = new APINodeList<TimezoneOffset>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        timezoneOffsets.add(TimezoneOffset.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return timezoneOffsets;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            timezoneOffsets.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        timezoneOffsets.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            timezoneOffsets.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            timezoneOffsets.add(TimezoneOffset.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                timezoneOffsets.add(TimezoneOffset.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            timezoneOffsets.add(TimezoneOffset.loadJSON(obj.toString(), context));
                        }
                    }
                    return timezoneOffsets;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        timezoneOffsets.add(TimezoneOffset.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return timezoneOffsets;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        timezoneOffsets.add(TimezoneOffset.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return timezoneOffsets;
                }
                timezoneOffsets.clear();
                timezoneOffsets.add(TimezoneOffset.loadJSON(json, context));
                return timezoneOffsets;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return TimezoneOffset.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAbbr() {
        return this.mAbbr;
    }

    public Boolean getFieldIsdst() {
        return this.mIsdst;
    }

    public Long getFieldOffset() {
        return this.mOffset;
    }

    public String getFieldTime() {
        return this.mTime;
    }

    public Long getFieldTs() {
        return this.mTs;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public TimezoneOffset copyFrom(TimezoneOffset instance) {
        this.mAbbr = instance.mAbbr;
        this.mIsdst = instance.mIsdst;
        this.mOffset = instance.mOffset;
        this.mTime = instance.mTime;
        this.mTs = instance.mTs;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<TimezoneOffset> getParser() {
        return new APIRequest.ResponseParser<TimezoneOffset>(){

            @Override
            public APINodeList<TimezoneOffset> parseResponse(String response, APIContext context, APIRequest<TimezoneOffset> request) throws APIException.MalformedResponseException {
                return TimezoneOffset.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<TimezoneOffset> {
        TimezoneOffset lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"abbr", "isdst", "offset", "time", "ts", "id"};

        @Override
        public TimezoneOffset getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public TimezoneOffset parseResponse(String response) throws APIException {
            return TimezoneOffset.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public TimezoneOffset execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public TimezoneOffset execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<TimezoneOffset> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<TimezoneOffset> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, TimezoneOffset>(){

                public TimezoneOffset apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAbbrField() {
            return this.requestAbbrField(true);
        }

        public APIRequestGet requestAbbrField(boolean value) {
            this.requestField("abbr", value);
            return this;
        }

        public APIRequestGet requestIsdstField() {
            return this.requestIsdstField(true);
        }

        public APIRequestGet requestIsdstField(boolean value) {
            this.requestField("isdst", value);
            return this;
        }

        public APIRequestGet requestOffsetField() {
            return this.requestOffsetField(true);
        }

        public APIRequestGet requestOffsetField(boolean value) {
            this.requestField("offset", value);
            return this;
        }

        public APIRequestGet requestTimeField() {
            return this.requestTimeField(true);
        }

        public APIRequestGet requestTimeField(boolean value) {
            this.requestField("time", value);
            return this;
        }

        public APIRequestGet requestTsField() {
            return this.requestTsField(true);
        }

        public APIRequestGet requestTsField(boolean value) {
            this.requestField("ts", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

