/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Application;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tab
extends APINode {
    @SerializedName(value="application")
    private Application mApplication = null;
    @SerializedName(value="custom_image_url")
    private String mCustomImageUrl = null;
    @SerializedName(value="custom_name")
    private String mCustomName = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="image_url")
    private String mImageUrl = null;
    @SerializedName(value="is_non_connection_landing_tab")
    private Boolean mIsNonConnectionLandingTab = null;
    @SerializedName(value="is_permanent")
    private Boolean mIsPermanent = null;
    @SerializedName(value="link")
    private String mLink = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="position")
    private Long mPosition = null;
    protected static Gson gson = null;

    Tab() {
    }

    public Tab(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public Tab(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public Tab fetch() throws APIException {
        Tab newInstance = Tab.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static Tab fetchById(Long id, APIContext context) throws APIException {
        return Tab.fetchById(id.toString(), context);
    }

    public static ListenableFuture<Tab> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return Tab.fetchByIdAsync(id.toString(), context);
    }

    public static Tab fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<Tab> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<Tab> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<Tab>(context, "", "/", "GET", Tab.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<Tab>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<Tab>(context, "", "/", "GET", Tab.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static Tab loadJSON(String json, APIContext context) {
        Tab tab = (Tab)Tab.getGson().fromJson(json, Tab.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(tab.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        tab.context = context;
        tab.rawValue = json;
        return tab;
    }

    public static APINodeList<Tab> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<Tab> tabs = new APINodeList<Tab>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        tabs.add(Tab.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return tabs;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            tabs.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        tabs.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            tabs.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            tabs.add(Tab.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                tabs.add(Tab.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            tabs.add(Tab.loadJSON(obj.toString(), context));
                        }
                    }
                    return tabs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        tabs.add(Tab.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return tabs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        tabs.add(Tab.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return tabs;
                }
                tabs.clear();
                tabs.add(Tab.loadJSON(json, context));
                return tabs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return Tab.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Application getFieldApplication() {
        if (this.mApplication != null) {
            this.mApplication.context = this.getContext();
        }
        return this.mApplication;
    }

    public String getFieldCustomImageUrl() {
        return this.mCustomImageUrl;
    }

    public String getFieldCustomName() {
        return this.mCustomName;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldImageUrl() {
        return this.mImageUrl;
    }

    public Boolean getFieldIsNonConnectionLandingTab() {
        return this.mIsNonConnectionLandingTab;
    }

    public Boolean getFieldIsPermanent() {
        return this.mIsPermanent;
    }

    public String getFieldLink() {
        return this.mLink;
    }

    public String getFieldName() {
        return this.mName;
    }

    public Long getFieldPosition() {
        return this.mPosition;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public Tab copyFrom(Tab instance) {
        this.mApplication = instance.mApplication;
        this.mCustomImageUrl = instance.mCustomImageUrl;
        this.mCustomName = instance.mCustomName;
        this.mId = instance.mId;
        this.mImageUrl = instance.mImageUrl;
        this.mIsNonConnectionLandingTab = instance.mIsNonConnectionLandingTab;
        this.mIsPermanent = instance.mIsPermanent;
        this.mLink = instance.mLink;
        this.mName = instance.mName;
        this.mPosition = instance.mPosition;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<Tab> getParser() {
        return new APIRequest.ResponseParser<Tab>(){

            @Override
            public APINodeList<Tab> parseResponse(String response, APIContext context, APIRequest<Tab> request) throws APIException.MalformedResponseException {
                return Tab.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<Tab> {
        Tab lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"application", "custom_image_url", "custom_name", "id", "image_url", "is_non_connection_landing_tab", "is_permanent", "link", "name", "position"};

        @Override
        public Tab getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public Tab parseResponse(String response) throws APIException {
            return Tab.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public Tab execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public Tab execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<Tab> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<Tab> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, Tab>(){

                public Tab apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestApplicationField() {
            return this.requestApplicationField(true);
        }

        public APIRequestGet requestApplicationField(boolean value) {
            this.requestField("application", value);
            return this;
        }

        public APIRequestGet requestCustomImageUrlField() {
            return this.requestCustomImageUrlField(true);
        }

        public APIRequestGet requestCustomImageUrlField(boolean value) {
            this.requestField("custom_image_url", value);
            return this;
        }

        public APIRequestGet requestCustomNameField() {
            return this.requestCustomNameField(true);
        }

        public APIRequestGet requestCustomNameField(boolean value) {
            this.requestField("custom_name", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestImageUrlField() {
            return this.requestImageUrlField(true);
        }

        public APIRequestGet requestImageUrlField(boolean value) {
            this.requestField("image_url", value);
            return this;
        }

        public APIRequestGet requestIsNonConnectionLandingTabField() {
            return this.requestIsNonConnectionLandingTabField(true);
        }

        public APIRequestGet requestIsNonConnectionLandingTabField(boolean value) {
            this.requestField("is_non_connection_landing_tab", value);
            return this;
        }

        public APIRequestGet requestIsPermanentField() {
            return this.requestIsPermanentField(true);
        }

        public APIRequestGet requestIsPermanentField(boolean value) {
            this.requestField("is_permanent", value);
            return this;
        }

        public APIRequestGet requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGet requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestPositionField() {
            return this.requestPositionField(true);
        }

        public APIRequestGet requestPositionField(boolean value) {
            this.requestField("position", value);
            return this;
        }
    }
}

