/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevSharePolicy
extends APINode {
    @SerializedName(value="policy_id")
    private String mPolicyId = null;
    @SerializedName(value="policy_name")
    private String mPolicyName = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    RevSharePolicy() {
    }

    public RevSharePolicy(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public RevSharePolicy(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public RevSharePolicy fetch() throws APIException {
        RevSharePolicy newInstance = RevSharePolicy.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static RevSharePolicy fetchById(Long id, APIContext context) throws APIException {
        return RevSharePolicy.fetchById(id.toString(), context);
    }

    public static ListenableFuture<RevSharePolicy> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return RevSharePolicy.fetchByIdAsync(id.toString(), context);
    }

    public static RevSharePolicy fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<RevSharePolicy> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<RevSharePolicy> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<RevSharePolicy>(context, "", "/", "GET", RevSharePolicy.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<RevSharePolicy>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<RevSharePolicy>(context, "", "/", "GET", RevSharePolicy.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static RevSharePolicy loadJSON(String json, APIContext context) {
        RevSharePolicy revSharePolicy = (RevSharePolicy)RevSharePolicy.getGson().fromJson(json, RevSharePolicy.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(revSharePolicy.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        revSharePolicy.context = context;
        revSharePolicy.rawValue = json;
        return revSharePolicy;
    }

    public static APINodeList<RevSharePolicy> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<RevSharePolicy> revSharePolicys = new APINodeList<RevSharePolicy>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        revSharePolicys.add(RevSharePolicy.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return revSharePolicys;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            revSharePolicys.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        revSharePolicys.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            revSharePolicys.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            revSharePolicys.add(RevSharePolicy.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                revSharePolicys.add(RevSharePolicy.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            revSharePolicys.add(RevSharePolicy.loadJSON(obj.toString(), context));
                        }
                    }
                    return revSharePolicys;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        revSharePolicys.add(RevSharePolicy.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return revSharePolicys;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        revSharePolicys.add(RevSharePolicy.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return revSharePolicys;
                }
                revSharePolicys.clear();
                revSharePolicys.add(RevSharePolicy.loadJSON(json, context));
                return revSharePolicys;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return RevSharePolicy.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldPolicyId() {
        return this.mPolicyId;
    }

    public String getFieldPolicyName() {
        return this.mPolicyName;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public RevSharePolicy copyFrom(RevSharePolicy instance) {
        this.mPolicyId = instance.mPolicyId;
        this.mPolicyName = instance.mPolicyName;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<RevSharePolicy> getParser() {
        return new APIRequest.ResponseParser<RevSharePolicy>(){

            @Override
            public APINodeList<RevSharePolicy> parseResponse(String response, APIContext context, APIRequest<RevSharePolicy> request) throws APIException.MalformedResponseException {
                return RevSharePolicy.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<RevSharePolicy> {
        RevSharePolicy lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"policy_id", "policy_name", "id"};

        @Override
        public RevSharePolicy getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public RevSharePolicy parseResponse(String response) throws APIException {
            return RevSharePolicy.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public RevSharePolicy execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public RevSharePolicy execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<RevSharePolicy> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<RevSharePolicy> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, RevSharePolicy>(){

                public RevSharePolicy apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestPolicyIdField() {
            return this.requestPolicyIdField(true);
        }

        public APIRequestGet requestPolicyIdField(boolean value) {
            this.requestField("policy_id", value);
            return this;
        }

        public APIRequestGet requestPolicyNameField() {
            return this.requestPolicyNameField(true);
        }

        public APIRequestGet requestPolicyNameField(boolean value) {
            this.requestField("policy_name", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

