/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.User;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Recommendation
extends APINode {
    @SerializedName(value="created_time")
    private String mCreatedTime = null;
    @SerializedName(value="has_rating")
    private Boolean mHasRating = null;
    @SerializedName(value="has_review")
    private Boolean mHasReview = null;
    @SerializedName(value="open_graph_story")
    private Object mOpenGraphStory = null;
    @SerializedName(value="rating")
    private Long mRating = null;
    @SerializedName(value="recommendation_type")
    private String mRecommendationType = null;
    @SerializedName(value="review_text")
    private String mReviewText = null;
    @SerializedName(value="reviewer")
    private User mReviewer = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    Recommendation() {
    }

    public Recommendation(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public Recommendation(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public Recommendation fetch() throws APIException {
        Recommendation newInstance = Recommendation.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static Recommendation fetchById(Long id, APIContext context) throws APIException {
        return Recommendation.fetchById(id.toString(), context);
    }

    public static ListenableFuture<Recommendation> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return Recommendation.fetchByIdAsync(id.toString(), context);
    }

    public static Recommendation fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<Recommendation> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<Recommendation> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<Recommendation>(context, "", "/", "GET", Recommendation.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<Recommendation>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<Recommendation>(context, "", "/", "GET", Recommendation.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static Recommendation loadJSON(String json, APIContext context) {
        Recommendation recommendation = (Recommendation)Recommendation.getGson().fromJson(json, Recommendation.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(recommendation.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        recommendation.context = context;
        recommendation.rawValue = json;
        return recommendation;
    }

    public static APINodeList<Recommendation> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<Recommendation> recommendations = new APINodeList<Recommendation>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        recommendations.add(Recommendation.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return recommendations;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            recommendations.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        recommendations.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            recommendations.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            recommendations.add(Recommendation.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                recommendations.add(Recommendation.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            recommendations.add(Recommendation.loadJSON(obj.toString(), context));
                        }
                    }
                    return recommendations;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        recommendations.add(Recommendation.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return recommendations;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        recommendations.add(Recommendation.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return recommendations;
                }
                recommendations.clear();
                recommendations.add(Recommendation.loadJSON(json, context));
                return recommendations;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return Recommendation.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldCreatedTime() {
        return this.mCreatedTime;
    }

    public Boolean getFieldHasRating() {
        return this.mHasRating;
    }

    public Boolean getFieldHasReview() {
        return this.mHasReview;
    }

    public Object getFieldOpenGraphStory() {
        return this.mOpenGraphStory;
    }

    public Long getFieldRating() {
        return this.mRating;
    }

    public String getFieldRecommendationType() {
        return this.mRecommendationType;
    }

    public String getFieldReviewText() {
        return this.mReviewText;
    }

    public User getFieldReviewer() {
        if (this.mReviewer != null) {
            this.mReviewer.context = this.getContext();
        }
        return this.mReviewer;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public Recommendation copyFrom(Recommendation instance) {
        this.mCreatedTime = instance.mCreatedTime;
        this.mHasRating = instance.mHasRating;
        this.mHasReview = instance.mHasReview;
        this.mOpenGraphStory = instance.mOpenGraphStory;
        this.mRating = instance.mRating;
        this.mRecommendationType = instance.mRecommendationType;
        this.mReviewText = instance.mReviewText;
        this.mReviewer = instance.mReviewer;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<Recommendation> getParser() {
        return new APIRequest.ResponseParser<Recommendation>(){

            @Override
            public APINodeList<Recommendation> parseResponse(String response, APIContext context, APIRequest<Recommendation> request) throws APIException.MalformedResponseException {
                return Recommendation.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<Recommendation> {
        Recommendation lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"created_time", "has_rating", "has_review", "open_graph_story", "rating", "recommendation_type", "review_text", "reviewer", "id"};

        @Override
        public Recommendation getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public Recommendation parseResponse(String response) throws APIException {
            return Recommendation.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public Recommendation execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public Recommendation execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<Recommendation> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<Recommendation> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, Recommendation>(){

                public Recommendation apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGet requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGet requestHasRatingField() {
            return this.requestHasRatingField(true);
        }

        public APIRequestGet requestHasRatingField(boolean value) {
            this.requestField("has_rating", value);
            return this;
        }

        public APIRequestGet requestHasReviewField() {
            return this.requestHasReviewField(true);
        }

        public APIRequestGet requestHasReviewField(boolean value) {
            this.requestField("has_review", value);
            return this;
        }

        public APIRequestGet requestOpenGraphStoryField() {
            return this.requestOpenGraphStoryField(true);
        }

        public APIRequestGet requestOpenGraphStoryField(boolean value) {
            this.requestField("open_graph_story", value);
            return this;
        }

        public APIRequestGet requestRatingField() {
            return this.requestRatingField(true);
        }

        public APIRequestGet requestRatingField(boolean value) {
            this.requestField("rating", value);
            return this;
        }

        public APIRequestGet requestRecommendationTypeField() {
            return this.requestRecommendationTypeField(true);
        }

        public APIRequestGet requestRecommendationTypeField(boolean value) {
            this.requestField("recommendation_type", value);
            return this;
        }

        public APIRequestGet requestReviewTextField() {
            return this.requestReviewTextField(true);
        }

        public APIRequestGet requestReviewTextField(boolean value) {
            this.requestField("review_text", value);
            return this;
        }

        public APIRequestGet requestReviewerField() {
            return this.requestReviewerField(true);
        }

        public APIRequestGet requestReviewerField(boolean value) {
            this.requestField("reviewer", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

