/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReachFrequencyEstimatesPlacementBreakdown
extends APINode {
    @SerializedName(value="android")
    private List<Double> mAndroid = null;
    @SerializedName(value="audience_network")
    private List<Double> mAudienceNetwork = null;
    @SerializedName(value="desktop")
    private List<Double> mDesktop = null;
    @SerializedName(value="ig_android")
    private List<Double> mIgAndroid = null;
    @SerializedName(value="ig_ios")
    private List<Double> mIgIos = null;
    @SerializedName(value="ig_other")
    private List<Double> mIgOther = null;
    @SerializedName(value="ig_story")
    private List<Double> mIgStory = null;
    @SerializedName(value="instant_articles")
    private List<Double> mInstantArticles = null;
    @SerializedName(value="instream_videos")
    private List<Double> mInstreamVideos = null;
    @SerializedName(value="ios")
    private List<Double> mIos = null;
    @SerializedName(value="msite")
    private List<Double> mMsite = null;
    @SerializedName(value="suggested_videos")
    private List<Double> mSuggestedVideos = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    ReachFrequencyEstimatesPlacementBreakdown() {
    }

    public ReachFrequencyEstimatesPlacementBreakdown(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public ReachFrequencyEstimatesPlacementBreakdown(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public ReachFrequencyEstimatesPlacementBreakdown fetch() throws APIException {
        ReachFrequencyEstimatesPlacementBreakdown newInstance = ReachFrequencyEstimatesPlacementBreakdown.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static ReachFrequencyEstimatesPlacementBreakdown fetchById(Long id, APIContext context) throws APIException {
        return ReachFrequencyEstimatesPlacementBreakdown.fetchById(id.toString(), context);
    }

    public static ListenableFuture<ReachFrequencyEstimatesPlacementBreakdown> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return ReachFrequencyEstimatesPlacementBreakdown.fetchByIdAsync(id.toString(), context);
    }

    public static ReachFrequencyEstimatesPlacementBreakdown fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<ReachFrequencyEstimatesPlacementBreakdown> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<ReachFrequencyEstimatesPlacementBreakdown> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<ReachFrequencyEstimatesPlacementBreakdown>(context, "", "/", "GET", ReachFrequencyEstimatesPlacementBreakdown.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<ReachFrequencyEstimatesPlacementBreakdown>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<ReachFrequencyEstimatesPlacementBreakdown>(context, "", "/", "GET", ReachFrequencyEstimatesPlacementBreakdown.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static ReachFrequencyEstimatesPlacementBreakdown loadJSON(String json, APIContext context) {
        ReachFrequencyEstimatesPlacementBreakdown reachFrequencyEstimatesPlacementBreakdown = (ReachFrequencyEstimatesPlacementBreakdown)ReachFrequencyEstimatesPlacementBreakdown.getGson().fromJson(json, ReachFrequencyEstimatesPlacementBreakdown.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(reachFrequencyEstimatesPlacementBreakdown.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        reachFrequencyEstimatesPlacementBreakdown.context = context;
        reachFrequencyEstimatesPlacementBreakdown.rawValue = json;
        return reachFrequencyEstimatesPlacementBreakdown;
    }

    public static APINodeList<ReachFrequencyEstimatesPlacementBreakdown> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ReachFrequencyEstimatesPlacementBreakdown> reachFrequencyEstimatesPlacementBreakdowns = new APINodeList<ReachFrequencyEstimatesPlacementBreakdown>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        reachFrequencyEstimatesPlacementBreakdowns.add(ReachFrequencyEstimatesPlacementBreakdown.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return reachFrequencyEstimatesPlacementBreakdowns;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            reachFrequencyEstimatesPlacementBreakdowns.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        reachFrequencyEstimatesPlacementBreakdowns.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            reachFrequencyEstimatesPlacementBreakdowns.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            reachFrequencyEstimatesPlacementBreakdowns.add(ReachFrequencyEstimatesPlacementBreakdown.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                reachFrequencyEstimatesPlacementBreakdowns.add(ReachFrequencyEstimatesPlacementBreakdown.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            reachFrequencyEstimatesPlacementBreakdowns.add(ReachFrequencyEstimatesPlacementBreakdown.loadJSON(obj.toString(), context));
                        }
                    }
                    return reachFrequencyEstimatesPlacementBreakdowns;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        reachFrequencyEstimatesPlacementBreakdowns.add(ReachFrequencyEstimatesPlacementBreakdown.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return reachFrequencyEstimatesPlacementBreakdowns;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        reachFrequencyEstimatesPlacementBreakdowns.add(ReachFrequencyEstimatesPlacementBreakdown.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return reachFrequencyEstimatesPlacementBreakdowns;
                }
                reachFrequencyEstimatesPlacementBreakdowns.clear();
                reachFrequencyEstimatesPlacementBreakdowns.add(ReachFrequencyEstimatesPlacementBreakdown.loadJSON(json, context));
                return reachFrequencyEstimatesPlacementBreakdowns;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ReachFrequencyEstimatesPlacementBreakdown.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public List<Double> getFieldAndroid() {
        return this.mAndroid;
    }

    public List<Double> getFieldAudienceNetwork() {
        return this.mAudienceNetwork;
    }

    public List<Double> getFieldDesktop() {
        return this.mDesktop;
    }

    public List<Double> getFieldIgAndroid() {
        return this.mIgAndroid;
    }

    public List<Double> getFieldIgIos() {
        return this.mIgIos;
    }

    public List<Double> getFieldIgOther() {
        return this.mIgOther;
    }

    public List<Double> getFieldIgStory() {
        return this.mIgStory;
    }

    public List<Double> getFieldInstantArticles() {
        return this.mInstantArticles;
    }

    public List<Double> getFieldInstreamVideos() {
        return this.mInstreamVideos;
    }

    public List<Double> getFieldIos() {
        return this.mIos;
    }

    public List<Double> getFieldMsite() {
        return this.mMsite;
    }

    public List<Double> getFieldSuggestedVideos() {
        return this.mSuggestedVideos;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ReachFrequencyEstimatesPlacementBreakdown copyFrom(ReachFrequencyEstimatesPlacementBreakdown instance) {
        this.mAndroid = instance.mAndroid;
        this.mAudienceNetwork = instance.mAudienceNetwork;
        this.mDesktop = instance.mDesktop;
        this.mIgAndroid = instance.mIgAndroid;
        this.mIgIos = instance.mIgIos;
        this.mIgOther = instance.mIgOther;
        this.mIgStory = instance.mIgStory;
        this.mInstantArticles = instance.mInstantArticles;
        this.mInstreamVideos = instance.mInstreamVideos;
        this.mIos = instance.mIos;
        this.mMsite = instance.mMsite;
        this.mSuggestedVideos = instance.mSuggestedVideos;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ReachFrequencyEstimatesPlacementBreakdown> getParser() {
        return new APIRequest.ResponseParser<ReachFrequencyEstimatesPlacementBreakdown>(){

            @Override
            public APINodeList<ReachFrequencyEstimatesPlacementBreakdown> parseResponse(String response, APIContext context, APIRequest<ReachFrequencyEstimatesPlacementBreakdown> request) throws APIException.MalformedResponseException {
                return ReachFrequencyEstimatesPlacementBreakdown.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<ReachFrequencyEstimatesPlacementBreakdown> {
        ReachFrequencyEstimatesPlacementBreakdown lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"android", "audience_network", "desktop", "ig_android", "ig_ios", "ig_other", "ig_story", "instant_articles", "instream_videos", "ios", "msite", "suggested_videos", "id"};

        @Override
        public ReachFrequencyEstimatesPlacementBreakdown getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ReachFrequencyEstimatesPlacementBreakdown parseResponse(String response) throws APIException {
            return ReachFrequencyEstimatesPlacementBreakdown.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public ReachFrequencyEstimatesPlacementBreakdown execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ReachFrequencyEstimatesPlacementBreakdown execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<ReachFrequencyEstimatesPlacementBreakdown> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ReachFrequencyEstimatesPlacementBreakdown> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, ReachFrequencyEstimatesPlacementBreakdown>(){

                public ReachFrequencyEstimatesPlacementBreakdown apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAndroidField() {
            return this.requestAndroidField(true);
        }

        public APIRequestGet requestAndroidField(boolean value) {
            this.requestField("android", value);
            return this;
        }

        public APIRequestGet requestAudienceNetworkField() {
            return this.requestAudienceNetworkField(true);
        }

        public APIRequestGet requestAudienceNetworkField(boolean value) {
            this.requestField("audience_network", value);
            return this;
        }

        public APIRequestGet requestDesktopField() {
            return this.requestDesktopField(true);
        }

        public APIRequestGet requestDesktopField(boolean value) {
            this.requestField("desktop", value);
            return this;
        }

        public APIRequestGet requestIgAndroidField() {
            return this.requestIgAndroidField(true);
        }

        public APIRequestGet requestIgAndroidField(boolean value) {
            this.requestField("ig_android", value);
            return this;
        }

        public APIRequestGet requestIgIosField() {
            return this.requestIgIosField(true);
        }

        public APIRequestGet requestIgIosField(boolean value) {
            this.requestField("ig_ios", value);
            return this;
        }

        public APIRequestGet requestIgOtherField() {
            return this.requestIgOtherField(true);
        }

        public APIRequestGet requestIgOtherField(boolean value) {
            this.requestField("ig_other", value);
            return this;
        }

        public APIRequestGet requestIgStoryField() {
            return this.requestIgStoryField(true);
        }

        public APIRequestGet requestIgStoryField(boolean value) {
            this.requestField("ig_story", value);
            return this;
        }

        public APIRequestGet requestInstantArticlesField() {
            return this.requestInstantArticlesField(true);
        }

        public APIRequestGet requestInstantArticlesField(boolean value) {
            this.requestField("instant_articles", value);
            return this;
        }

        public APIRequestGet requestInstreamVideosField() {
            return this.requestInstreamVideosField(true);
        }

        public APIRequestGet requestInstreamVideosField(boolean value) {
            this.requestField("instream_videos", value);
            return this;
        }

        public APIRequestGet requestIosField() {
            return this.requestIosField(true);
        }

        public APIRequestGet requestIosField(boolean value) {
            this.requestField("ios", value);
            return this;
        }

        public APIRequestGet requestMsiteField() {
            return this.requestMsiteField(true);
        }

        public APIRequestGet requestMsiteField(boolean value) {
            this.requestField("msite", value);
            return this;
        }

        public APIRequestGet requestSuggestedVideosField() {
            return this.requestSuggestedVideosField(true);
        }

        public APIRequestGet requestSuggestedVideosField(boolean value) {
            this.requestField("suggested_videos", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

