/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReachFrequencyEstimatesCurve
extends APINode {
    @SerializedName(value="budget")
    private List<Long> mBudget = null;
    @SerializedName(value="click")
    private List<Long> mClick = null;
    @SerializedName(value="conversion")
    private List<Long> mConversion = null;
    @SerializedName(value="impression")
    private List<Long> mImpression = null;
    @SerializedName(value="interpolated_reach")
    private Double mInterpolatedReach = null;
    @SerializedName(value="num_points")
    private Long mNumPoints = null;
    @SerializedName(value="raw_impression")
    private List<Long> mRawImpression = null;
    @SerializedName(value="raw_reach")
    private List<Long> mRawReach = null;
    @SerializedName(value="reach")
    private List<Long> mReach = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    ReachFrequencyEstimatesCurve() {
    }

    public ReachFrequencyEstimatesCurve(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public ReachFrequencyEstimatesCurve(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public ReachFrequencyEstimatesCurve fetch() throws APIException {
        ReachFrequencyEstimatesCurve newInstance = ReachFrequencyEstimatesCurve.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static ReachFrequencyEstimatesCurve fetchById(Long id, APIContext context) throws APIException {
        return ReachFrequencyEstimatesCurve.fetchById(id.toString(), context);
    }

    public static ListenableFuture<ReachFrequencyEstimatesCurve> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return ReachFrequencyEstimatesCurve.fetchByIdAsync(id.toString(), context);
    }

    public static ReachFrequencyEstimatesCurve fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<ReachFrequencyEstimatesCurve> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<ReachFrequencyEstimatesCurve> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<ReachFrequencyEstimatesCurve>(context, "", "/", "GET", ReachFrequencyEstimatesCurve.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<ReachFrequencyEstimatesCurve>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<ReachFrequencyEstimatesCurve>(context, "", "/", "GET", ReachFrequencyEstimatesCurve.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static ReachFrequencyEstimatesCurve loadJSON(String json, APIContext context) {
        ReachFrequencyEstimatesCurve reachFrequencyEstimatesCurve = (ReachFrequencyEstimatesCurve)ReachFrequencyEstimatesCurve.getGson().fromJson(json, ReachFrequencyEstimatesCurve.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(reachFrequencyEstimatesCurve.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        reachFrequencyEstimatesCurve.context = context;
        reachFrequencyEstimatesCurve.rawValue = json;
        return reachFrequencyEstimatesCurve;
    }

    public static APINodeList<ReachFrequencyEstimatesCurve> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ReachFrequencyEstimatesCurve> reachFrequencyEstimatesCurves = new APINodeList<ReachFrequencyEstimatesCurve>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        reachFrequencyEstimatesCurves.add(ReachFrequencyEstimatesCurve.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return reachFrequencyEstimatesCurves;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            reachFrequencyEstimatesCurves.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        reachFrequencyEstimatesCurves.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            reachFrequencyEstimatesCurves.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            reachFrequencyEstimatesCurves.add(ReachFrequencyEstimatesCurve.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                reachFrequencyEstimatesCurves.add(ReachFrequencyEstimatesCurve.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            reachFrequencyEstimatesCurves.add(ReachFrequencyEstimatesCurve.loadJSON(obj.toString(), context));
                        }
                    }
                    return reachFrequencyEstimatesCurves;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        reachFrequencyEstimatesCurves.add(ReachFrequencyEstimatesCurve.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return reachFrequencyEstimatesCurves;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        reachFrequencyEstimatesCurves.add(ReachFrequencyEstimatesCurve.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return reachFrequencyEstimatesCurves;
                }
                reachFrequencyEstimatesCurves.clear();
                reachFrequencyEstimatesCurves.add(ReachFrequencyEstimatesCurve.loadJSON(json, context));
                return reachFrequencyEstimatesCurves;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ReachFrequencyEstimatesCurve.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public List<Long> getFieldBudget() {
        return this.mBudget;
    }

    public List<Long> getFieldClick() {
        return this.mClick;
    }

    public List<Long> getFieldConversion() {
        return this.mConversion;
    }

    public List<Long> getFieldImpression() {
        return this.mImpression;
    }

    public Double getFieldInterpolatedReach() {
        return this.mInterpolatedReach;
    }

    public Long getFieldNumPoints() {
        return this.mNumPoints;
    }

    public List<Long> getFieldRawImpression() {
        return this.mRawImpression;
    }

    public List<Long> getFieldRawReach() {
        return this.mRawReach;
    }

    public List<Long> getFieldReach() {
        return this.mReach;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ReachFrequencyEstimatesCurve copyFrom(ReachFrequencyEstimatesCurve instance) {
        this.mBudget = instance.mBudget;
        this.mClick = instance.mClick;
        this.mConversion = instance.mConversion;
        this.mImpression = instance.mImpression;
        this.mInterpolatedReach = instance.mInterpolatedReach;
        this.mNumPoints = instance.mNumPoints;
        this.mRawImpression = instance.mRawImpression;
        this.mRawReach = instance.mRawReach;
        this.mReach = instance.mReach;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ReachFrequencyEstimatesCurve> getParser() {
        return new APIRequest.ResponseParser<ReachFrequencyEstimatesCurve>(){

            @Override
            public APINodeList<ReachFrequencyEstimatesCurve> parseResponse(String response, APIContext context, APIRequest<ReachFrequencyEstimatesCurve> request) throws APIException.MalformedResponseException {
                return ReachFrequencyEstimatesCurve.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<ReachFrequencyEstimatesCurve> {
        ReachFrequencyEstimatesCurve lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"budget", "click", "conversion", "impression", "interpolated_reach", "num_points", "raw_impression", "raw_reach", "reach", "id"};

        @Override
        public ReachFrequencyEstimatesCurve getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ReachFrequencyEstimatesCurve parseResponse(String response) throws APIException {
            return ReachFrequencyEstimatesCurve.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public ReachFrequencyEstimatesCurve execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ReachFrequencyEstimatesCurve execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<ReachFrequencyEstimatesCurve> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ReachFrequencyEstimatesCurve> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, ReachFrequencyEstimatesCurve>(){

                public ReachFrequencyEstimatesCurve apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestBudgetField() {
            return this.requestBudgetField(true);
        }

        public APIRequestGet requestBudgetField(boolean value) {
            this.requestField("budget", value);
            return this;
        }

        public APIRequestGet requestClickField() {
            return this.requestClickField(true);
        }

        public APIRequestGet requestClickField(boolean value) {
            this.requestField("click", value);
            return this;
        }

        public APIRequestGet requestConversionField() {
            return this.requestConversionField(true);
        }

        public APIRequestGet requestConversionField(boolean value) {
            this.requestField("conversion", value);
            return this;
        }

        public APIRequestGet requestImpressionField() {
            return this.requestImpressionField(true);
        }

        public APIRequestGet requestImpressionField(boolean value) {
            this.requestField("impression", value);
            return this;
        }

        public APIRequestGet requestInterpolatedReachField() {
            return this.requestInterpolatedReachField(true);
        }

        public APIRequestGet requestInterpolatedReachField(boolean value) {
            this.requestField("interpolated_reach", value);
            return this;
        }

        public APIRequestGet requestNumPointsField() {
            return this.requestNumPointsField(true);
        }

        public APIRequestGet requestNumPointsField(boolean value) {
            this.requestField("num_points", value);
            return this;
        }

        public APIRequestGet requestRawImpressionField() {
            return this.requestRawImpressionField(true);
        }

        public APIRequestGet requestRawImpressionField(boolean value) {
            this.requestField("raw_impression", value);
            return this;
        }

        public APIRequestGet requestRawReachField() {
            return this.requestRawReachField(true);
        }

        public APIRequestGet requestRawReachField(boolean value) {
            this.requestField("raw_reach", value);
            return this;
        }

        public APIRequestGet requestReachField() {
            return this.requestReachField(true);
        }

        public APIRequestGet requestReachField(boolean value) {
            this.requestField("reach", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

