/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.ProductFeedUploadError;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductFeedUpload
extends APINode {
    @SerializedName(value="end_time")
    private String mEndTime = null;
    @SerializedName(value="error_count")
    private Long mErrorCount = null;
    @SerializedName(value="filename")
    private String mFilename = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="input_method")
    private EnumInputMethod mInputMethod = null;
    @SerializedName(value="num_deleted_items")
    private Long mNumDeletedItems = null;
    @SerializedName(value="num_detected_items")
    private Long mNumDetectedItems = null;
    @SerializedName(value="num_invalid_items")
    private Long mNumInvalidItems = null;
    @SerializedName(value="num_persisted_items")
    private Long mNumPersistedItems = null;
    @SerializedName(value="start_time")
    private String mStartTime = null;
    @SerializedName(value="url")
    private String mUrl = null;
    @SerializedName(value="warning_count")
    private Long mWarningCount = null;
    protected static Gson gson = null;

    ProductFeedUpload() {
    }

    public ProductFeedUpload(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public ProductFeedUpload(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public ProductFeedUpload fetch() throws APIException {
        ProductFeedUpload newInstance = ProductFeedUpload.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static ProductFeedUpload fetchById(Long id, APIContext context) throws APIException {
        return ProductFeedUpload.fetchById(id.toString(), context);
    }

    public static ListenableFuture<ProductFeedUpload> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return ProductFeedUpload.fetchByIdAsync(id.toString(), context);
    }

    public static ProductFeedUpload fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<ProductFeedUpload> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<ProductFeedUpload> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<ProductFeedUpload>(context, "", "/", "GET", ProductFeedUpload.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<ProductFeedUpload>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<ProductFeedUpload>(context, "", "/", "GET", ProductFeedUpload.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static ProductFeedUpload loadJSON(String json, APIContext context) {
        ProductFeedUpload productFeedUpload = (ProductFeedUpload)ProductFeedUpload.getGson().fromJson(json, ProductFeedUpload.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(productFeedUpload.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        productFeedUpload.context = context;
        productFeedUpload.rawValue = json;
        return productFeedUpload;
    }

    public static APINodeList<ProductFeedUpload> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ProductFeedUpload> productFeedUploads = new APINodeList<ProductFeedUpload>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        productFeedUploads.add(ProductFeedUpload.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return productFeedUploads;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            productFeedUploads.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        productFeedUploads.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            productFeedUploads.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            productFeedUploads.add(ProductFeedUpload.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                productFeedUploads.add(ProductFeedUpload.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            productFeedUploads.add(ProductFeedUpload.loadJSON(obj.toString(), context));
                        }
                    }
                    return productFeedUploads;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        productFeedUploads.add(ProductFeedUpload.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return productFeedUploads;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        productFeedUploads.add(ProductFeedUpload.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return productFeedUploads;
                }
                productFeedUploads.clear();
                productFeedUploads.add(ProductFeedUpload.loadJSON(json, context));
                return productFeedUploads;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ProductFeedUpload.getGson().toJson((Object)this);
    }

    public APIRequestGetErrors getErrors() {
        return new APIRequestGetErrors(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldEndTime() {
        return this.mEndTime;
    }

    public Long getFieldErrorCount() {
        return this.mErrorCount;
    }

    public String getFieldFilename() {
        return this.mFilename;
    }

    public String getFieldId() {
        return this.mId;
    }

    public EnumInputMethod getFieldInputMethod() {
        return this.mInputMethod;
    }

    public Long getFieldNumDeletedItems() {
        return this.mNumDeletedItems;
    }

    public Long getFieldNumDetectedItems() {
        return this.mNumDetectedItems;
    }

    public Long getFieldNumInvalidItems() {
        return this.mNumInvalidItems;
    }

    public Long getFieldNumPersistedItems() {
        return this.mNumPersistedItems;
    }

    public String getFieldStartTime() {
        return this.mStartTime;
    }

    public String getFieldUrl() {
        return this.mUrl;
    }

    public Long getFieldWarningCount() {
        return this.mWarningCount;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ProductFeedUpload copyFrom(ProductFeedUpload instance) {
        this.mEndTime = instance.mEndTime;
        this.mErrorCount = instance.mErrorCount;
        this.mFilename = instance.mFilename;
        this.mId = instance.mId;
        this.mInputMethod = instance.mInputMethod;
        this.mNumDeletedItems = instance.mNumDeletedItems;
        this.mNumDetectedItems = instance.mNumDetectedItems;
        this.mNumInvalidItems = instance.mNumInvalidItems;
        this.mNumPersistedItems = instance.mNumPersistedItems;
        this.mStartTime = instance.mStartTime;
        this.mUrl = instance.mUrl;
        this.mWarningCount = instance.mWarningCount;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ProductFeedUpload> getParser() {
        return new APIRequest.ResponseParser<ProductFeedUpload>(){

            @Override
            public APINodeList<ProductFeedUpload> parseResponse(String response, APIContext context, APIRequest<ProductFeedUpload> request) throws APIException.MalformedResponseException {
                return ProductFeedUpload.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumInputMethod {
        VALUE_MANUAL_UPLOAD("Manual Upload"),
        VALUE_SERVER_FETCH("Server Fetch"),
        VALUE_REUPLOAD_LAST_FILE("Reupload Last File"),
        VALUE_USER_INITIATED_SERVER_FETCH("User initiated server fetch"),
        NULL(null);

        private String value;

        private EnumInputMethod(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<ProductFeedUpload> {
        ProductFeedUpload lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"end_time", "error_count", "filename", "id", "input_method", "num_deleted_items", "num_detected_items", "num_invalid_items", "num_persisted_items", "start_time", "url", "warning_count"};

        @Override
        public ProductFeedUpload getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ProductFeedUpload parseResponse(String response) throws APIException {
            return ProductFeedUpload.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public ProductFeedUpload execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ProductFeedUpload execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<ProductFeedUpload> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ProductFeedUpload> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, ProductFeedUpload>(){

                public ProductFeedUpload apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestEndTimeField() {
            return this.requestEndTimeField(true);
        }

        public APIRequestGet requestEndTimeField(boolean value) {
            this.requestField("end_time", value);
            return this;
        }

        public APIRequestGet requestErrorCountField() {
            return this.requestErrorCountField(true);
        }

        public APIRequestGet requestErrorCountField(boolean value) {
            this.requestField("error_count", value);
            return this;
        }

        public APIRequestGet requestFilenameField() {
            return this.requestFilenameField(true);
        }

        public APIRequestGet requestFilenameField(boolean value) {
            this.requestField("filename", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestInputMethodField() {
            return this.requestInputMethodField(true);
        }

        public APIRequestGet requestInputMethodField(boolean value) {
            this.requestField("input_method", value);
            return this;
        }

        public APIRequestGet requestNumDeletedItemsField() {
            return this.requestNumDeletedItemsField(true);
        }

        public APIRequestGet requestNumDeletedItemsField(boolean value) {
            this.requestField("num_deleted_items", value);
            return this;
        }

        public APIRequestGet requestNumDetectedItemsField() {
            return this.requestNumDetectedItemsField(true);
        }

        public APIRequestGet requestNumDetectedItemsField(boolean value) {
            this.requestField("num_detected_items", value);
            return this;
        }

        public APIRequestGet requestNumInvalidItemsField() {
            return this.requestNumInvalidItemsField(true);
        }

        public APIRequestGet requestNumInvalidItemsField(boolean value) {
            this.requestField("num_invalid_items", value);
            return this;
        }

        public APIRequestGet requestNumPersistedItemsField() {
            return this.requestNumPersistedItemsField(true);
        }

        public APIRequestGet requestNumPersistedItemsField(boolean value) {
            this.requestField("num_persisted_items", value);
            return this;
        }

        public APIRequestGet requestStartTimeField() {
            return this.requestStartTimeField(true);
        }

        public APIRequestGet requestStartTimeField(boolean value) {
            this.requestField("start_time", value);
            return this;
        }

        public APIRequestGet requestUrlField() {
            return this.requestUrlField(true);
        }

        public APIRequestGet requestUrlField(boolean value) {
            this.requestField("url", value);
            return this;
        }

        public APIRequestGet requestWarningCountField() {
            return this.requestWarningCountField(true);
        }

        public APIRequestGet requestWarningCountField(boolean value) {
            this.requestField("warning_count", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetErrors
    extends APIRequest<ProductFeedUploadError> {
        APINodeList<ProductFeedUploadError> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"affected_surfaces", "column_number", "description", "error_type", "id", "row_number", "severity", "summary", "total_count"};

        @Override
        public APINodeList<ProductFeedUploadError> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<ProductFeedUploadError> parseResponse(String response) throws APIException {
            return ProductFeedUploadError.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<ProductFeedUploadError> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<ProductFeedUploadError> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<ProductFeedUploadError>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<ProductFeedUploadError>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<ProductFeedUploadError>>(){

                public APINodeList<ProductFeedUploadError> apply(String result) {
                    try {
                        return APIRequestGetErrors.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetErrors(String nodeId, APIContext context) {
            super(context, nodeId, "/errors", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetErrors setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetErrors setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetErrors requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetErrors requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetErrors requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetErrors requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetErrors requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetErrors requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetErrors requestAffectedSurfacesField() {
            return this.requestAffectedSurfacesField(true);
        }

        public APIRequestGetErrors requestAffectedSurfacesField(boolean value) {
            this.requestField("affected_surfaces", value);
            return this;
        }

        public APIRequestGetErrors requestColumnNumberField() {
            return this.requestColumnNumberField(true);
        }

        public APIRequestGetErrors requestColumnNumberField(boolean value) {
            this.requestField("column_number", value);
            return this;
        }

        public APIRequestGetErrors requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetErrors requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetErrors requestErrorTypeField() {
            return this.requestErrorTypeField(true);
        }

        public APIRequestGetErrors requestErrorTypeField(boolean value) {
            this.requestField("error_type", value);
            return this;
        }

        public APIRequestGetErrors requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetErrors requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetErrors requestRowNumberField() {
            return this.requestRowNumberField(true);
        }

        public APIRequestGetErrors requestRowNumberField(boolean value) {
            this.requestField("row_number", value);
            return this;
        }

        public APIRequestGetErrors requestSeverityField() {
            return this.requestSeverityField(true);
        }

        public APIRequestGetErrors requestSeverityField(boolean value) {
            this.requestField("severity", value);
            return this;
        }

        public APIRequestGetErrors requestSummaryField() {
            return this.requestSummaryField(true);
        }

        public APIRequestGetErrors requestSummaryField(boolean value) {
            this.requestField("summary", value);
            return this;
        }

        public APIRequestGetErrors requestTotalCountField() {
            return this.requestTotalCountField(true);
        }

        public APIRequestGetErrors requestTotalCountField(boolean value) {
            this.requestField("total_count", value);
            return this;
        }
    }
}

