/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductCatalogHotelRoomsBatch
extends APINode {
    @SerializedName(value="errors")
    private List<Object> mErrors = null;
    @SerializedName(value="errors_total_count")
    private Long mErrorsTotalCount = null;
    @SerializedName(value="handle")
    private String mHandle = null;
    @SerializedName(value="status")
    private String mStatus = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    ProductCatalogHotelRoomsBatch() {
    }

    public ProductCatalogHotelRoomsBatch(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public ProductCatalogHotelRoomsBatch(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public ProductCatalogHotelRoomsBatch fetch() throws APIException {
        ProductCatalogHotelRoomsBatch newInstance = ProductCatalogHotelRoomsBatch.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static ProductCatalogHotelRoomsBatch fetchById(Long id, APIContext context) throws APIException {
        return ProductCatalogHotelRoomsBatch.fetchById(id.toString(), context);
    }

    public static ListenableFuture<ProductCatalogHotelRoomsBatch> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return ProductCatalogHotelRoomsBatch.fetchByIdAsync(id.toString(), context);
    }

    public static ProductCatalogHotelRoomsBatch fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<ProductCatalogHotelRoomsBatch> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<ProductCatalogHotelRoomsBatch> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<ProductCatalogHotelRoomsBatch>(context, "", "/", "GET", ProductCatalogHotelRoomsBatch.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<ProductCatalogHotelRoomsBatch>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<ProductCatalogHotelRoomsBatch>(context, "", "/", "GET", ProductCatalogHotelRoomsBatch.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static ProductCatalogHotelRoomsBatch loadJSON(String json, APIContext context) {
        ProductCatalogHotelRoomsBatch productCatalogHotelRoomsBatch = (ProductCatalogHotelRoomsBatch)ProductCatalogHotelRoomsBatch.getGson().fromJson(json, ProductCatalogHotelRoomsBatch.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(productCatalogHotelRoomsBatch.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        productCatalogHotelRoomsBatch.context = context;
        productCatalogHotelRoomsBatch.rawValue = json;
        return productCatalogHotelRoomsBatch;
    }

    public static APINodeList<ProductCatalogHotelRoomsBatch> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ProductCatalogHotelRoomsBatch> productCatalogHotelRoomsBatchs = new APINodeList<ProductCatalogHotelRoomsBatch>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        productCatalogHotelRoomsBatchs.add(ProductCatalogHotelRoomsBatch.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return productCatalogHotelRoomsBatchs;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            productCatalogHotelRoomsBatchs.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        productCatalogHotelRoomsBatchs.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            productCatalogHotelRoomsBatchs.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            productCatalogHotelRoomsBatchs.add(ProductCatalogHotelRoomsBatch.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                productCatalogHotelRoomsBatchs.add(ProductCatalogHotelRoomsBatch.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            productCatalogHotelRoomsBatchs.add(ProductCatalogHotelRoomsBatch.loadJSON(obj.toString(), context));
                        }
                    }
                    return productCatalogHotelRoomsBatchs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        productCatalogHotelRoomsBatchs.add(ProductCatalogHotelRoomsBatch.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return productCatalogHotelRoomsBatchs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        productCatalogHotelRoomsBatchs.add(ProductCatalogHotelRoomsBatch.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return productCatalogHotelRoomsBatchs;
                }
                productCatalogHotelRoomsBatchs.clear();
                productCatalogHotelRoomsBatchs.add(ProductCatalogHotelRoomsBatch.loadJSON(json, context));
                return productCatalogHotelRoomsBatchs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ProductCatalogHotelRoomsBatch.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public List<Object> getFieldErrors() {
        return this.mErrors;
    }

    public Long getFieldErrorsTotalCount() {
        return this.mErrorsTotalCount;
    }

    public String getFieldHandle() {
        return this.mHandle;
    }

    public String getFieldStatus() {
        return this.mStatus;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ProductCatalogHotelRoomsBatch copyFrom(ProductCatalogHotelRoomsBatch instance) {
        this.mErrors = instance.mErrors;
        this.mErrorsTotalCount = instance.mErrorsTotalCount;
        this.mHandle = instance.mHandle;
        this.mStatus = instance.mStatus;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ProductCatalogHotelRoomsBatch> getParser() {
        return new APIRequest.ResponseParser<ProductCatalogHotelRoomsBatch>(){

            @Override
            public APINodeList<ProductCatalogHotelRoomsBatch> parseResponse(String response, APIContext context, APIRequest<ProductCatalogHotelRoomsBatch> request) throws APIException.MalformedResponseException {
                return ProductCatalogHotelRoomsBatch.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<ProductCatalogHotelRoomsBatch> {
        ProductCatalogHotelRoomsBatch lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"errors", "errors_total_count", "handle", "status", "id"};

        @Override
        public ProductCatalogHotelRoomsBatch getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ProductCatalogHotelRoomsBatch parseResponse(String response) throws APIException {
            return ProductCatalogHotelRoomsBatch.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public ProductCatalogHotelRoomsBatch execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ProductCatalogHotelRoomsBatch execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<ProductCatalogHotelRoomsBatch> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ProductCatalogHotelRoomsBatch> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, ProductCatalogHotelRoomsBatch>(){

                public ProductCatalogHotelRoomsBatch apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestErrorsField() {
            return this.requestErrorsField(true);
        }

        public APIRequestGet requestErrorsField(boolean value) {
            this.requestField("errors", value);
            return this;
        }

        public APIRequestGet requestErrorsTotalCountField() {
            return this.requestErrorsTotalCountField(true);
        }

        public APIRequestGet requestErrorsTotalCountField(boolean value) {
            this.requestField("errors_total_count", value);
            return this;
        }

        public APIRequestGet requestHandleField() {
            return this.requestHandleField(true);
        }

        public APIRequestGet requestHandleField(boolean value) {
            this.requestField("handle", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

