/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlatformImageSource
extends APINode {
    @SerializedName(value="height")
    private Long mHeight = null;
    @SerializedName(value="source")
    private String mSource = null;
    @SerializedName(value="width")
    private Long mWidth = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    PlatformImageSource() {
    }

    public PlatformImageSource(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public PlatformImageSource(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public PlatformImageSource fetch() throws APIException {
        PlatformImageSource newInstance = PlatformImageSource.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static PlatformImageSource fetchById(Long id, APIContext context) throws APIException {
        return PlatformImageSource.fetchById(id.toString(), context);
    }

    public static ListenableFuture<PlatformImageSource> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return PlatformImageSource.fetchByIdAsync(id.toString(), context);
    }

    public static PlatformImageSource fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<PlatformImageSource> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<PlatformImageSource> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<PlatformImageSource>(context, "", "/", "GET", PlatformImageSource.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<PlatformImageSource>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<PlatformImageSource>(context, "", "/", "GET", PlatformImageSource.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static PlatformImageSource loadJSON(String json, APIContext context) {
        PlatformImageSource platformImageSource = (PlatformImageSource)PlatformImageSource.getGson().fromJson(json, PlatformImageSource.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(platformImageSource.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        platformImageSource.context = context;
        platformImageSource.rawValue = json;
        return platformImageSource;
    }

    public static APINodeList<PlatformImageSource> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<PlatformImageSource> platformImageSources = new APINodeList<PlatformImageSource>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        platformImageSources.add(PlatformImageSource.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return platformImageSources;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            platformImageSources.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        platformImageSources.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            platformImageSources.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            platformImageSources.add(PlatformImageSource.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                platformImageSources.add(PlatformImageSource.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            platformImageSources.add(PlatformImageSource.loadJSON(obj.toString(), context));
                        }
                    }
                    return platformImageSources;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        platformImageSources.add(PlatformImageSource.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return platformImageSources;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        platformImageSources.add(PlatformImageSource.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return platformImageSources;
                }
                platformImageSources.clear();
                platformImageSources.add(PlatformImageSource.loadJSON(json, context));
                return platformImageSources;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return PlatformImageSource.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Long getFieldHeight() {
        return this.mHeight;
    }

    public String getFieldSource() {
        return this.mSource;
    }

    public Long getFieldWidth() {
        return this.mWidth;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public PlatformImageSource copyFrom(PlatformImageSource instance) {
        this.mHeight = instance.mHeight;
        this.mSource = instance.mSource;
        this.mWidth = instance.mWidth;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<PlatformImageSource> getParser() {
        return new APIRequest.ResponseParser<PlatformImageSource>(){

            @Override
            public APINodeList<PlatformImageSource> parseResponse(String response, APIContext context, APIRequest<PlatformImageSource> request) throws APIException.MalformedResponseException {
                return PlatformImageSource.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<PlatformImageSource> {
        PlatformImageSource lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"height", "source", "width", "id"};

        @Override
        public PlatformImageSource getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public PlatformImageSource parseResponse(String response) throws APIException {
            return PlatformImageSource.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public PlatformImageSource execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public PlatformImageSource execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<PlatformImageSource> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<PlatformImageSource> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, PlatformImageSource>(){

                public PlatformImageSource apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestHeightField() {
            return this.requestHeightField(true);
        }

        public APIRequestGet requestHeightField(boolean value) {
            this.requestField("height", value);
            return this;
        }

        public APIRequestGet requestSourceField() {
            return this.requestSourceField(true);
        }

        public APIRequestGet requestSourceField(boolean value) {
            this.requestField("source", value);
            return this;
        }

        public APIRequestGet requestWidthField() {
            return this.requestWidthField(true);
        }

        public APIRequestGet requestWidthField(boolean value) {
            this.requestField("width", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

