/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartnerCategory
extends APINode {
    @SerializedName(value="approximate_count")
    private Long mApproximateCount = null;
    @SerializedName(value="country")
    private String mCountry = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="details")
    private String mDetails = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="is_private")
    private Boolean mIsPrivate = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="parent_category")
    private String mParentCategory = null;
    @SerializedName(value="source")
    private String mSource = null;
    @SerializedName(value="status")
    private String mStatus = null;
    @SerializedName(value="targeting_type")
    private String mTargetingType = null;
    protected static Gson gson = null;

    PartnerCategory() {
    }

    public PartnerCategory(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public PartnerCategory(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public PartnerCategory fetch() throws APIException {
        PartnerCategory newInstance = PartnerCategory.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static PartnerCategory fetchById(Long id, APIContext context) throws APIException {
        return PartnerCategory.fetchById(id.toString(), context);
    }

    public static ListenableFuture<PartnerCategory> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return PartnerCategory.fetchByIdAsync(id.toString(), context);
    }

    public static PartnerCategory fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<PartnerCategory> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<PartnerCategory> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<PartnerCategory>(context, "", "/", "GET", PartnerCategory.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<PartnerCategory>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<PartnerCategory>(context, "", "/", "GET", PartnerCategory.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static PartnerCategory loadJSON(String json, APIContext context) {
        PartnerCategory partnerCategory = (PartnerCategory)PartnerCategory.getGson().fromJson(json, PartnerCategory.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(partnerCategory.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        partnerCategory.context = context;
        partnerCategory.rawValue = json;
        return partnerCategory;
    }

    public static APINodeList<PartnerCategory> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<PartnerCategory> partnerCategorys = new APINodeList<PartnerCategory>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        partnerCategorys.add(PartnerCategory.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return partnerCategorys;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            partnerCategorys.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        partnerCategorys.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            partnerCategorys.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            partnerCategorys.add(PartnerCategory.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                partnerCategorys.add(PartnerCategory.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            partnerCategorys.add(PartnerCategory.loadJSON(obj.toString(), context));
                        }
                    }
                    return partnerCategorys;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        partnerCategorys.add(PartnerCategory.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return partnerCategorys;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        partnerCategorys.add(PartnerCategory.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return partnerCategorys;
                }
                partnerCategorys.clear();
                partnerCategorys.add(PartnerCategory.loadJSON(json, context));
                return partnerCategorys;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return PartnerCategory.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Long getFieldApproximateCount() {
        return this.mApproximateCount;
    }

    public String getFieldCountry() {
        return this.mCountry;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public String getFieldDetails() {
        return this.mDetails;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Boolean getFieldIsPrivate() {
        return this.mIsPrivate;
    }

    public String getFieldName() {
        return this.mName;
    }

    public String getFieldParentCategory() {
        return this.mParentCategory;
    }

    public String getFieldSource() {
        return this.mSource;
    }

    public String getFieldStatus() {
        return this.mStatus;
    }

    public String getFieldTargetingType() {
        return this.mTargetingType;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public PartnerCategory copyFrom(PartnerCategory instance) {
        this.mApproximateCount = instance.mApproximateCount;
        this.mCountry = instance.mCountry;
        this.mDescription = instance.mDescription;
        this.mDetails = instance.mDetails;
        this.mId = instance.mId;
        this.mIsPrivate = instance.mIsPrivate;
        this.mName = instance.mName;
        this.mParentCategory = instance.mParentCategory;
        this.mSource = instance.mSource;
        this.mStatus = instance.mStatus;
        this.mTargetingType = instance.mTargetingType;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<PartnerCategory> getParser() {
        return new APIRequest.ResponseParser<PartnerCategory>(){

            @Override
            public APINodeList<PartnerCategory> parseResponse(String response, APIContext context, APIRequest<PartnerCategory> request) throws APIException.MalformedResponseException {
                return PartnerCategory.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumPrivateOrPublic {
        VALUE_PRIVATE("PRIVATE"),
        VALUE_PUBLIC("PUBLIC"),
        NULL(null);

        private String value;

        private EnumPrivateOrPublic(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<PartnerCategory> {
        PartnerCategory lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"approximate_count", "country", "description", "details", "id", "is_private", "name", "parent_category", "source", "status", "targeting_type"};

        @Override
        public PartnerCategory getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public PartnerCategory parseResponse(String response) throws APIException {
            return PartnerCategory.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public PartnerCategory execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public PartnerCategory execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<PartnerCategory> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<PartnerCategory> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, PartnerCategory>(){

                public PartnerCategory apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestApproximateCountField() {
            return this.requestApproximateCountField(true);
        }

        public APIRequestGet requestApproximateCountField(boolean value) {
            this.requestField("approximate_count", value);
            return this;
        }

        public APIRequestGet requestCountryField() {
            return this.requestCountryField(true);
        }

        public APIRequestGet requestCountryField(boolean value) {
            this.requestField("country", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestDetailsField() {
            return this.requestDetailsField(true);
        }

        public APIRequestGet requestDetailsField(boolean value) {
            this.requestField("details", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIsPrivateField() {
            return this.requestIsPrivateField(true);
        }

        public APIRequestGet requestIsPrivateField(boolean value) {
            this.requestField("is_private", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestParentCategoryField() {
            return this.requestParentCategoryField(true);
        }

        public APIRequestGet requestParentCategoryField(boolean value) {
            this.requestField("parent_category", value);
            return this;
        }

        public APIRequestGet requestSourceField() {
            return this.requestSourceField(true);
        }

        public APIRequestGet requestSourceField(boolean value) {
            this.requestField("source", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGet requestTargetingTypeField() {
            return this.requestTargetingTypeField(true);
        }

        public APIRequestGet requestTargetingTypeField(boolean value) {
            this.requestField("targeting_type", value);
            return this;
        }
    }
}

