/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageLocationsBreakdown
extends APINode {
    @SerializedName(value="location_id")
    private String mLocationId = null;
    @SerializedName(value="location_name")
    private String mLocationName = null;
    @SerializedName(value="location_type")
    private String mLocationType = null;
    @SerializedName(value="num_pages")
    private Long mNumPages = null;
    @SerializedName(value="num_pages_eligible_for_store_visit_reporting")
    private Long mNumPagesEligibleForStoreVisitReporting = null;
    @SerializedName(value="num_unpublished_or_closed_pages")
    private Long mNumUnpublishedOrClosedPages = null;
    @SerializedName(value="parent_country_code")
    private String mParentCountryCode = null;
    @SerializedName(value="parent_region_id")
    private Long mParentRegionId = null;
    @SerializedName(value="parent_region_name")
    private String mParentRegionName = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    PageLocationsBreakdown() {
    }

    public PageLocationsBreakdown(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public PageLocationsBreakdown(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public PageLocationsBreakdown fetch() throws APIException {
        PageLocationsBreakdown newInstance = PageLocationsBreakdown.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static PageLocationsBreakdown fetchById(Long id, APIContext context) throws APIException {
        return PageLocationsBreakdown.fetchById(id.toString(), context);
    }

    public static ListenableFuture<PageLocationsBreakdown> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return PageLocationsBreakdown.fetchByIdAsync(id.toString(), context);
    }

    public static PageLocationsBreakdown fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<PageLocationsBreakdown> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<PageLocationsBreakdown> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<PageLocationsBreakdown>(context, "", "/", "GET", PageLocationsBreakdown.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<PageLocationsBreakdown>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<PageLocationsBreakdown>(context, "", "/", "GET", PageLocationsBreakdown.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static PageLocationsBreakdown loadJSON(String json, APIContext context) {
        PageLocationsBreakdown pageLocationsBreakdown = (PageLocationsBreakdown)PageLocationsBreakdown.getGson().fromJson(json, PageLocationsBreakdown.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(pageLocationsBreakdown.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        pageLocationsBreakdown.context = context;
        pageLocationsBreakdown.rawValue = json;
        return pageLocationsBreakdown;
    }

    public static APINodeList<PageLocationsBreakdown> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<PageLocationsBreakdown> pageLocationsBreakdowns = new APINodeList<PageLocationsBreakdown>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        pageLocationsBreakdowns.add(PageLocationsBreakdown.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return pageLocationsBreakdowns;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            pageLocationsBreakdowns.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        pageLocationsBreakdowns.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            pageLocationsBreakdowns.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            pageLocationsBreakdowns.add(PageLocationsBreakdown.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                pageLocationsBreakdowns.add(PageLocationsBreakdown.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            pageLocationsBreakdowns.add(PageLocationsBreakdown.loadJSON(obj.toString(), context));
                        }
                    }
                    return pageLocationsBreakdowns;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        pageLocationsBreakdowns.add(PageLocationsBreakdown.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return pageLocationsBreakdowns;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        pageLocationsBreakdowns.add(PageLocationsBreakdown.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return pageLocationsBreakdowns;
                }
                pageLocationsBreakdowns.clear();
                pageLocationsBreakdowns.add(PageLocationsBreakdown.loadJSON(json, context));
                return pageLocationsBreakdowns;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return PageLocationsBreakdown.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldLocationId() {
        return this.mLocationId;
    }

    public String getFieldLocationName() {
        return this.mLocationName;
    }

    public String getFieldLocationType() {
        return this.mLocationType;
    }

    public Long getFieldNumPages() {
        return this.mNumPages;
    }

    public Long getFieldNumPagesEligibleForStoreVisitReporting() {
        return this.mNumPagesEligibleForStoreVisitReporting;
    }

    public Long getFieldNumUnpublishedOrClosedPages() {
        return this.mNumUnpublishedOrClosedPages;
    }

    public String getFieldParentCountryCode() {
        return this.mParentCountryCode;
    }

    public Long getFieldParentRegionId() {
        return this.mParentRegionId;
    }

    public String getFieldParentRegionName() {
        return this.mParentRegionName;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public PageLocationsBreakdown copyFrom(PageLocationsBreakdown instance) {
        this.mLocationId = instance.mLocationId;
        this.mLocationName = instance.mLocationName;
        this.mLocationType = instance.mLocationType;
        this.mNumPages = instance.mNumPages;
        this.mNumPagesEligibleForStoreVisitReporting = instance.mNumPagesEligibleForStoreVisitReporting;
        this.mNumUnpublishedOrClosedPages = instance.mNumUnpublishedOrClosedPages;
        this.mParentCountryCode = instance.mParentCountryCode;
        this.mParentRegionId = instance.mParentRegionId;
        this.mParentRegionName = instance.mParentRegionName;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<PageLocationsBreakdown> getParser() {
        return new APIRequest.ResponseParser<PageLocationsBreakdown>(){

            @Override
            public APINodeList<PageLocationsBreakdown> parseResponse(String response, APIContext context, APIRequest<PageLocationsBreakdown> request) throws APIException.MalformedResponseException {
                return PageLocationsBreakdown.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<PageLocationsBreakdown> {
        PageLocationsBreakdown lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"location_id", "location_name", "location_type", "num_pages", "num_pages_eligible_for_store_visit_reporting", "num_unpublished_or_closed_pages", "parent_country_code", "parent_region_id", "parent_region_name", "id"};

        @Override
        public PageLocationsBreakdown getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public PageLocationsBreakdown parseResponse(String response) throws APIException {
            return PageLocationsBreakdown.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public PageLocationsBreakdown execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public PageLocationsBreakdown execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<PageLocationsBreakdown> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<PageLocationsBreakdown> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, PageLocationsBreakdown>(){

                public PageLocationsBreakdown apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestLocationIdField() {
            return this.requestLocationIdField(true);
        }

        public APIRequestGet requestLocationIdField(boolean value) {
            this.requestField("location_id", value);
            return this;
        }

        public APIRequestGet requestLocationNameField() {
            return this.requestLocationNameField(true);
        }

        public APIRequestGet requestLocationNameField(boolean value) {
            this.requestField("location_name", value);
            return this;
        }

        public APIRequestGet requestLocationTypeField() {
            return this.requestLocationTypeField(true);
        }

        public APIRequestGet requestLocationTypeField(boolean value) {
            this.requestField("location_type", value);
            return this;
        }

        public APIRequestGet requestNumPagesField() {
            return this.requestNumPagesField(true);
        }

        public APIRequestGet requestNumPagesField(boolean value) {
            this.requestField("num_pages", value);
            return this;
        }

        public APIRequestGet requestNumPagesEligibleForStoreVisitReportingField() {
            return this.requestNumPagesEligibleForStoreVisitReportingField(true);
        }

        public APIRequestGet requestNumPagesEligibleForStoreVisitReportingField(boolean value) {
            this.requestField("num_pages_eligible_for_store_visit_reporting", value);
            return this;
        }

        public APIRequestGet requestNumUnpublishedOrClosedPagesField() {
            return this.requestNumUnpublishedOrClosedPagesField(true);
        }

        public APIRequestGet requestNumUnpublishedOrClosedPagesField(boolean value) {
            this.requestField("num_unpublished_or_closed_pages", value);
            return this;
        }

        public APIRequestGet requestParentCountryCodeField() {
            return this.requestParentCountryCodeField(true);
        }

        public APIRequestGet requestParentCountryCodeField(boolean value) {
            this.requestField("parent_country_code", value);
            return this;
        }

        public APIRequestGet requestParentRegionIdField() {
            return this.requestParentRegionIdField(true);
        }

        public APIRequestGet requestParentRegionIdField(boolean value) {
            this.requestField("parent_region_id", value);
            return this;
        }

        public APIRequestGet requestParentRegionNameField() {
            return this.requestParentRegionNameField(true);
        }

        public APIRequestGet requestParentRegionNameField(boolean value) {
            this.requestField("parent_region_name", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

