/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinimumBudget
extends APINode {
    @SerializedName(value="currency")
    private String mCurrency = null;
    @SerializedName(value="min_daily_budget_high_freq")
    private Long mMinDailyBudgetHighFreq = null;
    @SerializedName(value="min_daily_budget_imp")
    private Long mMinDailyBudgetImp = null;
    @SerializedName(value="min_daily_budget_low_freq")
    private Long mMinDailyBudgetLowFreq = null;
    @SerializedName(value="min_daily_budget_video_views")
    private Long mMinDailyBudgetVideoViews = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    MinimumBudget() {
    }

    public MinimumBudget(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public MinimumBudget(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public MinimumBudget fetch() throws APIException {
        MinimumBudget newInstance = MinimumBudget.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static MinimumBudget fetchById(Long id, APIContext context) throws APIException {
        return MinimumBudget.fetchById(id.toString(), context);
    }

    public static ListenableFuture<MinimumBudget> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return MinimumBudget.fetchByIdAsync(id.toString(), context);
    }

    public static MinimumBudget fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<MinimumBudget> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<MinimumBudget> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<MinimumBudget>(context, "", "/", "GET", MinimumBudget.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<MinimumBudget>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<MinimumBudget>(context, "", "/", "GET", MinimumBudget.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static MinimumBudget loadJSON(String json, APIContext context) {
        MinimumBudget minimumBudget = (MinimumBudget)MinimumBudget.getGson().fromJson(json, MinimumBudget.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(minimumBudget.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        minimumBudget.context = context;
        minimumBudget.rawValue = json;
        return minimumBudget;
    }

    public static APINodeList<MinimumBudget> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<MinimumBudget> minimumBudgets = new APINodeList<MinimumBudget>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        minimumBudgets.add(MinimumBudget.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return minimumBudgets;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            minimumBudgets.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        minimumBudgets.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            minimumBudgets.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            minimumBudgets.add(MinimumBudget.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                minimumBudgets.add(MinimumBudget.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            minimumBudgets.add(MinimumBudget.loadJSON(obj.toString(), context));
                        }
                    }
                    return minimumBudgets;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        minimumBudgets.add(MinimumBudget.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return minimumBudgets;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        minimumBudgets.add(MinimumBudget.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return minimumBudgets;
                }
                minimumBudgets.clear();
                minimumBudgets.add(MinimumBudget.loadJSON(json, context));
                return minimumBudgets;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return MinimumBudget.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldCurrency() {
        return this.mCurrency;
    }

    public Long getFieldMinDailyBudgetHighFreq() {
        return this.mMinDailyBudgetHighFreq;
    }

    public Long getFieldMinDailyBudgetImp() {
        return this.mMinDailyBudgetImp;
    }

    public Long getFieldMinDailyBudgetLowFreq() {
        return this.mMinDailyBudgetLowFreq;
    }

    public Long getFieldMinDailyBudgetVideoViews() {
        return this.mMinDailyBudgetVideoViews;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public MinimumBudget copyFrom(MinimumBudget instance) {
        this.mCurrency = instance.mCurrency;
        this.mMinDailyBudgetHighFreq = instance.mMinDailyBudgetHighFreq;
        this.mMinDailyBudgetImp = instance.mMinDailyBudgetImp;
        this.mMinDailyBudgetLowFreq = instance.mMinDailyBudgetLowFreq;
        this.mMinDailyBudgetVideoViews = instance.mMinDailyBudgetVideoViews;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<MinimumBudget> getParser() {
        return new APIRequest.ResponseParser<MinimumBudget>(){

            @Override
            public APINodeList<MinimumBudget> parseResponse(String response, APIContext context, APIRequest<MinimumBudget> request) throws APIException.MalformedResponseException {
                return MinimumBudget.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<MinimumBudget> {
        MinimumBudget lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"currency", "min_daily_budget_high_freq", "min_daily_budget_imp", "min_daily_budget_low_freq", "min_daily_budget_video_views", "id"};

        @Override
        public MinimumBudget getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public MinimumBudget parseResponse(String response) throws APIException {
            return MinimumBudget.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public MinimumBudget execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public MinimumBudget execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<MinimumBudget> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<MinimumBudget> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, MinimumBudget>(){

                public MinimumBudget apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGet requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGet requestMinDailyBudgetHighFreqField() {
            return this.requestMinDailyBudgetHighFreqField(true);
        }

        public APIRequestGet requestMinDailyBudgetHighFreqField(boolean value) {
            this.requestField("min_daily_budget_high_freq", value);
            return this;
        }

        public APIRequestGet requestMinDailyBudgetImpField() {
            return this.requestMinDailyBudgetImpField(true);
        }

        public APIRequestGet requestMinDailyBudgetImpField(boolean value) {
            this.requestField("min_daily_budget_imp", value);
            return this;
        }

        public APIRequestGet requestMinDailyBudgetLowFreqField() {
            return this.requestMinDailyBudgetLowFreqField(true);
        }

        public APIRequestGet requestMinDailyBudgetLowFreqField(boolean value) {
            this.requestField("min_daily_budget_low_freq", value);
            return this;
        }

        public APIRequestGet requestMinDailyBudgetVideoViewsField() {
            return this.requestMinDailyBudgetVideoViewsField(true);
        }

        public APIRequestGet requestMinDailyBudgetVideoViewsField(boolean value) {
            this.requestField("min_daily_budget_video_views", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

