/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessengerProfile
extends APINode {
    @SerializedName(value="account_linking_url")
    private String mAccountLinkingUrl = null;
    @SerializedName(value="get_started")
    private Object mGetStarted = null;
    @SerializedName(value="greeting")
    private List<Object> mGreeting = null;
    @SerializedName(value="home_url")
    private Object mHomeUrl = null;
    @SerializedName(value="payment_settings")
    private Object mPaymentSettings = null;
    @SerializedName(value="persistent_menu")
    private List<Object> mPersistentMenu = null;
    @SerializedName(value="target_audience")
    private Object mTargetAudience = null;
    @SerializedName(value="whitelisted_domains")
    private List<String> mWhitelistedDomains = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    MessengerProfile() {
    }

    public MessengerProfile(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public MessengerProfile(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public MessengerProfile fetch() throws APIException {
        MessengerProfile newInstance = MessengerProfile.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static MessengerProfile fetchById(Long id, APIContext context) throws APIException {
        return MessengerProfile.fetchById(id.toString(), context);
    }

    public static ListenableFuture<MessengerProfile> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return MessengerProfile.fetchByIdAsync(id.toString(), context);
    }

    public static MessengerProfile fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<MessengerProfile> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<MessengerProfile> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<MessengerProfile>(context, "", "/", "GET", MessengerProfile.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<MessengerProfile>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<MessengerProfile>(context, "", "/", "GET", MessengerProfile.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static MessengerProfile loadJSON(String json, APIContext context) {
        MessengerProfile messengerProfile = (MessengerProfile)MessengerProfile.getGson().fromJson(json, MessengerProfile.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(messengerProfile.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        messengerProfile.context = context;
        messengerProfile.rawValue = json;
        return messengerProfile;
    }

    public static APINodeList<MessengerProfile> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<MessengerProfile> messengerProfiles = new APINodeList<MessengerProfile>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        messengerProfiles.add(MessengerProfile.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return messengerProfiles;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            messengerProfiles.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        messengerProfiles.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            messengerProfiles.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            messengerProfiles.add(MessengerProfile.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                messengerProfiles.add(MessengerProfile.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            messengerProfiles.add(MessengerProfile.loadJSON(obj.toString(), context));
                        }
                    }
                    return messengerProfiles;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        messengerProfiles.add(MessengerProfile.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return messengerProfiles;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        messengerProfiles.add(MessengerProfile.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return messengerProfiles;
                }
                messengerProfiles.clear();
                messengerProfiles.add(MessengerProfile.loadJSON(json, context));
                return messengerProfiles;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return MessengerProfile.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAccountLinkingUrl() {
        return this.mAccountLinkingUrl;
    }

    public Object getFieldGetStarted() {
        return this.mGetStarted;
    }

    public List<Object> getFieldGreeting() {
        return this.mGreeting;
    }

    public Object getFieldHomeUrl() {
        return this.mHomeUrl;
    }

    public Object getFieldPaymentSettings() {
        return this.mPaymentSettings;
    }

    public List<Object> getFieldPersistentMenu() {
        return this.mPersistentMenu;
    }

    public Object getFieldTargetAudience() {
        return this.mTargetAudience;
    }

    public List<String> getFieldWhitelistedDomains() {
        return this.mWhitelistedDomains;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public MessengerProfile copyFrom(MessengerProfile instance) {
        this.mAccountLinkingUrl = instance.mAccountLinkingUrl;
        this.mGetStarted = instance.mGetStarted;
        this.mGreeting = instance.mGreeting;
        this.mHomeUrl = instance.mHomeUrl;
        this.mPaymentSettings = instance.mPaymentSettings;
        this.mPersistentMenu = instance.mPersistentMenu;
        this.mTargetAudience = instance.mTargetAudience;
        this.mWhitelistedDomains = instance.mWhitelistedDomains;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<MessengerProfile> getParser() {
        return new APIRequest.ResponseParser<MessengerProfile>(){

            @Override
            public APINodeList<MessengerProfile> parseResponse(String response, APIContext context, APIRequest<MessengerProfile> request) throws APIException.MalformedResponseException {
                return MessengerProfile.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<MessengerProfile> {
        MessengerProfile lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"account_linking_url", "get_started", "greeting", "home_url", "payment_settings", "persistent_menu", "target_audience", "whitelisted_domains", "id"};

        @Override
        public MessengerProfile getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public MessengerProfile parseResponse(String response) throws APIException {
            return MessengerProfile.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public MessengerProfile execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public MessengerProfile execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<MessengerProfile> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<MessengerProfile> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, MessengerProfile>(){

                public MessengerProfile apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAccountLinkingUrlField() {
            return this.requestAccountLinkingUrlField(true);
        }

        public APIRequestGet requestAccountLinkingUrlField(boolean value) {
            this.requestField("account_linking_url", value);
            return this;
        }

        public APIRequestGet requestGetStartedField() {
            return this.requestGetStartedField(true);
        }

        public APIRequestGet requestGetStartedField(boolean value) {
            this.requestField("get_started", value);
            return this;
        }

        public APIRequestGet requestGreetingField() {
            return this.requestGreetingField(true);
        }

        public APIRequestGet requestGreetingField(boolean value) {
            this.requestField("greeting", value);
            return this;
        }

        public APIRequestGet requestHomeUrlField() {
            return this.requestHomeUrlField(true);
        }

        public APIRequestGet requestHomeUrlField(boolean value) {
            this.requestField("home_url", value);
            return this;
        }

        public APIRequestGet requestPaymentSettingsField() {
            return this.requestPaymentSettingsField(true);
        }

        public APIRequestGet requestPaymentSettingsField(boolean value) {
            this.requestField("payment_settings", value);
            return this;
        }

        public APIRequestGet requestPersistentMenuField() {
            return this.requestPersistentMenuField(true);
        }

        public APIRequestGet requestPersistentMenuField(boolean value) {
            this.requestField("persistent_menu", value);
            return this;
        }

        public APIRequestGet requestTargetAudienceField() {
            return this.requestTargetAudienceField(true);
        }

        public APIRequestGet requestTargetAudienceField(boolean value) {
            this.requestField("target_audience", value);
            return this;
        }

        public APIRequestGet requestWhitelistedDomainsField() {
            return this.requestWhitelistedDomainsField(true);
        }

        public APIRequestGet requestWhitelistedDomainsField(boolean value) {
            this.requestField("whitelisted_domains", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

