/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveVideoAdBreakConfig
extends APINode {
    @SerializedName(value="default_ad_break_duration")
    private Long mDefaultAdBreakDuration = null;
    @SerializedName(value="failure_reason_polling_interval")
    private Long mFailureReasonPollingInterval = null;
    @SerializedName(value="first_break_eligible_secs")
    private Long mFirstBreakEligibleSecs = null;
    @SerializedName(value="guide_url")
    private String mGuideUrl = null;
    @SerializedName(value="is_eligible_to_onboard")
    private Boolean mIsEligibleToOnboard = null;
    @SerializedName(value="is_enabled")
    private Boolean mIsEnabled = null;
    @SerializedName(value="onboarding_url")
    private String mOnboardingUrl = null;
    @SerializedName(value="preparing_duration")
    private Long mPreparingDuration = null;
    @SerializedName(value="time_between_ad_breaks_secs")
    private Long mTimeBetweenAdBreaksSecs = null;
    @SerializedName(value="viewer_count_threshold")
    private Long mViewerCountThreshold = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    LiveVideoAdBreakConfig() {
    }

    public LiveVideoAdBreakConfig(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public LiveVideoAdBreakConfig(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public LiveVideoAdBreakConfig fetch() throws APIException {
        LiveVideoAdBreakConfig newInstance = LiveVideoAdBreakConfig.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static LiveVideoAdBreakConfig fetchById(Long id, APIContext context) throws APIException {
        return LiveVideoAdBreakConfig.fetchById(id.toString(), context);
    }

    public static ListenableFuture<LiveVideoAdBreakConfig> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return LiveVideoAdBreakConfig.fetchByIdAsync(id.toString(), context);
    }

    public static LiveVideoAdBreakConfig fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<LiveVideoAdBreakConfig> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<LiveVideoAdBreakConfig> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<LiveVideoAdBreakConfig>(context, "", "/", "GET", LiveVideoAdBreakConfig.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<LiveVideoAdBreakConfig>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<LiveVideoAdBreakConfig>(context, "", "/", "GET", LiveVideoAdBreakConfig.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static LiveVideoAdBreakConfig loadJSON(String json, APIContext context) {
        LiveVideoAdBreakConfig liveVideoAdBreakConfig = (LiveVideoAdBreakConfig)LiveVideoAdBreakConfig.getGson().fromJson(json, LiveVideoAdBreakConfig.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(liveVideoAdBreakConfig.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        liveVideoAdBreakConfig.context = context;
        liveVideoAdBreakConfig.rawValue = json;
        return liveVideoAdBreakConfig;
    }

    public static APINodeList<LiveVideoAdBreakConfig> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<LiveVideoAdBreakConfig> liveVideoAdBreakConfigs = new APINodeList<LiveVideoAdBreakConfig>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        liveVideoAdBreakConfigs.add(LiveVideoAdBreakConfig.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return liveVideoAdBreakConfigs;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            liveVideoAdBreakConfigs.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        liveVideoAdBreakConfigs.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            liveVideoAdBreakConfigs.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            liveVideoAdBreakConfigs.add(LiveVideoAdBreakConfig.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                liveVideoAdBreakConfigs.add(LiveVideoAdBreakConfig.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            liveVideoAdBreakConfigs.add(LiveVideoAdBreakConfig.loadJSON(obj.toString(), context));
                        }
                    }
                    return liveVideoAdBreakConfigs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        liveVideoAdBreakConfigs.add(LiveVideoAdBreakConfig.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return liveVideoAdBreakConfigs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        liveVideoAdBreakConfigs.add(LiveVideoAdBreakConfig.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return liveVideoAdBreakConfigs;
                }
                liveVideoAdBreakConfigs.clear();
                liveVideoAdBreakConfigs.add(LiveVideoAdBreakConfig.loadJSON(json, context));
                return liveVideoAdBreakConfigs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return LiveVideoAdBreakConfig.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Long getFieldDefaultAdBreakDuration() {
        return this.mDefaultAdBreakDuration;
    }

    public Long getFieldFailureReasonPollingInterval() {
        return this.mFailureReasonPollingInterval;
    }

    public Long getFieldFirstBreakEligibleSecs() {
        return this.mFirstBreakEligibleSecs;
    }

    public String getFieldGuideUrl() {
        return this.mGuideUrl;
    }

    public Boolean getFieldIsEligibleToOnboard() {
        return this.mIsEligibleToOnboard;
    }

    public Boolean getFieldIsEnabled() {
        return this.mIsEnabled;
    }

    public String getFieldOnboardingUrl() {
        return this.mOnboardingUrl;
    }

    public Long getFieldPreparingDuration() {
        return this.mPreparingDuration;
    }

    public Long getFieldTimeBetweenAdBreaksSecs() {
        return this.mTimeBetweenAdBreaksSecs;
    }

    public Long getFieldViewerCountThreshold() {
        return this.mViewerCountThreshold;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public LiveVideoAdBreakConfig copyFrom(LiveVideoAdBreakConfig instance) {
        this.mDefaultAdBreakDuration = instance.mDefaultAdBreakDuration;
        this.mFailureReasonPollingInterval = instance.mFailureReasonPollingInterval;
        this.mFirstBreakEligibleSecs = instance.mFirstBreakEligibleSecs;
        this.mGuideUrl = instance.mGuideUrl;
        this.mIsEligibleToOnboard = instance.mIsEligibleToOnboard;
        this.mIsEnabled = instance.mIsEnabled;
        this.mOnboardingUrl = instance.mOnboardingUrl;
        this.mPreparingDuration = instance.mPreparingDuration;
        this.mTimeBetweenAdBreaksSecs = instance.mTimeBetweenAdBreaksSecs;
        this.mViewerCountThreshold = instance.mViewerCountThreshold;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<LiveVideoAdBreakConfig> getParser() {
        return new APIRequest.ResponseParser<LiveVideoAdBreakConfig>(){

            @Override
            public APINodeList<LiveVideoAdBreakConfig> parseResponse(String response, APIContext context, APIRequest<LiveVideoAdBreakConfig> request) throws APIException.MalformedResponseException {
                return LiveVideoAdBreakConfig.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<LiveVideoAdBreakConfig> {
        LiveVideoAdBreakConfig lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"default_ad_break_duration", "failure_reason_polling_interval", "first_break_eligible_secs", "guide_url", "is_eligible_to_onboard", "is_enabled", "onboarding_url", "preparing_duration", "time_between_ad_breaks_secs", "viewer_count_threshold", "id"};

        @Override
        public LiveVideoAdBreakConfig getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public LiveVideoAdBreakConfig parseResponse(String response) throws APIException {
            return LiveVideoAdBreakConfig.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public LiveVideoAdBreakConfig execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public LiveVideoAdBreakConfig execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<LiveVideoAdBreakConfig> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<LiveVideoAdBreakConfig> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, LiveVideoAdBreakConfig>(){

                public LiveVideoAdBreakConfig apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestDefaultAdBreakDurationField() {
            return this.requestDefaultAdBreakDurationField(true);
        }

        public APIRequestGet requestDefaultAdBreakDurationField(boolean value) {
            this.requestField("default_ad_break_duration", value);
            return this;
        }

        public APIRequestGet requestFailureReasonPollingIntervalField() {
            return this.requestFailureReasonPollingIntervalField(true);
        }

        public APIRequestGet requestFailureReasonPollingIntervalField(boolean value) {
            this.requestField("failure_reason_polling_interval", value);
            return this;
        }

        public APIRequestGet requestFirstBreakEligibleSecsField() {
            return this.requestFirstBreakEligibleSecsField(true);
        }

        public APIRequestGet requestFirstBreakEligibleSecsField(boolean value) {
            this.requestField("first_break_eligible_secs", value);
            return this;
        }

        public APIRequestGet requestGuideUrlField() {
            return this.requestGuideUrlField(true);
        }

        public APIRequestGet requestGuideUrlField(boolean value) {
            this.requestField("guide_url", value);
            return this;
        }

        public APIRequestGet requestIsEligibleToOnboardField() {
            return this.requestIsEligibleToOnboardField(true);
        }

        public APIRequestGet requestIsEligibleToOnboardField(boolean value) {
            this.requestField("is_eligible_to_onboard", value);
            return this;
        }

        public APIRequestGet requestIsEnabledField() {
            return this.requestIsEnabledField(true);
        }

        public APIRequestGet requestIsEnabledField(boolean value) {
            this.requestField("is_enabled", value);
            return this;
        }

        public APIRequestGet requestOnboardingUrlField() {
            return this.requestOnboardingUrlField(true);
        }

        public APIRequestGet requestOnboardingUrlField(boolean value) {
            this.requestField("onboarding_url", value);
            return this;
        }

        public APIRequestGet requestPreparingDurationField() {
            return this.requestPreparingDurationField(true);
        }

        public APIRequestGet requestPreparingDurationField(boolean value) {
            this.requestField("preparing_duration", value);
            return this;
        }

        public APIRequestGet requestTimeBetweenAdBreaksSecsField() {
            return this.requestTimeBetweenAdBreaksSecsField(true);
        }

        public APIRequestGet requestTimeBetweenAdBreaksSecsField(boolean value) {
            this.requestField("time_between_ad_breaks_secs", value);
            return this;
        }

        public APIRequestGet requestViewerCountThresholdField() {
            return this.requestViewerCountThresholdField(true);
        }

        public APIRequestGet requestViewerCountThresholdField(boolean value) {
            this.requestField("viewer_count_threshold", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

