/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.LeadGenConditionalQuestionsGroupChoices;
import com.facebook.ads.sdk.LeadGenConditionalQuestionsGroupQuestions;
import com.facebook.ads.sdk.LeadGenQuestionOption;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeadGenDraftQuestion
extends APINode {
    @SerializedName(value="conditional_questions_choices")
    private List<LeadGenConditionalQuestionsGroupChoices> mConditionalQuestionsChoices = null;
    @SerializedName(value="conditional_questions_group_id")
    private String mConditionalQuestionsGroupId = null;
    @SerializedName(value="dependent_conditional_questions")
    private List<LeadGenConditionalQuestionsGroupQuestions> mDependentConditionalQuestions = null;
    @SerializedName(value="inline_context")
    private String mInlineContext = null;
    @SerializedName(value="key")
    private String mKey = null;
    @SerializedName(value="label")
    private String mLabel = null;
    @SerializedName(value="options")
    private List<LeadGenQuestionOption> mOptions = null;
    @SerializedName(value="type")
    private String mType = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    LeadGenDraftQuestion() {
    }

    public LeadGenDraftQuestion(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public LeadGenDraftQuestion(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public LeadGenDraftQuestion fetch() throws APIException {
        LeadGenDraftQuestion newInstance = LeadGenDraftQuestion.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static LeadGenDraftQuestion fetchById(Long id, APIContext context) throws APIException {
        return LeadGenDraftQuestion.fetchById(id.toString(), context);
    }

    public static ListenableFuture<LeadGenDraftQuestion> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return LeadGenDraftQuestion.fetchByIdAsync(id.toString(), context);
    }

    public static LeadGenDraftQuestion fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<LeadGenDraftQuestion> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<LeadGenDraftQuestion> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<LeadGenDraftQuestion>(context, "", "/", "GET", LeadGenDraftQuestion.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<LeadGenDraftQuestion>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<LeadGenDraftQuestion>(context, "", "/", "GET", LeadGenDraftQuestion.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static LeadGenDraftQuestion loadJSON(String json, APIContext context) {
        LeadGenDraftQuestion leadGenDraftQuestion = (LeadGenDraftQuestion)LeadGenDraftQuestion.getGson().fromJson(json, LeadGenDraftQuestion.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(leadGenDraftQuestion.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        leadGenDraftQuestion.context = context;
        leadGenDraftQuestion.rawValue = json;
        return leadGenDraftQuestion;
    }

    public static APINodeList<LeadGenDraftQuestion> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<LeadGenDraftQuestion> leadGenDraftQuestions = new APINodeList<LeadGenDraftQuestion>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        leadGenDraftQuestions.add(LeadGenDraftQuestion.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return leadGenDraftQuestions;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            leadGenDraftQuestions.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        leadGenDraftQuestions.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            leadGenDraftQuestions.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            leadGenDraftQuestions.add(LeadGenDraftQuestion.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                leadGenDraftQuestions.add(LeadGenDraftQuestion.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            leadGenDraftQuestions.add(LeadGenDraftQuestion.loadJSON(obj.toString(), context));
                        }
                    }
                    return leadGenDraftQuestions;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        leadGenDraftQuestions.add(LeadGenDraftQuestion.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return leadGenDraftQuestions;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        leadGenDraftQuestions.add(LeadGenDraftQuestion.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return leadGenDraftQuestions;
                }
                leadGenDraftQuestions.clear();
                leadGenDraftQuestions.add(LeadGenDraftQuestion.loadJSON(json, context));
                return leadGenDraftQuestions;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return LeadGenDraftQuestion.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public List<LeadGenConditionalQuestionsGroupChoices> getFieldConditionalQuestionsChoices() {
        return this.mConditionalQuestionsChoices;
    }

    public String getFieldConditionalQuestionsGroupId() {
        return this.mConditionalQuestionsGroupId;
    }

    public List<LeadGenConditionalQuestionsGroupQuestions> getFieldDependentConditionalQuestions() {
        return this.mDependentConditionalQuestions;
    }

    public String getFieldInlineContext() {
        return this.mInlineContext;
    }

    public String getFieldKey() {
        return this.mKey;
    }

    public String getFieldLabel() {
        return this.mLabel;
    }

    public List<LeadGenQuestionOption> getFieldOptions() {
        return this.mOptions;
    }

    public String getFieldType() {
        return this.mType;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public LeadGenDraftQuestion copyFrom(LeadGenDraftQuestion instance) {
        this.mConditionalQuestionsChoices = instance.mConditionalQuestionsChoices;
        this.mConditionalQuestionsGroupId = instance.mConditionalQuestionsGroupId;
        this.mDependentConditionalQuestions = instance.mDependentConditionalQuestions;
        this.mInlineContext = instance.mInlineContext;
        this.mKey = instance.mKey;
        this.mLabel = instance.mLabel;
        this.mOptions = instance.mOptions;
        this.mType = instance.mType;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<LeadGenDraftQuestion> getParser() {
        return new APIRequest.ResponseParser<LeadGenDraftQuestion>(){

            @Override
            public APINodeList<LeadGenDraftQuestion> parseResponse(String response, APIContext context, APIRequest<LeadGenDraftQuestion> request) throws APIException.MalformedResponseException {
                return LeadGenDraftQuestion.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<LeadGenDraftQuestion> {
        LeadGenDraftQuestion lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"conditional_questions_choices", "conditional_questions_group_id", "dependent_conditional_questions", "inline_context", "key", "label", "options", "type", "id"};

        @Override
        public LeadGenDraftQuestion getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public LeadGenDraftQuestion parseResponse(String response) throws APIException {
            return LeadGenDraftQuestion.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public LeadGenDraftQuestion execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public LeadGenDraftQuestion execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<LeadGenDraftQuestion> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<LeadGenDraftQuestion> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, LeadGenDraftQuestion>(){

                public LeadGenDraftQuestion apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestConditionalQuestionsChoicesField() {
            return this.requestConditionalQuestionsChoicesField(true);
        }

        public APIRequestGet requestConditionalQuestionsChoicesField(boolean value) {
            this.requestField("conditional_questions_choices", value);
            return this;
        }

        public APIRequestGet requestConditionalQuestionsGroupIdField() {
            return this.requestConditionalQuestionsGroupIdField(true);
        }

        public APIRequestGet requestConditionalQuestionsGroupIdField(boolean value) {
            this.requestField("conditional_questions_group_id", value);
            return this;
        }

        public APIRequestGet requestDependentConditionalQuestionsField() {
            return this.requestDependentConditionalQuestionsField(true);
        }

        public APIRequestGet requestDependentConditionalQuestionsField(boolean value) {
            this.requestField("dependent_conditional_questions", value);
            return this;
        }

        public APIRequestGet requestInlineContextField() {
            return this.requestInlineContextField(true);
        }

        public APIRequestGet requestInlineContextField(boolean value) {
            this.requestField("inline_context", value);
            return this;
        }

        public APIRequestGet requestKeyField() {
            return this.requestKeyField(true);
        }

        public APIRequestGet requestKeyField(boolean value) {
            this.requestField("key", value);
            return this;
        }

        public APIRequestGet requestLabelField() {
            return this.requestLabelField(true);
        }

        public APIRequestGet requestLabelField(boolean value) {
            this.requestField("label", value);
            return this;
        }

        public APIRequestGet requestOptionsField() {
            return this.requestOptionsField(true);
        }

        public APIRequestGet requestOptionsField(boolean value) {
            this.requestField("options", value);
            return this;
        }

        public APIRequestGet requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGet requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

