/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeadGenAppointmentBookingInfo
extends APINode {
    @SerializedName(value="advertiser_timezone_offset")
    private String mAdvertiserTimezoneOffset = null;
    @SerializedName(value="appointment_durations")
    private List<String> mAppointmentDurations = null;
    @SerializedName(value="appointment_slots_by_day")
    private List<Object> mAppointmentSlotsByDay = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    LeadGenAppointmentBookingInfo() {
    }

    public LeadGenAppointmentBookingInfo(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public LeadGenAppointmentBookingInfo(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public LeadGenAppointmentBookingInfo fetch() throws APIException {
        LeadGenAppointmentBookingInfo newInstance = LeadGenAppointmentBookingInfo.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static LeadGenAppointmentBookingInfo fetchById(Long id, APIContext context) throws APIException {
        return LeadGenAppointmentBookingInfo.fetchById(id.toString(), context);
    }

    public static ListenableFuture<LeadGenAppointmentBookingInfo> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return LeadGenAppointmentBookingInfo.fetchByIdAsync(id.toString(), context);
    }

    public static LeadGenAppointmentBookingInfo fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<LeadGenAppointmentBookingInfo> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<LeadGenAppointmentBookingInfo> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<LeadGenAppointmentBookingInfo>(context, "", "/", "GET", LeadGenAppointmentBookingInfo.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<LeadGenAppointmentBookingInfo>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<LeadGenAppointmentBookingInfo>(context, "", "/", "GET", LeadGenAppointmentBookingInfo.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static LeadGenAppointmentBookingInfo loadJSON(String json, APIContext context) {
        LeadGenAppointmentBookingInfo leadGenAppointmentBookingInfo = (LeadGenAppointmentBookingInfo)LeadGenAppointmentBookingInfo.getGson().fromJson(json, LeadGenAppointmentBookingInfo.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(leadGenAppointmentBookingInfo.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        leadGenAppointmentBookingInfo.context = context;
        leadGenAppointmentBookingInfo.rawValue = json;
        return leadGenAppointmentBookingInfo;
    }

    public static APINodeList<LeadGenAppointmentBookingInfo> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<LeadGenAppointmentBookingInfo> leadGenAppointmentBookingInfos = new APINodeList<LeadGenAppointmentBookingInfo>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        leadGenAppointmentBookingInfos.add(LeadGenAppointmentBookingInfo.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return leadGenAppointmentBookingInfos;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            leadGenAppointmentBookingInfos.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        leadGenAppointmentBookingInfos.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            leadGenAppointmentBookingInfos.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            leadGenAppointmentBookingInfos.add(LeadGenAppointmentBookingInfo.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                leadGenAppointmentBookingInfos.add(LeadGenAppointmentBookingInfo.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            leadGenAppointmentBookingInfos.add(LeadGenAppointmentBookingInfo.loadJSON(obj.toString(), context));
                        }
                    }
                    return leadGenAppointmentBookingInfos;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        leadGenAppointmentBookingInfos.add(LeadGenAppointmentBookingInfo.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return leadGenAppointmentBookingInfos;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        leadGenAppointmentBookingInfos.add(LeadGenAppointmentBookingInfo.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return leadGenAppointmentBookingInfos;
                }
                leadGenAppointmentBookingInfos.clear();
                leadGenAppointmentBookingInfos.add(LeadGenAppointmentBookingInfo.loadJSON(json, context));
                return leadGenAppointmentBookingInfos;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return LeadGenAppointmentBookingInfo.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAdvertiserTimezoneOffset() {
        return this.mAdvertiserTimezoneOffset;
    }

    public List<String> getFieldAppointmentDurations() {
        return this.mAppointmentDurations;
    }

    public List<Object> getFieldAppointmentSlotsByDay() {
        return this.mAppointmentSlotsByDay;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public LeadGenAppointmentBookingInfo copyFrom(LeadGenAppointmentBookingInfo instance) {
        this.mAdvertiserTimezoneOffset = instance.mAdvertiserTimezoneOffset;
        this.mAppointmentDurations = instance.mAppointmentDurations;
        this.mAppointmentSlotsByDay = instance.mAppointmentSlotsByDay;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<LeadGenAppointmentBookingInfo> getParser() {
        return new APIRequest.ResponseParser<LeadGenAppointmentBookingInfo>(){

            @Override
            public APINodeList<LeadGenAppointmentBookingInfo> parseResponse(String response, APIContext context, APIRequest<LeadGenAppointmentBookingInfo> request) throws APIException.MalformedResponseException {
                return LeadGenAppointmentBookingInfo.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<LeadGenAppointmentBookingInfo> {
        LeadGenAppointmentBookingInfo lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"advertiser_timezone_offset", "appointment_durations", "appointment_slots_by_day", "id"};

        @Override
        public LeadGenAppointmentBookingInfo getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public LeadGenAppointmentBookingInfo parseResponse(String response) throws APIException {
            return LeadGenAppointmentBookingInfo.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public LeadGenAppointmentBookingInfo execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public LeadGenAppointmentBookingInfo execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<LeadGenAppointmentBookingInfo> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<LeadGenAppointmentBookingInfo> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, LeadGenAppointmentBookingInfo>(){

                public LeadGenAppointmentBookingInfo apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAdvertiserTimezoneOffsetField() {
            return this.requestAdvertiserTimezoneOffsetField(true);
        }

        public APIRequestGet requestAdvertiserTimezoneOffsetField(boolean value) {
            this.requestField("advertiser_timezone_offset", value);
            return this;
        }

        public APIRequestGet requestAppointmentDurationsField() {
            return this.requestAppointmentDurationsField(true);
        }

        public APIRequestGet requestAppointmentDurationsField(boolean value) {
            this.requestField("appointment_durations", value);
            return this;
        }

        public APIRequestGet requestAppointmentSlotsByDayField() {
            return this.requestAppointmentSlotsByDayField(true);
        }

        public APIRequestGet requestAppointmentSlotsByDayField(boolean value) {
            this.requestField("appointment_slots_by_day", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

