/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.IDName;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlexibleTargeting
extends APINode {
    @SerializedName(value="behaviors")
    private List<IDName> mBehaviors = null;
    @SerializedName(value="college_years")
    private List<Long> mCollegeYears = null;
    @SerializedName(value="connections")
    private List<IDName> mConnections = null;
    @SerializedName(value="custom_audiences")
    private List<IDName> mCustomAudiences = null;
    @SerializedName(value="education_majors")
    private List<IDName> mEducationMajors = null;
    @SerializedName(value="education_schools")
    private List<IDName> mEducationSchools = null;
    @SerializedName(value="education_statuses")
    private List<Long> mEducationStatuses = null;
    @SerializedName(value="ethnic_affinity")
    private List<IDName> mEthnicAffinity = null;
    @SerializedName(value="family_statuses")
    private List<IDName> mFamilyStatuses = null;
    @SerializedName(value="friends_of_connections")
    private List<IDName> mFriendsOfConnections = null;
    @SerializedName(value="generation")
    private List<IDName> mGeneration = null;
    @SerializedName(value="home_ownership")
    private List<IDName> mHomeOwnership = null;
    @SerializedName(value="home_type")
    private List<IDName> mHomeType = null;
    @SerializedName(value="home_value")
    private List<IDName> mHomeValue = null;
    @SerializedName(value="household_composition")
    private List<IDName> mHouseholdComposition = null;
    @SerializedName(value="income")
    private List<IDName> mIncome = null;
    @SerializedName(value="industries")
    private List<IDName> mIndustries = null;
    @SerializedName(value="interested_in")
    private List<Long> mInterestedIn = null;
    @SerializedName(value="interests")
    private List<IDName> mInterests = null;
    @SerializedName(value="life_events")
    private List<IDName> mLifeEvents = null;
    @SerializedName(value="moms")
    private List<IDName> mMoms = null;
    @SerializedName(value="net_worth")
    private List<IDName> mNetWorth = null;
    @SerializedName(value="office_type")
    private List<IDName> mOfficeType = null;
    @SerializedName(value="politics")
    private List<IDName> mPolitics = null;
    @SerializedName(value="relationship_statuses")
    private List<Long> mRelationshipStatuses = null;
    @SerializedName(value="user_adclusters")
    private List<IDName> mUserAdclusters = null;
    @SerializedName(value="work_employers")
    private List<IDName> mWorkEmployers = null;
    @SerializedName(value="work_positions")
    private List<IDName> mWorkPositions = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    FlexibleTargeting() {
    }

    public FlexibleTargeting(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public FlexibleTargeting(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public FlexibleTargeting fetch() throws APIException {
        FlexibleTargeting newInstance = FlexibleTargeting.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static FlexibleTargeting fetchById(Long id, APIContext context) throws APIException {
        return FlexibleTargeting.fetchById(id.toString(), context);
    }

    public static ListenableFuture<FlexibleTargeting> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return FlexibleTargeting.fetchByIdAsync(id.toString(), context);
    }

    public static FlexibleTargeting fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<FlexibleTargeting> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<FlexibleTargeting> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<FlexibleTargeting>(context, "", "/", "GET", FlexibleTargeting.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<FlexibleTargeting>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<FlexibleTargeting>(context, "", "/", "GET", FlexibleTargeting.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static FlexibleTargeting loadJSON(String json, APIContext context) {
        FlexibleTargeting flexibleTargeting = (FlexibleTargeting)FlexibleTargeting.getGson().fromJson(json, FlexibleTargeting.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(flexibleTargeting.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        flexibleTargeting.context = context;
        flexibleTargeting.rawValue = json;
        return flexibleTargeting;
    }

    public static APINodeList<FlexibleTargeting> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<FlexibleTargeting> flexibleTargetings = new APINodeList<FlexibleTargeting>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        flexibleTargetings.add(FlexibleTargeting.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return flexibleTargetings;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            flexibleTargetings.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        flexibleTargetings.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            flexibleTargetings.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            flexibleTargetings.add(FlexibleTargeting.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                flexibleTargetings.add(FlexibleTargeting.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            flexibleTargetings.add(FlexibleTargeting.loadJSON(obj.toString(), context));
                        }
                    }
                    return flexibleTargetings;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        flexibleTargetings.add(FlexibleTargeting.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return flexibleTargetings;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        flexibleTargetings.add(FlexibleTargeting.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return flexibleTargetings;
                }
                flexibleTargetings.clear();
                flexibleTargetings.add(FlexibleTargeting.loadJSON(json, context));
                return flexibleTargetings;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return FlexibleTargeting.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public List<IDName> getFieldBehaviors() {
        return this.mBehaviors;
    }

    public List<Long> getFieldCollegeYears() {
        return this.mCollegeYears;
    }

    public List<IDName> getFieldConnections() {
        return this.mConnections;
    }

    public List<IDName> getFieldCustomAudiences() {
        return this.mCustomAudiences;
    }

    public List<IDName> getFieldEducationMajors() {
        return this.mEducationMajors;
    }

    public List<IDName> getFieldEducationSchools() {
        return this.mEducationSchools;
    }

    public List<Long> getFieldEducationStatuses() {
        return this.mEducationStatuses;
    }

    public List<IDName> getFieldEthnicAffinity() {
        return this.mEthnicAffinity;
    }

    public List<IDName> getFieldFamilyStatuses() {
        return this.mFamilyStatuses;
    }

    public List<IDName> getFieldFriendsOfConnections() {
        return this.mFriendsOfConnections;
    }

    public List<IDName> getFieldGeneration() {
        return this.mGeneration;
    }

    public List<IDName> getFieldHomeOwnership() {
        return this.mHomeOwnership;
    }

    public List<IDName> getFieldHomeType() {
        return this.mHomeType;
    }

    public List<IDName> getFieldHomeValue() {
        return this.mHomeValue;
    }

    public List<IDName> getFieldHouseholdComposition() {
        return this.mHouseholdComposition;
    }

    public List<IDName> getFieldIncome() {
        return this.mIncome;
    }

    public List<IDName> getFieldIndustries() {
        return this.mIndustries;
    }

    public List<Long> getFieldInterestedIn() {
        return this.mInterestedIn;
    }

    public List<IDName> getFieldInterests() {
        return this.mInterests;
    }

    public List<IDName> getFieldLifeEvents() {
        return this.mLifeEvents;
    }

    public List<IDName> getFieldMoms() {
        return this.mMoms;
    }

    public List<IDName> getFieldNetWorth() {
        return this.mNetWorth;
    }

    public List<IDName> getFieldOfficeType() {
        return this.mOfficeType;
    }

    public List<IDName> getFieldPolitics() {
        return this.mPolitics;
    }

    public List<Long> getFieldRelationshipStatuses() {
        return this.mRelationshipStatuses;
    }

    public List<IDName> getFieldUserAdclusters() {
        return this.mUserAdclusters;
    }

    public List<IDName> getFieldWorkEmployers() {
        return this.mWorkEmployers;
    }

    public List<IDName> getFieldWorkPositions() {
        return this.mWorkPositions;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public FlexibleTargeting copyFrom(FlexibleTargeting instance) {
        this.mBehaviors = instance.mBehaviors;
        this.mCollegeYears = instance.mCollegeYears;
        this.mConnections = instance.mConnections;
        this.mCustomAudiences = instance.mCustomAudiences;
        this.mEducationMajors = instance.mEducationMajors;
        this.mEducationSchools = instance.mEducationSchools;
        this.mEducationStatuses = instance.mEducationStatuses;
        this.mEthnicAffinity = instance.mEthnicAffinity;
        this.mFamilyStatuses = instance.mFamilyStatuses;
        this.mFriendsOfConnections = instance.mFriendsOfConnections;
        this.mGeneration = instance.mGeneration;
        this.mHomeOwnership = instance.mHomeOwnership;
        this.mHomeType = instance.mHomeType;
        this.mHomeValue = instance.mHomeValue;
        this.mHouseholdComposition = instance.mHouseholdComposition;
        this.mIncome = instance.mIncome;
        this.mIndustries = instance.mIndustries;
        this.mInterestedIn = instance.mInterestedIn;
        this.mInterests = instance.mInterests;
        this.mLifeEvents = instance.mLifeEvents;
        this.mMoms = instance.mMoms;
        this.mNetWorth = instance.mNetWorth;
        this.mOfficeType = instance.mOfficeType;
        this.mPolitics = instance.mPolitics;
        this.mRelationshipStatuses = instance.mRelationshipStatuses;
        this.mUserAdclusters = instance.mUserAdclusters;
        this.mWorkEmployers = instance.mWorkEmployers;
        this.mWorkPositions = instance.mWorkPositions;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<FlexibleTargeting> getParser() {
        return new APIRequest.ResponseParser<FlexibleTargeting>(){

            @Override
            public APINodeList<FlexibleTargeting> parseResponse(String response, APIContext context, APIRequest<FlexibleTargeting> request) throws APIException.MalformedResponseException {
                return FlexibleTargeting.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<FlexibleTargeting> {
        FlexibleTargeting lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"behaviors", "college_years", "connections", "custom_audiences", "education_majors", "education_schools", "education_statuses", "ethnic_affinity", "family_statuses", "friends_of_connections", "generation", "home_ownership", "home_type", "home_value", "household_composition", "income", "industries", "interested_in", "interests", "life_events", "moms", "net_worth", "office_type", "politics", "relationship_statuses", "user_adclusters", "work_employers", "work_positions", "id"};

        @Override
        public FlexibleTargeting getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public FlexibleTargeting parseResponse(String response) throws APIException {
            return FlexibleTargeting.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public FlexibleTargeting execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public FlexibleTargeting execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<FlexibleTargeting> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<FlexibleTargeting> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, FlexibleTargeting>(){

                public FlexibleTargeting apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestBehaviorsField() {
            return this.requestBehaviorsField(true);
        }

        public APIRequestGet requestBehaviorsField(boolean value) {
            this.requestField("behaviors", value);
            return this;
        }

        public APIRequestGet requestCollegeYearsField() {
            return this.requestCollegeYearsField(true);
        }

        public APIRequestGet requestCollegeYearsField(boolean value) {
            this.requestField("college_years", value);
            return this;
        }

        public APIRequestGet requestConnectionsField() {
            return this.requestConnectionsField(true);
        }

        public APIRequestGet requestConnectionsField(boolean value) {
            this.requestField("connections", value);
            return this;
        }

        public APIRequestGet requestCustomAudiencesField() {
            return this.requestCustomAudiencesField(true);
        }

        public APIRequestGet requestCustomAudiencesField(boolean value) {
            this.requestField("custom_audiences", value);
            return this;
        }

        public APIRequestGet requestEducationMajorsField() {
            return this.requestEducationMajorsField(true);
        }

        public APIRequestGet requestEducationMajorsField(boolean value) {
            this.requestField("education_majors", value);
            return this;
        }

        public APIRequestGet requestEducationSchoolsField() {
            return this.requestEducationSchoolsField(true);
        }

        public APIRequestGet requestEducationSchoolsField(boolean value) {
            this.requestField("education_schools", value);
            return this;
        }

        public APIRequestGet requestEducationStatusesField() {
            return this.requestEducationStatusesField(true);
        }

        public APIRequestGet requestEducationStatusesField(boolean value) {
            this.requestField("education_statuses", value);
            return this;
        }

        public APIRequestGet requestEthnicAffinityField() {
            return this.requestEthnicAffinityField(true);
        }

        public APIRequestGet requestEthnicAffinityField(boolean value) {
            this.requestField("ethnic_affinity", value);
            return this;
        }

        public APIRequestGet requestFamilyStatusesField() {
            return this.requestFamilyStatusesField(true);
        }

        public APIRequestGet requestFamilyStatusesField(boolean value) {
            this.requestField("family_statuses", value);
            return this;
        }

        public APIRequestGet requestFriendsOfConnectionsField() {
            return this.requestFriendsOfConnectionsField(true);
        }

        public APIRequestGet requestFriendsOfConnectionsField(boolean value) {
            this.requestField("friends_of_connections", value);
            return this;
        }

        public APIRequestGet requestGenerationField() {
            return this.requestGenerationField(true);
        }

        public APIRequestGet requestGenerationField(boolean value) {
            this.requestField("generation", value);
            return this;
        }

        public APIRequestGet requestHomeOwnershipField() {
            return this.requestHomeOwnershipField(true);
        }

        public APIRequestGet requestHomeOwnershipField(boolean value) {
            this.requestField("home_ownership", value);
            return this;
        }

        public APIRequestGet requestHomeTypeField() {
            return this.requestHomeTypeField(true);
        }

        public APIRequestGet requestHomeTypeField(boolean value) {
            this.requestField("home_type", value);
            return this;
        }

        public APIRequestGet requestHomeValueField() {
            return this.requestHomeValueField(true);
        }

        public APIRequestGet requestHomeValueField(boolean value) {
            this.requestField("home_value", value);
            return this;
        }

        public APIRequestGet requestHouseholdCompositionField() {
            return this.requestHouseholdCompositionField(true);
        }

        public APIRequestGet requestHouseholdCompositionField(boolean value) {
            this.requestField("household_composition", value);
            return this;
        }

        public APIRequestGet requestIncomeField() {
            return this.requestIncomeField(true);
        }

        public APIRequestGet requestIncomeField(boolean value) {
            this.requestField("income", value);
            return this;
        }

        public APIRequestGet requestIndustriesField() {
            return this.requestIndustriesField(true);
        }

        public APIRequestGet requestIndustriesField(boolean value) {
            this.requestField("industries", value);
            return this;
        }

        public APIRequestGet requestInterestedInField() {
            return this.requestInterestedInField(true);
        }

        public APIRequestGet requestInterestedInField(boolean value) {
            this.requestField("interested_in", value);
            return this;
        }

        public APIRequestGet requestInterestsField() {
            return this.requestInterestsField(true);
        }

        public APIRequestGet requestInterestsField(boolean value) {
            this.requestField("interests", value);
            return this;
        }

        public APIRequestGet requestLifeEventsField() {
            return this.requestLifeEventsField(true);
        }

        public APIRequestGet requestLifeEventsField(boolean value) {
            this.requestField("life_events", value);
            return this;
        }

        public APIRequestGet requestMomsField() {
            return this.requestMomsField(true);
        }

        public APIRequestGet requestMomsField(boolean value) {
            this.requestField("moms", value);
            return this;
        }

        public APIRequestGet requestNetWorthField() {
            return this.requestNetWorthField(true);
        }

        public APIRequestGet requestNetWorthField(boolean value) {
            this.requestField("net_worth", value);
            return this;
        }

        public APIRequestGet requestOfficeTypeField() {
            return this.requestOfficeTypeField(true);
        }

        public APIRequestGet requestOfficeTypeField(boolean value) {
            this.requestField("office_type", value);
            return this;
        }

        public APIRequestGet requestPoliticsField() {
            return this.requestPoliticsField(true);
        }

        public APIRequestGet requestPoliticsField(boolean value) {
            this.requestField("politics", value);
            return this;
        }

        public APIRequestGet requestRelationshipStatusesField() {
            return this.requestRelationshipStatusesField(true);
        }

        public APIRequestGet requestRelationshipStatusesField(boolean value) {
            this.requestField("relationship_statuses", value);
            return this;
        }

        public APIRequestGet requestUserAdclustersField() {
            return this.requestUserAdclustersField(true);
        }

        public APIRequestGet requestUserAdclustersField(boolean value) {
            this.requestField("user_adclusters", value);
            return this;
        }

        public APIRequestGet requestWorkEmployersField() {
            return this.requestWorkEmployersField(true);
        }

        public APIRequestGet requestWorkEmployersField(boolean value) {
            this.requestField("work_employers", value);
            return this;
        }

        public APIRequestGet requestWorkPositionsField() {
            return this.requestWorkPositionsField(true);
        }

        public APIRequestGet requestWorkPositionsField(boolean value) {
            this.requestField("work_positions", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

