/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomAudienceSession
extends APINode {
    @SerializedName(value="end_time")
    private String mEndTime = null;
    @SerializedName(value="num_invalid_entries")
    private String mNumInvalidEntries = null;
    @SerializedName(value="num_matched")
    private String mNumMatched = null;
    @SerializedName(value="num_received")
    private String mNumReceived = null;
    @SerializedName(value="progress")
    private String mProgress = null;
    @SerializedName(value="session_id")
    private String mSessionId = null;
    @SerializedName(value="stage")
    private String mStage = null;
    @SerializedName(value="start_time")
    private String mStartTime = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    CustomAudienceSession() {
    }

    public CustomAudienceSession(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public CustomAudienceSession(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public CustomAudienceSession fetch() throws APIException {
        CustomAudienceSession newInstance = CustomAudienceSession.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static CustomAudienceSession fetchById(Long id, APIContext context) throws APIException {
        return CustomAudienceSession.fetchById(id.toString(), context);
    }

    public static ListenableFuture<CustomAudienceSession> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return CustomAudienceSession.fetchByIdAsync(id.toString(), context);
    }

    public static CustomAudienceSession fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<CustomAudienceSession> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<CustomAudienceSession> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<CustomAudienceSession>(context, "", "/", "GET", CustomAudienceSession.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<CustomAudienceSession>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<CustomAudienceSession>(context, "", "/", "GET", CustomAudienceSession.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static CustomAudienceSession loadJSON(String json, APIContext context) {
        CustomAudienceSession customAudienceSession = (CustomAudienceSession)CustomAudienceSession.getGson().fromJson(json, CustomAudienceSession.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(customAudienceSession.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        customAudienceSession.context = context;
        customAudienceSession.rawValue = json;
        return customAudienceSession;
    }

    public static APINodeList<CustomAudienceSession> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<CustomAudienceSession> customAudienceSessions = new APINodeList<CustomAudienceSession>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        customAudienceSessions.add(CustomAudienceSession.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return customAudienceSessions;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            customAudienceSessions.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        customAudienceSessions.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            customAudienceSessions.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            customAudienceSessions.add(CustomAudienceSession.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                customAudienceSessions.add(CustomAudienceSession.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            customAudienceSessions.add(CustomAudienceSession.loadJSON(obj.toString(), context));
                        }
                    }
                    return customAudienceSessions;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        customAudienceSessions.add(CustomAudienceSession.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return customAudienceSessions;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        customAudienceSessions.add(CustomAudienceSession.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return customAudienceSessions;
                }
                customAudienceSessions.clear();
                customAudienceSessions.add(CustomAudienceSession.loadJSON(json, context));
                return customAudienceSessions;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return CustomAudienceSession.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldEndTime() {
        return this.mEndTime;
    }

    public String getFieldNumInvalidEntries() {
        return this.mNumInvalidEntries;
    }

    public String getFieldNumMatched() {
        return this.mNumMatched;
    }

    public String getFieldNumReceived() {
        return this.mNumReceived;
    }

    public String getFieldProgress() {
        return this.mProgress;
    }

    public String getFieldSessionId() {
        return this.mSessionId;
    }

    public String getFieldStage() {
        return this.mStage;
    }

    public String getFieldStartTime() {
        return this.mStartTime;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public CustomAudienceSession copyFrom(CustomAudienceSession instance) {
        this.mEndTime = instance.mEndTime;
        this.mNumInvalidEntries = instance.mNumInvalidEntries;
        this.mNumMatched = instance.mNumMatched;
        this.mNumReceived = instance.mNumReceived;
        this.mProgress = instance.mProgress;
        this.mSessionId = instance.mSessionId;
        this.mStage = instance.mStage;
        this.mStartTime = instance.mStartTime;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<CustomAudienceSession> getParser() {
        return new APIRequest.ResponseParser<CustomAudienceSession>(){

            @Override
            public APINodeList<CustomAudienceSession> parseResponse(String response, APIContext context, APIRequest<CustomAudienceSession> request) throws APIException.MalformedResponseException {
                return CustomAudienceSession.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<CustomAudienceSession> {
        CustomAudienceSession lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"end_time", "num_invalid_entries", "num_matched", "num_received", "progress", "session_id", "stage", "start_time", "id"};

        @Override
        public CustomAudienceSession getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public CustomAudienceSession parseResponse(String response) throws APIException {
            return CustomAudienceSession.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public CustomAudienceSession execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public CustomAudienceSession execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<CustomAudienceSession> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<CustomAudienceSession> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, CustomAudienceSession>(){

                public CustomAudienceSession apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestEndTimeField() {
            return this.requestEndTimeField(true);
        }

        public APIRequestGet requestEndTimeField(boolean value) {
            this.requestField("end_time", value);
            return this;
        }

        public APIRequestGet requestNumInvalidEntriesField() {
            return this.requestNumInvalidEntriesField(true);
        }

        public APIRequestGet requestNumInvalidEntriesField(boolean value) {
            this.requestField("num_invalid_entries", value);
            return this;
        }

        public APIRequestGet requestNumMatchedField() {
            return this.requestNumMatchedField(true);
        }

        public APIRequestGet requestNumMatchedField(boolean value) {
            this.requestField("num_matched", value);
            return this;
        }

        public APIRequestGet requestNumReceivedField() {
            return this.requestNumReceivedField(true);
        }

        public APIRequestGet requestNumReceivedField(boolean value) {
            this.requestField("num_received", value);
            return this;
        }

        public APIRequestGet requestProgressField() {
            return this.requestProgressField(true);
        }

        public APIRequestGet requestProgressField(boolean value) {
            this.requestField("progress", value);
            return this;
        }

        public APIRequestGet requestSessionIdField() {
            return this.requestSessionIdField(true);
        }

        public APIRequestGet requestSessionIdField(boolean value) {
            this.requestField("session_id", value);
            return this;
        }

        public APIRequestGet requestStageField() {
            return this.requestStageField(true);
        }

        public APIRequestGet requestStageField(boolean value) {
            this.requestField("stage", value);
            return this;
        }

        public APIRequestGet requestStartTimeField() {
            return this.requestStartTimeField(true);
        }

        public APIRequestGet requestStartTimeField(boolean value) {
            this.requestField("start_time", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

