/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BilledAmountDetails
extends APINode {
    @SerializedName(value="currency")
    private String mCurrency = null;
    @SerializedName(value="net_amount")
    private String mNetAmount = null;
    @SerializedName(value="tax_amount")
    private String mTaxAmount = null;
    @SerializedName(value="total_amount")
    private String mTotalAmount = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    BilledAmountDetails() {
    }

    public BilledAmountDetails(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public BilledAmountDetails(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public BilledAmountDetails fetch() throws APIException {
        BilledAmountDetails newInstance = BilledAmountDetails.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static BilledAmountDetails fetchById(Long id, APIContext context) throws APIException {
        return BilledAmountDetails.fetchById(id.toString(), context);
    }

    public static ListenableFuture<BilledAmountDetails> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return BilledAmountDetails.fetchByIdAsync(id.toString(), context);
    }

    public static BilledAmountDetails fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<BilledAmountDetails> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<BilledAmountDetails> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<BilledAmountDetails>(context, "", "/", "GET", BilledAmountDetails.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<BilledAmountDetails>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<BilledAmountDetails>(context, "", "/", "GET", BilledAmountDetails.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static BilledAmountDetails loadJSON(String json, APIContext context) {
        BilledAmountDetails billedAmountDetails = (BilledAmountDetails)BilledAmountDetails.getGson().fromJson(json, BilledAmountDetails.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(billedAmountDetails.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        billedAmountDetails.context = context;
        billedAmountDetails.rawValue = json;
        return billedAmountDetails;
    }

    public static APINodeList<BilledAmountDetails> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<BilledAmountDetails> billedAmountDetailss = new APINodeList<BilledAmountDetails>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        billedAmountDetailss.add(BilledAmountDetails.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return billedAmountDetailss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            billedAmountDetailss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        billedAmountDetailss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            billedAmountDetailss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            billedAmountDetailss.add(BilledAmountDetails.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                billedAmountDetailss.add(BilledAmountDetails.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            billedAmountDetailss.add(BilledAmountDetails.loadJSON(obj.toString(), context));
                        }
                    }
                    return billedAmountDetailss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        billedAmountDetailss.add(BilledAmountDetails.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return billedAmountDetailss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        billedAmountDetailss.add(BilledAmountDetails.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return billedAmountDetailss;
                }
                billedAmountDetailss.clear();
                billedAmountDetailss.add(BilledAmountDetails.loadJSON(json, context));
                return billedAmountDetailss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return BilledAmountDetails.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldCurrency() {
        return this.mCurrency;
    }

    public String getFieldNetAmount() {
        return this.mNetAmount;
    }

    public String getFieldTaxAmount() {
        return this.mTaxAmount;
    }

    public String getFieldTotalAmount() {
        return this.mTotalAmount;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public BilledAmountDetails copyFrom(BilledAmountDetails instance) {
        this.mCurrency = instance.mCurrency;
        this.mNetAmount = instance.mNetAmount;
        this.mTaxAmount = instance.mTaxAmount;
        this.mTotalAmount = instance.mTotalAmount;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<BilledAmountDetails> getParser() {
        return new APIRequest.ResponseParser<BilledAmountDetails>(){

            @Override
            public APINodeList<BilledAmountDetails> parseResponse(String response, APIContext context, APIRequest<BilledAmountDetails> request) throws APIException.MalformedResponseException {
                return BilledAmountDetails.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<BilledAmountDetails> {
        BilledAmountDetails lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"currency", "net_amount", "tax_amount", "total_amount", "id"};

        @Override
        public BilledAmountDetails getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public BilledAmountDetails parseResponse(String response) throws APIException {
            return BilledAmountDetails.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public BilledAmountDetails execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public BilledAmountDetails execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<BilledAmountDetails> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<BilledAmountDetails> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, BilledAmountDetails>(){

                public BilledAmountDetails apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGet requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGet requestNetAmountField() {
            return this.requestNetAmountField(true);
        }

        public APIRequestGet requestNetAmountField(boolean value) {
            this.requestField("net_amount", value);
            return this;
        }

        public APIRequestGet requestTaxAmountField() {
            return this.requestTaxAmountField(true);
        }

        public APIRequestGet requestTaxAmountField(boolean value) {
            this.requestField("tax_amount", value);
            return this;
        }

        public APIRequestGet requestTotalAmountField() {
            return this.requestTotalAmountField(true);
        }

        public APIRequestGet requestTotalAmountField(boolean value) {
            this.requestField("total_amount", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

