/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdsTALNudge
extends APINode {
    @SerializedName(value="nudge_type")
    private String mNudgeType = null;
    @SerializedName(value="objective_id")
    private String mObjectiveId = null;
    @SerializedName(value="study_id")
    private String mStudyId = null;
    @SerializedName(value="winner_cell_id")
    private String mWinnerCellId = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    AdsTALNudge() {
    }

    public AdsTALNudge(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdsTALNudge(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdsTALNudge fetch() throws APIException {
        AdsTALNudge newInstance = AdsTALNudge.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdsTALNudge fetchById(Long id, APIContext context) throws APIException {
        return AdsTALNudge.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdsTALNudge> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdsTALNudge.fetchByIdAsync(id.toString(), context);
    }

    public static AdsTALNudge fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdsTALNudge> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdsTALNudge> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdsTALNudge>(context, "", "/", "GET", AdsTALNudge.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdsTALNudge>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdsTALNudge>(context, "", "/", "GET", AdsTALNudge.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdsTALNudge loadJSON(String json, APIContext context) {
        AdsTALNudge adsTALNudge = (AdsTALNudge)AdsTALNudge.getGson().fromJson(json, AdsTALNudge.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adsTALNudge.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adsTALNudge.context = context;
        adsTALNudge.rawValue = json;
        return adsTALNudge;
    }

    public static APINodeList<AdsTALNudge> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdsTALNudge> adsTALNudges = new APINodeList<AdsTALNudge>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adsTALNudges.add(AdsTALNudge.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adsTALNudges;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adsTALNudges.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adsTALNudges.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adsTALNudges.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adsTALNudges.add(AdsTALNudge.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adsTALNudges.add(AdsTALNudge.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adsTALNudges.add(AdsTALNudge.loadJSON(obj.toString(), context));
                        }
                    }
                    return adsTALNudges;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adsTALNudges.add(AdsTALNudge.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adsTALNudges;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adsTALNudges.add(AdsTALNudge.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adsTALNudges;
                }
                adsTALNudges.clear();
                adsTALNudges.add(AdsTALNudge.loadJSON(json, context));
                return adsTALNudges;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdsTALNudge.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldNudgeType() {
        return this.mNudgeType;
    }

    public String getFieldObjectiveId() {
        return this.mObjectiveId;
    }

    public String getFieldStudyId() {
        return this.mStudyId;
    }

    public String getFieldWinnerCellId() {
        return this.mWinnerCellId;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdsTALNudge copyFrom(AdsTALNudge instance) {
        this.mNudgeType = instance.mNudgeType;
        this.mObjectiveId = instance.mObjectiveId;
        this.mStudyId = instance.mStudyId;
        this.mWinnerCellId = instance.mWinnerCellId;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdsTALNudge> getParser() {
        return new APIRequest.ResponseParser<AdsTALNudge>(){

            @Override
            public APINodeList<AdsTALNudge> parseResponse(String response, APIContext context, APIRequest<AdsTALNudge> request) throws APIException.MalformedResponseException {
                return AdsTALNudge.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdsTALNudge> {
        AdsTALNudge lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"nudge_type", "objective_id", "study_id", "winner_cell_id", "id"};

        @Override
        public AdsTALNudge getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdsTALNudge parseResponse(String response) throws APIException {
            return AdsTALNudge.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdsTALNudge execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdsTALNudge execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdsTALNudge> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdsTALNudge> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdsTALNudge>(){

                public AdsTALNudge apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestNudgeTypeField() {
            return this.requestNudgeTypeField(true);
        }

        public APIRequestGet requestNudgeTypeField(boolean value) {
            this.requestField("nudge_type", value);
            return this;
        }

        public APIRequestGet requestObjectiveIdField() {
            return this.requestObjectiveIdField(true);
        }

        public APIRequestGet requestObjectiveIdField(boolean value) {
            this.requestField("objective_id", value);
            return this;
        }

        public APIRequestGet requestStudyIdField() {
            return this.requestStudyIdField(true);
        }

        public APIRequestGet requestStudyIdField(boolean value) {
            this.requestField("study_id", value);
            return this;
        }

        public APIRequestGet requestWinnerCellIdField() {
            return this.requestWinnerCellIdField(true);
        }

        public APIRequestGet requestWinnerCellIdField(boolean value) {
            this.requestField("winner_cell_id", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

