/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdRecommendationData;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdRecommendation
extends APINode {
    @SerializedName(value="blame_field")
    private String mBlameField = null;
    @SerializedName(value="code")
    private Long mCode = null;
    @SerializedName(value="confidence")
    private EnumConfidence mConfidence = null;
    @SerializedName(value="importance")
    private EnumImportance mImportance = null;
    @SerializedName(value="message")
    private String mMessage = null;
    @SerializedName(value="recommendation_data")
    private AdRecommendationData mRecommendationData = null;
    @SerializedName(value="title")
    private String mTitle = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    AdRecommendation() {
    }

    public AdRecommendation(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdRecommendation(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdRecommendation fetch() throws APIException {
        AdRecommendation newInstance = AdRecommendation.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdRecommendation fetchById(Long id, APIContext context) throws APIException {
        return AdRecommendation.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdRecommendation> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdRecommendation.fetchByIdAsync(id.toString(), context);
    }

    public static AdRecommendation fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdRecommendation> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdRecommendation> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdRecommendation>(context, "", "/", "GET", AdRecommendation.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdRecommendation>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdRecommendation>(context, "", "/", "GET", AdRecommendation.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdRecommendation loadJSON(String json, APIContext context) {
        AdRecommendation adRecommendation = (AdRecommendation)AdRecommendation.getGson().fromJson(json, AdRecommendation.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adRecommendation.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adRecommendation.context = context;
        adRecommendation.rawValue = json;
        return adRecommendation;
    }

    public static APINodeList<AdRecommendation> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdRecommendation> adRecommendations = new APINodeList<AdRecommendation>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adRecommendations.add(AdRecommendation.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adRecommendations;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adRecommendations.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adRecommendations.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adRecommendations.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adRecommendations.add(AdRecommendation.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adRecommendations.add(AdRecommendation.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adRecommendations.add(AdRecommendation.loadJSON(obj.toString(), context));
                        }
                    }
                    return adRecommendations;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adRecommendations.add(AdRecommendation.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adRecommendations;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adRecommendations.add(AdRecommendation.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adRecommendations;
                }
                adRecommendations.clear();
                adRecommendations.add(AdRecommendation.loadJSON(json, context));
                return adRecommendations;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdRecommendation.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldBlameField() {
        return this.mBlameField;
    }

    public Long getFieldCode() {
        return this.mCode;
    }

    public EnumConfidence getFieldConfidence() {
        return this.mConfidence;
    }

    public EnumImportance getFieldImportance() {
        return this.mImportance;
    }

    public String getFieldMessage() {
        return this.mMessage;
    }

    public AdRecommendationData getFieldRecommendationData() {
        if (this.mRecommendationData != null) {
            this.mRecommendationData.context = this.getContext();
        }
        return this.mRecommendationData;
    }

    public String getFieldTitle() {
        return this.mTitle;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdRecommendation copyFrom(AdRecommendation instance) {
        this.mBlameField = instance.mBlameField;
        this.mCode = instance.mCode;
        this.mConfidence = instance.mConfidence;
        this.mImportance = instance.mImportance;
        this.mMessage = instance.mMessage;
        this.mRecommendationData = instance.mRecommendationData;
        this.mTitle = instance.mTitle;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdRecommendation> getParser() {
        return new APIRequest.ResponseParser<AdRecommendation>(){

            @Override
            public APINodeList<AdRecommendation> parseResponse(String response, APIContext context, APIRequest<AdRecommendation> request) throws APIException.MalformedResponseException {
                return AdRecommendation.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumImportance {
        VALUE_HIGH("HIGH"),
        VALUE_MEDIUM("MEDIUM"),
        VALUE_LOW("LOW"),
        NULL(null);

        private String value;

        private EnumImportance(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumConfidence {
        VALUE_HIGH("HIGH"),
        VALUE_MEDIUM("MEDIUM"),
        VALUE_LOW("LOW"),
        NULL(null);

        private String value;

        private EnumConfidence(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdRecommendation> {
        AdRecommendation lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"blame_field", "code", "confidence", "importance", "message", "recommendation_data", "title", "id"};

        @Override
        public AdRecommendation getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdRecommendation parseResponse(String response) throws APIException {
            return AdRecommendation.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdRecommendation execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdRecommendation execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdRecommendation> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdRecommendation> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdRecommendation>(){

                public AdRecommendation apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestBlameFieldField() {
            return this.requestBlameFieldField(true);
        }

        public APIRequestGet requestBlameFieldField(boolean value) {
            this.requestField("blame_field", value);
            return this;
        }

        public APIRequestGet requestCodeField() {
            return this.requestCodeField(true);
        }

        public APIRequestGet requestCodeField(boolean value) {
            this.requestField("code", value);
            return this;
        }

        public APIRequestGet requestConfidenceField() {
            return this.requestConfidenceField(true);
        }

        public APIRequestGet requestConfidenceField(boolean value) {
            this.requestField("confidence", value);
            return this;
        }

        public APIRequestGet requestImportanceField() {
            return this.requestImportanceField(true);
        }

        public APIRequestGet requestImportanceField(boolean value) {
            this.requestField("importance", value);
            return this;
        }

        public APIRequestGet requestMessageField() {
            return this.requestMessageField(true);
        }

        public APIRequestGet requestMessageField(boolean value) {
            this.requestField("message", value);
            return this;
        }

        public APIRequestGet requestRecommendationDataField() {
            return this.requestRecommendationDataField(true);
        }

        public APIRequestGet requestRecommendationDataField(boolean value) {
            this.requestField("recommendation_data", value);
            return this;
        }

        public APIRequestGet requestTitleField() {
            return this.requestTitleField(true);
        }

        public APIRequestGet requestTitleField(boolean value) {
            this.requestField("title", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

