/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdPromotedObject
extends APINode {
    @SerializedName(value="application_id")
    private String mApplicationId = null;
    @SerializedName(value="custom_conversion_id")
    private String mCustomConversionId = null;
    @SerializedName(value="custom_event_type")
    private EnumCustomEventType mCustomEventType = null;
    @SerializedName(value="event_id")
    private String mEventId = null;
    @SerializedName(value="fundraiser_campaign_id")
    private String mFundraiserCampaignId = null;
    @SerializedName(value="object_store_url")
    private String mObjectStoreUrl = null;
    @SerializedName(value="offer_id")
    private String mOfferId = null;
    @SerializedName(value="offline_conversion_data_set_id")
    private String mOfflineConversionDataSetId = null;
    @SerializedName(value="page_id")
    private String mPageId = null;
    @SerializedName(value="pixel_aggregation_rule")
    private String mPixelAggregationRule = null;
    @SerializedName(value="pixel_id")
    private String mPixelId = null;
    @SerializedName(value="pixel_rule")
    private String mPixelRule = null;
    @SerializedName(value="place_page_set_id")
    private String mPlacePageSetId = null;
    @SerializedName(value="product_catalog_id")
    private String mProductCatalogId = null;
    @SerializedName(value="product_item_id")
    private String mProductItemId = null;
    @SerializedName(value="product_set_id")
    private String mProductSetId = null;
    @SerializedName(value="retention_days")
    private String mRetentionDays = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    AdPromotedObject() {
    }

    public AdPromotedObject(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdPromotedObject(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdPromotedObject fetch() throws APIException {
        AdPromotedObject newInstance = AdPromotedObject.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdPromotedObject fetchById(Long id, APIContext context) throws APIException {
        return AdPromotedObject.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdPromotedObject> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdPromotedObject.fetchByIdAsync(id.toString(), context);
    }

    public static AdPromotedObject fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdPromotedObject> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdPromotedObject> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdPromotedObject>(context, "", "/", "GET", AdPromotedObject.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdPromotedObject>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdPromotedObject>(context, "", "/", "GET", AdPromotedObject.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdPromotedObject loadJSON(String json, APIContext context) {
        AdPromotedObject adPromotedObject = (AdPromotedObject)AdPromotedObject.getGson().fromJson(json, AdPromotedObject.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adPromotedObject.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adPromotedObject.context = context;
        adPromotedObject.rawValue = json;
        return adPromotedObject;
    }

    public static APINodeList<AdPromotedObject> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdPromotedObject> adPromotedObjects = new APINodeList<AdPromotedObject>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adPromotedObjects.add(AdPromotedObject.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adPromotedObjects;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adPromotedObjects.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adPromotedObjects.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adPromotedObjects.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adPromotedObjects.add(AdPromotedObject.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adPromotedObjects.add(AdPromotedObject.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adPromotedObjects.add(AdPromotedObject.loadJSON(obj.toString(), context));
                        }
                    }
                    return adPromotedObjects;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adPromotedObjects.add(AdPromotedObject.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adPromotedObjects;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adPromotedObjects.add(AdPromotedObject.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adPromotedObjects;
                }
                adPromotedObjects.clear();
                adPromotedObjects.add(AdPromotedObject.loadJSON(json, context));
                return adPromotedObjects;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdPromotedObject.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldApplicationId() {
        return this.mApplicationId;
    }

    public String getFieldCustomConversionId() {
        return this.mCustomConversionId;
    }

    public EnumCustomEventType getFieldCustomEventType() {
        return this.mCustomEventType;
    }

    public String getFieldEventId() {
        return this.mEventId;
    }

    public String getFieldFundraiserCampaignId() {
        return this.mFundraiserCampaignId;
    }

    public String getFieldObjectStoreUrl() {
        return this.mObjectStoreUrl;
    }

    public String getFieldOfferId() {
        return this.mOfferId;
    }

    public String getFieldOfflineConversionDataSetId() {
        return this.mOfflineConversionDataSetId;
    }

    public String getFieldPageId() {
        return this.mPageId;
    }

    public String getFieldPixelAggregationRule() {
        return this.mPixelAggregationRule;
    }

    public String getFieldPixelId() {
        return this.mPixelId;
    }

    public String getFieldPixelRule() {
        return this.mPixelRule;
    }

    public String getFieldPlacePageSetId() {
        return this.mPlacePageSetId;
    }

    public String getFieldProductCatalogId() {
        return this.mProductCatalogId;
    }

    public String getFieldProductItemId() {
        return this.mProductItemId;
    }

    public String getFieldProductSetId() {
        return this.mProductSetId;
    }

    public String getFieldRetentionDays() {
        return this.mRetentionDays;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdPromotedObject copyFrom(AdPromotedObject instance) {
        this.mApplicationId = instance.mApplicationId;
        this.mCustomConversionId = instance.mCustomConversionId;
        this.mCustomEventType = instance.mCustomEventType;
        this.mEventId = instance.mEventId;
        this.mFundraiserCampaignId = instance.mFundraiserCampaignId;
        this.mObjectStoreUrl = instance.mObjectStoreUrl;
        this.mOfferId = instance.mOfferId;
        this.mOfflineConversionDataSetId = instance.mOfflineConversionDataSetId;
        this.mPageId = instance.mPageId;
        this.mPixelAggregationRule = instance.mPixelAggregationRule;
        this.mPixelId = instance.mPixelId;
        this.mPixelRule = instance.mPixelRule;
        this.mPlacePageSetId = instance.mPlacePageSetId;
        this.mProductCatalogId = instance.mProductCatalogId;
        this.mProductItemId = instance.mProductItemId;
        this.mProductSetId = instance.mProductSetId;
        this.mRetentionDays = instance.mRetentionDays;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdPromotedObject> getParser() {
        return new APIRequest.ResponseParser<AdPromotedObject>(){

            @Override
            public APINodeList<AdPromotedObject> parseResponse(String response, APIContext context, APIRequest<AdPromotedObject> request) throws APIException.MalformedResponseException {
                return AdPromotedObject.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumCustomEventType {
        VALUE_RATE("RATE"),
        VALUE_TUTORIAL_COMPLETION("TUTORIAL_COMPLETION"),
        VALUE_CONTACT("CONTACT"),
        VALUE_CUSTOMIZE_PRODUCT("CUSTOMIZE_PRODUCT"),
        VALUE_DONATE("DONATE"),
        VALUE_FIND_LOCATION("FIND_LOCATION"),
        VALUE_SCHEDULE("SCHEDULE"),
        VALUE_START_TRIAL("START_TRIAL"),
        VALUE_SUBMIT_APPLICATION("SUBMIT_APPLICATION"),
        VALUE_SUBSCRIBE("SUBSCRIBE"),
        VALUE_ADD_TO_CART("ADD_TO_CART"),
        VALUE_ADD_TO_WISHLIST("ADD_TO_WISHLIST"),
        VALUE_INITIATED_CHECKOUT("INITIATED_CHECKOUT"),
        VALUE_ADD_PAYMENT_INFO("ADD_PAYMENT_INFO"),
        VALUE_PURCHASE("PURCHASE"),
        VALUE_LEAD("LEAD"),
        VALUE_COMPLETE_REGISTRATION("COMPLETE_REGISTRATION"),
        VALUE_CONTENT_VIEW("CONTENT_VIEW"),
        VALUE_SEARCH("SEARCH"),
        VALUE_SERVICE_BOOKING_REQUEST("SERVICE_BOOKING_REQUEST"),
        VALUE_MESSAGING_CONVERSATION_STARTED_7D("MESSAGING_CONVERSATION_STARTED_7D"),
        VALUE_LEVEL_ACHIEVED("LEVEL_ACHIEVED"),
        VALUE_ACHIEVEMENT_UNLOCKED("ACHIEVEMENT_UNLOCKED"),
        VALUE_SPENT_CREDITS("SPENT_CREDITS"),
        VALUE_D2_RETENTION("D2_RETENTION"),
        VALUE_D7_RETENTION("D7_RETENTION"),
        VALUE_OTHER("OTHER"),
        NULL(null);

        private String value;

        private EnumCustomEventType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdPromotedObject> {
        AdPromotedObject lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"application_id", "custom_conversion_id", "custom_event_type", "event_id", "fundraiser_campaign_id", "object_store_url", "offer_id", "offline_conversion_data_set_id", "page_id", "pixel_aggregation_rule", "pixel_id", "pixel_rule", "place_page_set_id", "product_catalog_id", "product_item_id", "product_set_id", "retention_days", "id"};

        @Override
        public AdPromotedObject getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdPromotedObject parseResponse(String response) throws APIException {
            return AdPromotedObject.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdPromotedObject execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdPromotedObject execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdPromotedObject> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdPromotedObject> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdPromotedObject>(){

                public AdPromotedObject apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestApplicationIdField() {
            return this.requestApplicationIdField(true);
        }

        public APIRequestGet requestApplicationIdField(boolean value) {
            this.requestField("application_id", value);
            return this;
        }

        public APIRequestGet requestCustomConversionIdField() {
            return this.requestCustomConversionIdField(true);
        }

        public APIRequestGet requestCustomConversionIdField(boolean value) {
            this.requestField("custom_conversion_id", value);
            return this;
        }

        public APIRequestGet requestCustomEventTypeField() {
            return this.requestCustomEventTypeField(true);
        }

        public APIRequestGet requestCustomEventTypeField(boolean value) {
            this.requestField("custom_event_type", value);
            return this;
        }

        public APIRequestGet requestEventIdField() {
            return this.requestEventIdField(true);
        }

        public APIRequestGet requestEventIdField(boolean value) {
            this.requestField("event_id", value);
            return this;
        }

        public APIRequestGet requestFundraiserCampaignIdField() {
            return this.requestFundraiserCampaignIdField(true);
        }

        public APIRequestGet requestFundraiserCampaignIdField(boolean value) {
            this.requestField("fundraiser_campaign_id", value);
            return this;
        }

        public APIRequestGet requestObjectStoreUrlField() {
            return this.requestObjectStoreUrlField(true);
        }

        public APIRequestGet requestObjectStoreUrlField(boolean value) {
            this.requestField("object_store_url", value);
            return this;
        }

        public APIRequestGet requestOfferIdField() {
            return this.requestOfferIdField(true);
        }

        public APIRequestGet requestOfferIdField(boolean value) {
            this.requestField("offer_id", value);
            return this;
        }

        public APIRequestGet requestOfflineConversionDataSetIdField() {
            return this.requestOfflineConversionDataSetIdField(true);
        }

        public APIRequestGet requestOfflineConversionDataSetIdField(boolean value) {
            this.requestField("offline_conversion_data_set_id", value);
            return this;
        }

        public APIRequestGet requestPageIdField() {
            return this.requestPageIdField(true);
        }

        public APIRequestGet requestPageIdField(boolean value) {
            this.requestField("page_id", value);
            return this;
        }

        public APIRequestGet requestPixelAggregationRuleField() {
            return this.requestPixelAggregationRuleField(true);
        }

        public APIRequestGet requestPixelAggregationRuleField(boolean value) {
            this.requestField("pixel_aggregation_rule", value);
            return this;
        }

        public APIRequestGet requestPixelIdField() {
            return this.requestPixelIdField(true);
        }

        public APIRequestGet requestPixelIdField(boolean value) {
            this.requestField("pixel_id", value);
            return this;
        }

        public APIRequestGet requestPixelRuleField() {
            return this.requestPixelRuleField(true);
        }

        public APIRequestGet requestPixelRuleField(boolean value) {
            this.requestField("pixel_rule", value);
            return this;
        }

        public APIRequestGet requestPlacePageSetIdField() {
            return this.requestPlacePageSetIdField(true);
        }

        public APIRequestGet requestPlacePageSetIdField(boolean value) {
            this.requestField("place_page_set_id", value);
            return this;
        }

        public APIRequestGet requestProductCatalogIdField() {
            return this.requestProductCatalogIdField(true);
        }

        public APIRequestGet requestProductCatalogIdField(boolean value) {
            this.requestField("product_catalog_id", value);
            return this;
        }

        public APIRequestGet requestProductItemIdField() {
            return this.requestProductItemIdField(true);
        }

        public APIRequestGet requestProductItemIdField(boolean value) {
            this.requestField("product_item_id", value);
            return this;
        }

        public APIRequestGet requestProductSetIdField() {
            return this.requestProductSetIdField(true);
        }

        public APIRequestGet requestProductSetIdField(boolean value) {
            this.requestField("product_set_id", value);
            return this;
        }

        public APIRequestGet requestRetentionDaysField() {
            return this.requestRetentionDaysField(true);
        }

        public APIRequestGet requestRetentionDaysField(boolean value) {
            this.requestField("retention_days", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

