/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdsActionStats;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdKeywordStats
extends APINode {
    @SerializedName(value="actions")
    private List<AdsActionStats> mActions = null;
    @SerializedName(value="clicks")
    private Long mClicks = null;
    @SerializedName(value="cost_per_total_action")
    private Double mCostPerTotalAction = null;
    @SerializedName(value="cost_per_unique_click")
    private Double mCostPerUniqueClick = null;
    @SerializedName(value="cpc")
    private Double mCpc = null;
    @SerializedName(value="cpm")
    private Double mCpm = null;
    @SerializedName(value="cpp")
    private Double mCpp = null;
    @SerializedName(value="ctr")
    private Double mCtr = null;
    @SerializedName(value="frequency")
    private Double mFrequency = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="impressions")
    private Long mImpressions = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="reach")
    private Long mReach = null;
    @SerializedName(value="spend")
    private Double mSpend = null;
    @SerializedName(value="total_actions")
    private Long mTotalActions = null;
    @SerializedName(value="total_unique_actions")
    private Long mTotalUniqueActions = null;
    @SerializedName(value="unique_actions")
    private List<AdsActionStats> mUniqueActions = null;
    @SerializedName(value="unique_clicks")
    private Long mUniqueClicks = null;
    @SerializedName(value="unique_ctr")
    private Double mUniqueCtr = null;
    @SerializedName(value="unique_impressions")
    private Long mUniqueImpressions = null;
    protected static Gson gson = null;

    AdKeywordStats() {
    }

    public AdKeywordStats(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdKeywordStats(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdKeywordStats fetch() throws APIException {
        AdKeywordStats newInstance = AdKeywordStats.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdKeywordStats fetchById(Long id, APIContext context) throws APIException {
        return AdKeywordStats.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdKeywordStats> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdKeywordStats.fetchByIdAsync(id.toString(), context);
    }

    public static AdKeywordStats fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdKeywordStats> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdKeywordStats> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdKeywordStats>(context, "", "/", "GET", AdKeywordStats.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdKeywordStats>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdKeywordStats>(context, "", "/", "GET", AdKeywordStats.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdKeywordStats loadJSON(String json, APIContext context) {
        AdKeywordStats adKeywordStats = (AdKeywordStats)AdKeywordStats.getGson().fromJson(json, AdKeywordStats.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adKeywordStats.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adKeywordStats.context = context;
        adKeywordStats.rawValue = json;
        return adKeywordStats;
    }

    public static APINodeList<AdKeywordStats> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdKeywordStats> adKeywordStatss = new APINodeList<AdKeywordStats>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adKeywordStatss.add(AdKeywordStats.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adKeywordStatss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adKeywordStatss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adKeywordStatss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adKeywordStatss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adKeywordStatss.add(AdKeywordStats.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adKeywordStatss.add(AdKeywordStats.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adKeywordStatss.add(AdKeywordStats.loadJSON(obj.toString(), context));
                        }
                    }
                    return adKeywordStatss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adKeywordStatss.add(AdKeywordStats.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adKeywordStatss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adKeywordStatss.add(AdKeywordStats.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adKeywordStatss;
                }
                adKeywordStatss.clear();
                adKeywordStatss.add(AdKeywordStats.loadJSON(json, context));
                return adKeywordStatss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdKeywordStats.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public List<AdsActionStats> getFieldActions() {
        return this.mActions;
    }

    public Long getFieldClicks() {
        return this.mClicks;
    }

    public Double getFieldCostPerTotalAction() {
        return this.mCostPerTotalAction;
    }

    public Double getFieldCostPerUniqueClick() {
        return this.mCostPerUniqueClick;
    }

    public Double getFieldCpc() {
        return this.mCpc;
    }

    public Double getFieldCpm() {
        return this.mCpm;
    }

    public Double getFieldCpp() {
        return this.mCpp;
    }

    public Double getFieldCtr() {
        return this.mCtr;
    }

    public Double getFieldFrequency() {
        return this.mFrequency;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Long getFieldImpressions() {
        return this.mImpressions;
    }

    public String getFieldName() {
        return this.mName;
    }

    public Long getFieldReach() {
        return this.mReach;
    }

    public Double getFieldSpend() {
        return this.mSpend;
    }

    public Long getFieldTotalActions() {
        return this.mTotalActions;
    }

    public Long getFieldTotalUniqueActions() {
        return this.mTotalUniqueActions;
    }

    public List<AdsActionStats> getFieldUniqueActions() {
        return this.mUniqueActions;
    }

    public Long getFieldUniqueClicks() {
        return this.mUniqueClicks;
    }

    public Double getFieldUniqueCtr() {
        return this.mUniqueCtr;
    }

    public Long getFieldUniqueImpressions() {
        return this.mUniqueImpressions;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdKeywordStats copyFrom(AdKeywordStats instance) {
        this.mActions = instance.mActions;
        this.mClicks = instance.mClicks;
        this.mCostPerTotalAction = instance.mCostPerTotalAction;
        this.mCostPerUniqueClick = instance.mCostPerUniqueClick;
        this.mCpc = instance.mCpc;
        this.mCpm = instance.mCpm;
        this.mCpp = instance.mCpp;
        this.mCtr = instance.mCtr;
        this.mFrequency = instance.mFrequency;
        this.mId = instance.mId;
        this.mImpressions = instance.mImpressions;
        this.mName = instance.mName;
        this.mReach = instance.mReach;
        this.mSpend = instance.mSpend;
        this.mTotalActions = instance.mTotalActions;
        this.mTotalUniqueActions = instance.mTotalUniqueActions;
        this.mUniqueActions = instance.mUniqueActions;
        this.mUniqueClicks = instance.mUniqueClicks;
        this.mUniqueCtr = instance.mUniqueCtr;
        this.mUniqueImpressions = instance.mUniqueImpressions;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdKeywordStats> getParser() {
        return new APIRequest.ResponseParser<AdKeywordStats>(){

            @Override
            public APINodeList<AdKeywordStats> parseResponse(String response, APIContext context, APIRequest<AdKeywordStats> request) throws APIException.MalformedResponseException {
                return AdKeywordStats.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdKeywordStats> {
        AdKeywordStats lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"actions", "clicks", "cost_per_total_action", "cost_per_unique_click", "cpc", "cpm", "cpp", "ctr", "frequency", "id", "impressions", "name", "reach", "spend", "total_actions", "total_unique_actions", "unique_actions", "unique_clicks", "unique_ctr", "unique_impressions"};

        @Override
        public AdKeywordStats getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdKeywordStats parseResponse(String response) throws APIException {
            return AdKeywordStats.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdKeywordStats execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdKeywordStats execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdKeywordStats> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdKeywordStats> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdKeywordStats>(){

                public AdKeywordStats apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestActionsField() {
            return this.requestActionsField(true);
        }

        public APIRequestGet requestActionsField(boolean value) {
            this.requestField("actions", value);
            return this;
        }

        public APIRequestGet requestClicksField() {
            return this.requestClicksField(true);
        }

        public APIRequestGet requestClicksField(boolean value) {
            this.requestField("clicks", value);
            return this;
        }

        public APIRequestGet requestCostPerTotalActionField() {
            return this.requestCostPerTotalActionField(true);
        }

        public APIRequestGet requestCostPerTotalActionField(boolean value) {
            this.requestField("cost_per_total_action", value);
            return this;
        }

        public APIRequestGet requestCostPerUniqueClickField() {
            return this.requestCostPerUniqueClickField(true);
        }

        public APIRequestGet requestCostPerUniqueClickField(boolean value) {
            this.requestField("cost_per_unique_click", value);
            return this;
        }

        public APIRequestGet requestCpcField() {
            return this.requestCpcField(true);
        }

        public APIRequestGet requestCpcField(boolean value) {
            this.requestField("cpc", value);
            return this;
        }

        public APIRequestGet requestCpmField() {
            return this.requestCpmField(true);
        }

        public APIRequestGet requestCpmField(boolean value) {
            this.requestField("cpm", value);
            return this;
        }

        public APIRequestGet requestCppField() {
            return this.requestCppField(true);
        }

        public APIRequestGet requestCppField(boolean value) {
            this.requestField("cpp", value);
            return this;
        }

        public APIRequestGet requestCtrField() {
            return this.requestCtrField(true);
        }

        public APIRequestGet requestCtrField(boolean value) {
            this.requestField("ctr", value);
            return this;
        }

        public APIRequestGet requestFrequencyField() {
            return this.requestFrequencyField(true);
        }

        public APIRequestGet requestFrequencyField(boolean value) {
            this.requestField("frequency", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestImpressionsField() {
            return this.requestImpressionsField(true);
        }

        public APIRequestGet requestImpressionsField(boolean value) {
            this.requestField("impressions", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestReachField() {
            return this.requestReachField(true);
        }

        public APIRequestGet requestReachField(boolean value) {
            this.requestField("reach", value);
            return this;
        }

        public APIRequestGet requestSpendField() {
            return this.requestSpendField(true);
        }

        public APIRequestGet requestSpendField(boolean value) {
            this.requestField("spend", value);
            return this;
        }

        public APIRequestGet requestTotalActionsField() {
            return this.requestTotalActionsField(true);
        }

        public APIRequestGet requestTotalActionsField(boolean value) {
            this.requestField("total_actions", value);
            return this;
        }

        public APIRequestGet requestTotalUniqueActionsField() {
            return this.requestTotalUniqueActionsField(true);
        }

        public APIRequestGet requestTotalUniqueActionsField(boolean value) {
            this.requestField("total_unique_actions", value);
            return this;
        }

        public APIRequestGet requestUniqueActionsField() {
            return this.requestUniqueActionsField(true);
        }

        public APIRequestGet requestUniqueActionsField(boolean value) {
            this.requestField("unique_actions", value);
            return this;
        }

        public APIRequestGet requestUniqueClicksField() {
            return this.requestUniqueClicksField(true);
        }

        public APIRequestGet requestUniqueClicksField(boolean value) {
            this.requestField("unique_clicks", value);
            return this;
        }

        public APIRequestGet requestUniqueCtrField() {
            return this.requestUniqueCtrField(true);
        }

        public APIRequestGet requestUniqueCtrField(boolean value) {
            this.requestField("unique_ctr", value);
            return this;
        }

        public APIRequestGet requestUniqueImpressionsField() {
            return this.requestUniqueImpressionsField(true);
        }

        public APIRequestGet requestUniqueImpressionsField(boolean value) {
            this.requestField("unique_impressions", value);
            return this;
        }
    }
}

