/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdEntityTargetSpend
extends APINode {
    @SerializedName(value="amount")
    private String mAmount = null;
    @SerializedName(value="has_error")
    private Boolean mHasError = null;
    @SerializedName(value="is_accurate")
    private Boolean mIsAccurate = null;
    @SerializedName(value="is_prorated")
    private Boolean mIsProrated = null;
    @SerializedName(value="is_updating")
    private Boolean mIsUpdating = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    AdEntityTargetSpend() {
    }

    public AdEntityTargetSpend(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdEntityTargetSpend(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdEntityTargetSpend fetch() throws APIException {
        AdEntityTargetSpend newInstance = AdEntityTargetSpend.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdEntityTargetSpend fetchById(Long id, APIContext context) throws APIException {
        return AdEntityTargetSpend.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdEntityTargetSpend> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdEntityTargetSpend.fetchByIdAsync(id.toString(), context);
    }

    public static AdEntityTargetSpend fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdEntityTargetSpend> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdEntityTargetSpend> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdEntityTargetSpend>(context, "", "/", "GET", AdEntityTargetSpend.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdEntityTargetSpend>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdEntityTargetSpend>(context, "", "/", "GET", AdEntityTargetSpend.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdEntityTargetSpend loadJSON(String json, APIContext context) {
        AdEntityTargetSpend adEntityTargetSpend = (AdEntityTargetSpend)AdEntityTargetSpend.getGson().fromJson(json, AdEntityTargetSpend.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adEntityTargetSpend.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adEntityTargetSpend.context = context;
        adEntityTargetSpend.rawValue = json;
        return adEntityTargetSpend;
    }

    public static APINodeList<AdEntityTargetSpend> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdEntityTargetSpend> adEntityTargetSpends = new APINodeList<AdEntityTargetSpend>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adEntityTargetSpends.add(AdEntityTargetSpend.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adEntityTargetSpends;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adEntityTargetSpends.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adEntityTargetSpends.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adEntityTargetSpends.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adEntityTargetSpends.add(AdEntityTargetSpend.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adEntityTargetSpends.add(AdEntityTargetSpend.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adEntityTargetSpends.add(AdEntityTargetSpend.loadJSON(obj.toString(), context));
                        }
                    }
                    return adEntityTargetSpends;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adEntityTargetSpends.add(AdEntityTargetSpend.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adEntityTargetSpends;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adEntityTargetSpends.add(AdEntityTargetSpend.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adEntityTargetSpends;
                }
                adEntityTargetSpends.clear();
                adEntityTargetSpends.add(AdEntityTargetSpend.loadJSON(json, context));
                return adEntityTargetSpends;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdEntityTargetSpend.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAmount() {
        return this.mAmount;
    }

    public Boolean getFieldHasError() {
        return this.mHasError;
    }

    public Boolean getFieldIsAccurate() {
        return this.mIsAccurate;
    }

    public Boolean getFieldIsProrated() {
        return this.mIsProrated;
    }

    public Boolean getFieldIsUpdating() {
        return this.mIsUpdating;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdEntityTargetSpend copyFrom(AdEntityTargetSpend instance) {
        this.mAmount = instance.mAmount;
        this.mHasError = instance.mHasError;
        this.mIsAccurate = instance.mIsAccurate;
        this.mIsProrated = instance.mIsProrated;
        this.mIsUpdating = instance.mIsUpdating;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdEntityTargetSpend> getParser() {
        return new APIRequest.ResponseParser<AdEntityTargetSpend>(){

            @Override
            public APINodeList<AdEntityTargetSpend> parseResponse(String response, APIContext context, APIRequest<AdEntityTargetSpend> request) throws APIException.MalformedResponseException {
                return AdEntityTargetSpend.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdEntityTargetSpend> {
        AdEntityTargetSpend lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"amount", "has_error", "is_accurate", "is_prorated", "is_updating", "id"};

        @Override
        public AdEntityTargetSpend getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdEntityTargetSpend parseResponse(String response) throws APIException {
            return AdEntityTargetSpend.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdEntityTargetSpend execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdEntityTargetSpend execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdEntityTargetSpend> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdEntityTargetSpend> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdEntityTargetSpend>(){

                public AdEntityTargetSpend apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAmountField() {
            return this.requestAmountField(true);
        }

        public APIRequestGet requestAmountField(boolean value) {
            this.requestField("amount", value);
            return this;
        }

        public APIRequestGet requestHasErrorField() {
            return this.requestHasErrorField(true);
        }

        public APIRequestGet requestHasErrorField(boolean value) {
            this.requestField("has_error", value);
            return this;
        }

        public APIRequestGet requestIsAccurateField() {
            return this.requestIsAccurateField(true);
        }

        public APIRequestGet requestIsAccurateField(boolean value) {
            this.requestField("is_accurate", value);
            return this;
        }

        public APIRequestGet requestIsProratedField() {
            return this.requestIsProratedField(true);
        }

        public APIRequestGet requestIsProratedField(boolean value) {
            this.requestField("is_prorated", value);
            return this;
        }

        public APIRequestGet requestIsUpdatingField() {
            return this.requestIsUpdatingField(true);
        }

        public APIRequestGet requestIsUpdatingField(boolean value) {
            this.requestField("is_updating", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

