/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdDeliveryInsights
extends APINode {
    @SerializedName(value="ad_set_id")
    private String mAdSetId = null;
    @SerializedName(value="auction_competitiveness")
    private Object mAuctionCompetitiveness = null;
    @SerializedName(value="auction_overlap")
    private Object mAuctionOverlap = null;
    @SerializedName(value="audience_saturation")
    private Object mAudienceSaturation = null;
    @SerializedName(value="date_start")
    private String mDateStart = null;
    @SerializedName(value="date_stop")
    private String mDateStop = null;
    @SerializedName(value="report_uris")
    private List<String> mReportUris = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    AdDeliveryInsights() {
    }

    public AdDeliveryInsights(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdDeliveryInsights(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdDeliveryInsights fetch() throws APIException {
        AdDeliveryInsights newInstance = AdDeliveryInsights.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdDeliveryInsights fetchById(Long id, APIContext context) throws APIException {
        return AdDeliveryInsights.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdDeliveryInsights> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdDeliveryInsights.fetchByIdAsync(id.toString(), context);
    }

    public static AdDeliveryInsights fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdDeliveryInsights> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdDeliveryInsights> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdDeliveryInsights>(context, "", "/", "GET", AdDeliveryInsights.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdDeliveryInsights>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdDeliveryInsights>(context, "", "/", "GET", AdDeliveryInsights.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdDeliveryInsights loadJSON(String json, APIContext context) {
        AdDeliveryInsights adDeliveryInsights = (AdDeliveryInsights)AdDeliveryInsights.getGson().fromJson(json, AdDeliveryInsights.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adDeliveryInsights.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adDeliveryInsights.context = context;
        adDeliveryInsights.rawValue = json;
        return adDeliveryInsights;
    }

    public static APINodeList<AdDeliveryInsights> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdDeliveryInsights> adDeliveryInsightss = new APINodeList<AdDeliveryInsights>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adDeliveryInsightss.add(AdDeliveryInsights.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adDeliveryInsightss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adDeliveryInsightss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adDeliveryInsightss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adDeliveryInsightss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adDeliveryInsightss.add(AdDeliveryInsights.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adDeliveryInsightss.add(AdDeliveryInsights.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adDeliveryInsightss.add(AdDeliveryInsights.loadJSON(obj.toString(), context));
                        }
                    }
                    return adDeliveryInsightss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adDeliveryInsightss.add(AdDeliveryInsights.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adDeliveryInsightss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adDeliveryInsightss.add(AdDeliveryInsights.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adDeliveryInsightss;
                }
                adDeliveryInsightss.clear();
                adDeliveryInsightss.add(AdDeliveryInsights.loadJSON(json, context));
                return adDeliveryInsightss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdDeliveryInsights.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAdSetId() {
        return this.mAdSetId;
    }

    public Object getFieldAuctionCompetitiveness() {
        return this.mAuctionCompetitiveness;
    }

    public Object getFieldAuctionOverlap() {
        return this.mAuctionOverlap;
    }

    public Object getFieldAudienceSaturation() {
        return this.mAudienceSaturation;
    }

    public String getFieldDateStart() {
        return this.mDateStart;
    }

    public String getFieldDateStop() {
        return this.mDateStop;
    }

    public List<String> getFieldReportUris() {
        return this.mReportUris;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdDeliveryInsights copyFrom(AdDeliveryInsights instance) {
        this.mAdSetId = instance.mAdSetId;
        this.mAuctionCompetitiveness = instance.mAuctionCompetitiveness;
        this.mAuctionOverlap = instance.mAuctionOverlap;
        this.mAudienceSaturation = instance.mAudienceSaturation;
        this.mDateStart = instance.mDateStart;
        this.mDateStop = instance.mDateStop;
        this.mReportUris = instance.mReportUris;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdDeliveryInsights> getParser() {
        return new APIRequest.ResponseParser<AdDeliveryInsights>(){

            @Override
            public APINodeList<AdDeliveryInsights> parseResponse(String response, APIContext context, APIRequest<AdDeliveryInsights> request) throws APIException.MalformedResponseException {
                return AdDeliveryInsights.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdDeliveryInsights> {
        AdDeliveryInsights lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"ad_set_id", "auction_competitiveness", "auction_overlap", "audience_saturation", "date_start", "date_stop", "report_uris", "id"};

        @Override
        public AdDeliveryInsights getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdDeliveryInsights parseResponse(String response) throws APIException {
            return AdDeliveryInsights.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdDeliveryInsights execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdDeliveryInsights execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdDeliveryInsights> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdDeliveryInsights> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdDeliveryInsights>(){

                public AdDeliveryInsights apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAdSetIdField() {
            return this.requestAdSetIdField(true);
        }

        public APIRequestGet requestAdSetIdField(boolean value) {
            this.requestField("ad_set_id", value);
            return this;
        }

        public APIRequestGet requestAuctionCompetitivenessField() {
            return this.requestAuctionCompetitivenessField(true);
        }

        public APIRequestGet requestAuctionCompetitivenessField(boolean value) {
            this.requestField("auction_competitiveness", value);
            return this;
        }

        public APIRequestGet requestAuctionOverlapField() {
            return this.requestAuctionOverlapField(true);
        }

        public APIRequestGet requestAuctionOverlapField(boolean value) {
            this.requestField("auction_overlap", value);
            return this;
        }

        public APIRequestGet requestAudienceSaturationField() {
            return this.requestAudienceSaturationField(true);
        }

        public APIRequestGet requestAudienceSaturationField(boolean value) {
            this.requestField("audience_saturation", value);
            return this;
        }

        public APIRequestGet requestDateStartField() {
            return this.requestDateStartField(true);
        }

        public APIRequestGet requestDateStartField(boolean value) {
            this.requestField("date_start", value);
            return this;
        }

        public APIRequestGet requestDateStopField() {
            return this.requestDateStopField(true);
        }

        public APIRequestGet requestDateStopField(boolean value) {
            this.requestField("date_stop", value);
            return this;
        }

        public APIRequestGet requestReportUrisField() {
            return this.requestReportUrisField(true);
        }

        public APIRequestGet requestReportUrisField(boolean value) {
            this.requestField("report_uris", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

