/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdCreativePhotoData
extends APINode {
    @SerializedName(value="branded_content_shared_to_sponsor_status")
    private String mBrandedContentSharedToSponsorStatus = null;
    @SerializedName(value="branded_content_sponsor_page_id")
    private String mBrandedContentSponsorPageId = null;
    @SerializedName(value="branded_content_sponsor_relationship")
    private String mBrandedContentSponsorRelationship = null;
    @SerializedName(value="caption")
    private String mCaption = null;
    @SerializedName(value="image_hash")
    private String mImageHash = null;
    @SerializedName(value="page_welcome_message")
    private String mPageWelcomeMessage = null;
    @SerializedName(value="url")
    private String mUrl = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    AdCreativePhotoData() {
    }

    public AdCreativePhotoData(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdCreativePhotoData(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdCreativePhotoData fetch() throws APIException {
        AdCreativePhotoData newInstance = AdCreativePhotoData.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdCreativePhotoData fetchById(Long id, APIContext context) throws APIException {
        return AdCreativePhotoData.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdCreativePhotoData> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdCreativePhotoData.fetchByIdAsync(id.toString(), context);
    }

    public static AdCreativePhotoData fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdCreativePhotoData> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdCreativePhotoData> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdCreativePhotoData>(context, "", "/", "GET", AdCreativePhotoData.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdCreativePhotoData>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdCreativePhotoData>(context, "", "/", "GET", AdCreativePhotoData.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdCreativePhotoData loadJSON(String json, APIContext context) {
        AdCreativePhotoData adCreativePhotoData = (AdCreativePhotoData)AdCreativePhotoData.getGson().fromJson(json, AdCreativePhotoData.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adCreativePhotoData.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adCreativePhotoData.context = context;
        adCreativePhotoData.rawValue = json;
        return adCreativePhotoData;
    }

    public static APINodeList<AdCreativePhotoData> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdCreativePhotoData> adCreativePhotoDatas = new APINodeList<AdCreativePhotoData>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adCreativePhotoDatas.add(AdCreativePhotoData.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adCreativePhotoDatas;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adCreativePhotoDatas.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adCreativePhotoDatas.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adCreativePhotoDatas.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adCreativePhotoDatas.add(AdCreativePhotoData.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adCreativePhotoDatas.add(AdCreativePhotoData.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adCreativePhotoDatas.add(AdCreativePhotoData.loadJSON(obj.toString(), context));
                        }
                    }
                    return adCreativePhotoDatas;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adCreativePhotoDatas.add(AdCreativePhotoData.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adCreativePhotoDatas;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adCreativePhotoDatas.add(AdCreativePhotoData.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adCreativePhotoDatas;
                }
                adCreativePhotoDatas.clear();
                adCreativePhotoDatas.add(AdCreativePhotoData.loadJSON(json, context));
                return adCreativePhotoDatas;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdCreativePhotoData.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldBrandedContentSharedToSponsorStatus() {
        return this.mBrandedContentSharedToSponsorStatus;
    }

    public String getFieldBrandedContentSponsorPageId() {
        return this.mBrandedContentSponsorPageId;
    }

    public String getFieldBrandedContentSponsorRelationship() {
        return this.mBrandedContentSponsorRelationship;
    }

    public String getFieldCaption() {
        return this.mCaption;
    }

    public String getFieldImageHash() {
        return this.mImageHash;
    }

    public String getFieldPageWelcomeMessage() {
        return this.mPageWelcomeMessage;
    }

    public String getFieldUrl() {
        return this.mUrl;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdCreativePhotoData copyFrom(AdCreativePhotoData instance) {
        this.mBrandedContentSharedToSponsorStatus = instance.mBrandedContentSharedToSponsorStatus;
        this.mBrandedContentSponsorPageId = instance.mBrandedContentSponsorPageId;
        this.mBrandedContentSponsorRelationship = instance.mBrandedContentSponsorRelationship;
        this.mCaption = instance.mCaption;
        this.mImageHash = instance.mImageHash;
        this.mPageWelcomeMessage = instance.mPageWelcomeMessage;
        this.mUrl = instance.mUrl;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdCreativePhotoData> getParser() {
        return new APIRequest.ResponseParser<AdCreativePhotoData>(){

            @Override
            public APINodeList<AdCreativePhotoData> parseResponse(String response, APIContext context, APIRequest<AdCreativePhotoData> request) throws APIException.MalformedResponseException {
                return AdCreativePhotoData.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdCreativePhotoData> {
        AdCreativePhotoData lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"branded_content_shared_to_sponsor_status", "branded_content_sponsor_page_id", "branded_content_sponsor_relationship", "caption", "image_hash", "page_welcome_message", "url", "id"};

        @Override
        public AdCreativePhotoData getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdCreativePhotoData parseResponse(String response) throws APIException {
            return AdCreativePhotoData.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdCreativePhotoData execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdCreativePhotoData execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdCreativePhotoData> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdCreativePhotoData> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdCreativePhotoData>(){

                public AdCreativePhotoData apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestBrandedContentSharedToSponsorStatusField() {
            return this.requestBrandedContentSharedToSponsorStatusField(true);
        }

        public APIRequestGet requestBrandedContentSharedToSponsorStatusField(boolean value) {
            this.requestField("branded_content_shared_to_sponsor_status", value);
            return this;
        }

        public APIRequestGet requestBrandedContentSponsorPageIdField() {
            return this.requestBrandedContentSponsorPageIdField(true);
        }

        public APIRequestGet requestBrandedContentSponsorPageIdField(boolean value) {
            this.requestField("branded_content_sponsor_page_id", value);
            return this;
        }

        public APIRequestGet requestBrandedContentSponsorRelationshipField() {
            return this.requestBrandedContentSponsorRelationshipField(true);
        }

        public APIRequestGet requestBrandedContentSponsorRelationshipField(boolean value) {
            this.requestField("branded_content_sponsor_relationship", value);
            return this;
        }

        public APIRequestGet requestCaptionField() {
            return this.requestCaptionField(true);
        }

        public APIRequestGet requestCaptionField(boolean value) {
            this.requestField("caption", value);
            return this;
        }

        public APIRequestGet requestImageHashField() {
            return this.requestImageHashField(true);
        }

        public APIRequestGet requestImageHashField(boolean value) {
            this.requestField("image_hash", value);
            return this;
        }

        public APIRequestGet requestPageWelcomeMessageField() {
            return this.requestPageWelcomeMessageField(true);
        }

        public APIRequestGet requestPageWelcomeMessageField(boolean value) {
            this.requestField("page_welcome_message", value);
            return this;
        }

        public APIRequestGet requestUrlField() {
            return this.requestUrlField(true);
        }

        public APIRequestGet requestUrlField(boolean value) {
            this.requestField("url", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

