/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdCreativeLinkDataCallToAction;
import com.facebook.ads.sdk.AdCreativePlaceData;
import com.facebook.ads.sdk.AdsImageCrops;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdCreativeLinkDataChildAttachment
extends APINode {
    @SerializedName(value="call_to_action")
    private AdCreativeLinkDataCallToAction mCallToAction = null;
    @SerializedName(value="caption")
    private String mCaption = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="image_crops")
    private AdsImageCrops mImageCrops = null;
    @SerializedName(value="image_hash")
    private String mImageHash = null;
    @SerializedName(value="link")
    private String mLink = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="picture")
    private String mPicture = null;
    @SerializedName(value="place_data")
    private AdCreativePlaceData mPlaceData = null;
    @SerializedName(value="referral_id")
    private String mReferralId = null;
    @SerializedName(value="static_card")
    private Boolean mStaticCard = null;
    @SerializedName(value="video_id")
    private String mVideoId = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    AdCreativeLinkDataChildAttachment() {
    }

    public AdCreativeLinkDataChildAttachment(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdCreativeLinkDataChildAttachment(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdCreativeLinkDataChildAttachment fetch() throws APIException {
        AdCreativeLinkDataChildAttachment newInstance = AdCreativeLinkDataChildAttachment.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdCreativeLinkDataChildAttachment fetchById(Long id, APIContext context) throws APIException {
        return AdCreativeLinkDataChildAttachment.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdCreativeLinkDataChildAttachment> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdCreativeLinkDataChildAttachment.fetchByIdAsync(id.toString(), context);
    }

    public static AdCreativeLinkDataChildAttachment fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdCreativeLinkDataChildAttachment> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdCreativeLinkDataChildAttachment> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdCreativeLinkDataChildAttachment>(context, "", "/", "GET", AdCreativeLinkDataChildAttachment.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdCreativeLinkDataChildAttachment>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdCreativeLinkDataChildAttachment>(context, "", "/", "GET", AdCreativeLinkDataChildAttachment.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdCreativeLinkDataChildAttachment loadJSON(String json, APIContext context) {
        AdCreativeLinkDataChildAttachment adCreativeLinkDataChildAttachment = (AdCreativeLinkDataChildAttachment)AdCreativeLinkDataChildAttachment.getGson().fromJson(json, AdCreativeLinkDataChildAttachment.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adCreativeLinkDataChildAttachment.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adCreativeLinkDataChildAttachment.context = context;
        adCreativeLinkDataChildAttachment.rawValue = json;
        return adCreativeLinkDataChildAttachment;
    }

    public static APINodeList<AdCreativeLinkDataChildAttachment> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdCreativeLinkDataChildAttachment> adCreativeLinkDataChildAttachments = new APINodeList<AdCreativeLinkDataChildAttachment>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adCreativeLinkDataChildAttachments.add(AdCreativeLinkDataChildAttachment.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adCreativeLinkDataChildAttachments;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adCreativeLinkDataChildAttachments.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adCreativeLinkDataChildAttachments.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adCreativeLinkDataChildAttachments.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adCreativeLinkDataChildAttachments.add(AdCreativeLinkDataChildAttachment.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adCreativeLinkDataChildAttachments.add(AdCreativeLinkDataChildAttachment.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adCreativeLinkDataChildAttachments.add(AdCreativeLinkDataChildAttachment.loadJSON(obj.toString(), context));
                        }
                    }
                    return adCreativeLinkDataChildAttachments;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adCreativeLinkDataChildAttachments.add(AdCreativeLinkDataChildAttachment.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adCreativeLinkDataChildAttachments;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adCreativeLinkDataChildAttachments.add(AdCreativeLinkDataChildAttachment.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adCreativeLinkDataChildAttachments;
                }
                adCreativeLinkDataChildAttachments.clear();
                adCreativeLinkDataChildAttachments.add(AdCreativeLinkDataChildAttachment.loadJSON(json, context));
                return adCreativeLinkDataChildAttachments;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdCreativeLinkDataChildAttachment.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public AdCreativeLinkDataCallToAction getFieldCallToAction() {
        if (this.mCallToAction != null) {
            this.mCallToAction.context = this.getContext();
        }
        return this.mCallToAction;
    }

    public String getFieldCaption() {
        return this.mCaption;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public AdsImageCrops getFieldImageCrops() {
        if (this.mImageCrops != null) {
            this.mImageCrops.context = this.getContext();
        }
        return this.mImageCrops;
    }

    public String getFieldImageHash() {
        return this.mImageHash;
    }

    public String getFieldLink() {
        return this.mLink;
    }

    public String getFieldName() {
        return this.mName;
    }

    public String getFieldPicture() {
        return this.mPicture;
    }

    public AdCreativePlaceData getFieldPlaceData() {
        if (this.mPlaceData != null) {
            this.mPlaceData.context = this.getContext();
        }
        return this.mPlaceData;
    }

    public String getFieldReferralId() {
        return this.mReferralId;
    }

    public Boolean getFieldStaticCard() {
        return this.mStaticCard;
    }

    public String getFieldVideoId() {
        return this.mVideoId;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdCreativeLinkDataChildAttachment copyFrom(AdCreativeLinkDataChildAttachment instance) {
        this.mCallToAction = instance.mCallToAction;
        this.mCaption = instance.mCaption;
        this.mDescription = instance.mDescription;
        this.mImageCrops = instance.mImageCrops;
        this.mImageHash = instance.mImageHash;
        this.mLink = instance.mLink;
        this.mName = instance.mName;
        this.mPicture = instance.mPicture;
        this.mPlaceData = instance.mPlaceData;
        this.mReferralId = instance.mReferralId;
        this.mStaticCard = instance.mStaticCard;
        this.mVideoId = instance.mVideoId;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdCreativeLinkDataChildAttachment> getParser() {
        return new APIRequest.ResponseParser<AdCreativeLinkDataChildAttachment>(){

            @Override
            public APINodeList<AdCreativeLinkDataChildAttachment> parseResponse(String response, APIContext context, APIRequest<AdCreativeLinkDataChildAttachment> request) throws APIException.MalformedResponseException {
                return AdCreativeLinkDataChildAttachment.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdCreativeLinkDataChildAttachment> {
        AdCreativeLinkDataChildAttachment lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"call_to_action", "caption", "description", "image_crops", "image_hash", "link", "name", "picture", "place_data", "referral_id", "static_card", "video_id", "id"};

        @Override
        public AdCreativeLinkDataChildAttachment getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdCreativeLinkDataChildAttachment parseResponse(String response) throws APIException {
            return AdCreativeLinkDataChildAttachment.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdCreativeLinkDataChildAttachment execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdCreativeLinkDataChildAttachment execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdCreativeLinkDataChildAttachment> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdCreativeLinkDataChildAttachment> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdCreativeLinkDataChildAttachment>(){

                public AdCreativeLinkDataChildAttachment apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCallToActionField() {
            return this.requestCallToActionField(true);
        }

        public APIRequestGet requestCallToActionField(boolean value) {
            this.requestField("call_to_action", value);
            return this;
        }

        public APIRequestGet requestCaptionField() {
            return this.requestCaptionField(true);
        }

        public APIRequestGet requestCaptionField(boolean value) {
            this.requestField("caption", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestImageCropsField() {
            return this.requestImageCropsField(true);
        }

        public APIRequestGet requestImageCropsField(boolean value) {
            this.requestField("image_crops", value);
            return this;
        }

        public APIRequestGet requestImageHashField() {
            return this.requestImageHashField(true);
        }

        public APIRequestGet requestImageHashField(boolean value) {
            this.requestField("image_hash", value);
            return this;
        }

        public APIRequestGet requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGet requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestPictureField() {
            return this.requestPictureField(true);
        }

        public APIRequestGet requestPictureField(boolean value) {
            this.requestField("picture", value);
            return this;
        }

        public APIRequestGet requestPlaceDataField() {
            return this.requestPlaceDataField(true);
        }

        public APIRequestGet requestPlaceDataField(boolean value) {
            this.requestField("place_data", value);
            return this;
        }

        public APIRequestGet requestReferralIdField() {
            return this.requestReferralIdField(true);
        }

        public APIRequestGet requestReferralIdField(boolean value) {
            this.requestField("referral_id", value);
            return this;
        }

        public APIRequestGet requestStaticCardField() {
            return this.requestStaticCardField(true);
        }

        public APIRequestGet requestStaticCardField(boolean value) {
            this.requestField("static_card", value);
            return this;
        }

        public APIRequestGet requestVideoIdField() {
            return this.requestVideoIdField(true);
        }

        public APIRequestGet requestVideoIdField(boolean value) {
            this.requestField("video_id", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

