/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdCreativeLinkDataCallToActionValue;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdCreativeLinkDataCallToAction
extends APINode {
    @SerializedName(value="type")
    private EnumType mType = null;
    @SerializedName(value="value")
    private AdCreativeLinkDataCallToActionValue mValue = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    AdCreativeLinkDataCallToAction() {
    }

    public AdCreativeLinkDataCallToAction(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdCreativeLinkDataCallToAction(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdCreativeLinkDataCallToAction fetch() throws APIException {
        AdCreativeLinkDataCallToAction newInstance = AdCreativeLinkDataCallToAction.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdCreativeLinkDataCallToAction fetchById(Long id, APIContext context) throws APIException {
        return AdCreativeLinkDataCallToAction.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdCreativeLinkDataCallToAction> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdCreativeLinkDataCallToAction.fetchByIdAsync(id.toString(), context);
    }

    public static AdCreativeLinkDataCallToAction fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdCreativeLinkDataCallToAction> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdCreativeLinkDataCallToAction> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdCreativeLinkDataCallToAction>(context, "", "/", "GET", AdCreativeLinkDataCallToAction.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdCreativeLinkDataCallToAction>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdCreativeLinkDataCallToAction>(context, "", "/", "GET", AdCreativeLinkDataCallToAction.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdCreativeLinkDataCallToAction loadJSON(String json, APIContext context) {
        AdCreativeLinkDataCallToAction adCreativeLinkDataCallToAction = (AdCreativeLinkDataCallToAction)AdCreativeLinkDataCallToAction.getGson().fromJson(json, AdCreativeLinkDataCallToAction.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adCreativeLinkDataCallToAction.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adCreativeLinkDataCallToAction.context = context;
        adCreativeLinkDataCallToAction.rawValue = json;
        return adCreativeLinkDataCallToAction;
    }

    public static APINodeList<AdCreativeLinkDataCallToAction> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdCreativeLinkDataCallToAction> adCreativeLinkDataCallToActions = new APINodeList<AdCreativeLinkDataCallToAction>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adCreativeLinkDataCallToActions.add(AdCreativeLinkDataCallToAction.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adCreativeLinkDataCallToActions;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adCreativeLinkDataCallToActions.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adCreativeLinkDataCallToActions.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adCreativeLinkDataCallToActions.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adCreativeLinkDataCallToActions.add(AdCreativeLinkDataCallToAction.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adCreativeLinkDataCallToActions.add(AdCreativeLinkDataCallToAction.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adCreativeLinkDataCallToActions.add(AdCreativeLinkDataCallToAction.loadJSON(obj.toString(), context));
                        }
                    }
                    return adCreativeLinkDataCallToActions;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adCreativeLinkDataCallToActions.add(AdCreativeLinkDataCallToAction.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adCreativeLinkDataCallToActions;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adCreativeLinkDataCallToActions.add(AdCreativeLinkDataCallToAction.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adCreativeLinkDataCallToActions;
                }
                adCreativeLinkDataCallToActions.clear();
                adCreativeLinkDataCallToActions.add(AdCreativeLinkDataCallToAction.loadJSON(json, context));
                return adCreativeLinkDataCallToActions;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdCreativeLinkDataCallToAction.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public EnumType getFieldType() {
        return this.mType;
    }

    public AdCreativeLinkDataCallToActionValue getFieldValue() {
        if (this.mValue != null) {
            this.mValue.context = this.getContext();
        }
        return this.mValue;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdCreativeLinkDataCallToAction copyFrom(AdCreativeLinkDataCallToAction instance) {
        this.mType = instance.mType;
        this.mValue = instance.mValue;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdCreativeLinkDataCallToAction> getParser() {
        return new APIRequest.ResponseParser<AdCreativeLinkDataCallToAction>(){

            @Override
            public APINodeList<AdCreativeLinkDataCallToAction> parseResponse(String response, APIContext context, APIRequest<AdCreativeLinkDataCallToAction> request) throws APIException.MalformedResponseException {
                return AdCreativeLinkDataCallToAction.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumType {
        VALUE_OPEN_LINK("OPEN_LINK"),
        VALUE_LIKE_PAGE("LIKE_PAGE"),
        VALUE_SHOP_NOW("SHOP_NOW"),
        VALUE_PLAY_GAME("PLAY_GAME"),
        VALUE_INSTALL_APP("INSTALL_APP"),
        VALUE_USE_APP("USE_APP"),
        VALUE_CALL("CALL"),
        VALUE_CALL_ME("CALL_ME"),
        VALUE_INSTALL_MOBILE_APP("INSTALL_MOBILE_APP"),
        VALUE_USE_MOBILE_APP("USE_MOBILE_APP"),
        VALUE_MOBILE_DOWNLOAD("MOBILE_DOWNLOAD"),
        VALUE_BOOK_TRAVEL("BOOK_TRAVEL"),
        VALUE_LISTEN_MUSIC("LISTEN_MUSIC"),
        VALUE_WATCH_VIDEO("WATCH_VIDEO"),
        VALUE_LEARN_MORE("LEARN_MORE"),
        VALUE_SIGN_UP("SIGN_UP"),
        VALUE_DOWNLOAD("DOWNLOAD"),
        VALUE_WATCH_MORE("WATCH_MORE"),
        VALUE_NO_BUTTON("NO_BUTTON"),
        VALUE_VISIT_PAGES_FEED("VISIT_PAGES_FEED"),
        VALUE_APPLY_NOW("APPLY_NOW"),
        VALUE_BUY_NOW("BUY_NOW"),
        VALUE_GET_OFFER("GET_OFFER"),
        VALUE_GET_OFFER_VIEW("GET_OFFER_VIEW"),
        VALUE_BUY_TICKETS("BUY_TICKETS"),
        VALUE_UPDATE_APP("UPDATE_APP"),
        VALUE_GET_DIRECTIONS("GET_DIRECTIONS"),
        VALUE_BUY("BUY"),
        VALUE_MESSAGE_PAGE("MESSAGE_PAGE"),
        VALUE_DONATE("DONATE"),
        VALUE_SUBSCRIBE("SUBSCRIBE"),
        VALUE_SAY_THANKS("SAY_THANKS"),
        VALUE_SELL_NOW("SELL_NOW"),
        VALUE_SHARE("SHARE"),
        VALUE_DONATE_NOW("DONATE_NOW"),
        VALUE_GET_QUOTE("GET_QUOTE"),
        VALUE_CONTACT_US("CONTACT_US"),
        VALUE_ORDER_NOW("ORDER_NOW"),
        VALUE_ADD_TO_CART("ADD_TO_CART"),
        VALUE_VIDEO_ANNOTATION("VIDEO_ANNOTATION"),
        VALUE_MOMENTS("MOMENTS"),
        VALUE_RECORD_NOW("RECORD_NOW"),
        VALUE_GET_SHOWTIMES("GET_SHOWTIMES"),
        VALUE_LISTEN_NOW("LISTEN_NOW"),
        VALUE_WOODHENGE_SUPPORT("WOODHENGE_SUPPORT"),
        VALUE_EVENT_RSVP("EVENT_RSVP"),
        VALUE_WHATSAPP_MESSAGE("WHATSAPP_MESSAGE"),
        VALUE_FOLLOW_NEWS_STORYLINE("FOLLOW_NEWS_STORYLINE"),
        NULL(null);

        private String value;

        private EnumType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdCreativeLinkDataCallToAction> {
        AdCreativeLinkDataCallToAction lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"type", "value", "id"};

        @Override
        public AdCreativeLinkDataCallToAction getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdCreativeLinkDataCallToAction parseResponse(String response) throws APIException {
            return AdCreativeLinkDataCallToAction.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdCreativeLinkDataCallToAction execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdCreativeLinkDataCallToAction execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdCreativeLinkDataCallToAction> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdCreativeLinkDataCallToAction> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdCreativeLinkDataCallToAction>(){

                public AdCreativeLinkDataCallToAction apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGet requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }

        public APIRequestGet requestValueField() {
            return this.requestValueField(true);
        }

        public APIRequestGet requestValueField(boolean value) {
            this.requestField("value", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

