/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdConversions
extends APINode {
    @SerializedName(value="account_id")
    private String mAccountId = null;
    @SerializedName(value="adgroup_id")
    private String mAdgroupId = null;
    @SerializedName(value="campaign_id")
    private String mCampaignId = null;
    @SerializedName(value="values")
    private JsonArray mValues = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    AdConversions() {
    }

    public AdConversions(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdConversions(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdConversions fetch() throws APIException {
        AdConversions newInstance = AdConversions.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdConversions fetchById(Long id, APIContext context) throws APIException {
        return AdConversions.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdConversions> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdConversions.fetchByIdAsync(id.toString(), context);
    }

    public static AdConversions fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdConversions> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdConversions> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdConversions>(context, "", "/", "GET", AdConversions.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdConversions>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdConversions>(context, "", "/", "GET", AdConversions.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdConversions loadJSON(String json, APIContext context) {
        AdConversions adConversions = (AdConversions)AdConversions.getGson().fromJson(json, AdConversions.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adConversions.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adConversions.context = context;
        adConversions.rawValue = json;
        return adConversions;
    }

    public static APINodeList<AdConversions> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdConversions> adConversionss = new APINodeList<AdConversions>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adConversionss.add(AdConversions.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adConversionss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adConversionss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adConversionss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adConversionss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adConversionss.add(AdConversions.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adConversionss.add(AdConversions.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adConversionss.add(AdConversions.loadJSON(obj.toString(), context));
                        }
                    }
                    return adConversionss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adConversionss.add(AdConversions.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adConversionss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adConversionss.add(AdConversions.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adConversionss;
                }
                adConversionss.clear();
                adConversionss.add(AdConversions.loadJSON(json, context));
                return adConversionss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdConversions.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAccountId() {
        return this.mAccountId;
    }

    public String getFieldAdgroupId() {
        return this.mAdgroupId;
    }

    public String getFieldCampaignId() {
        return this.mCampaignId;
    }

    public JsonArray getFieldValues() {
        return this.mValues;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdConversions copyFrom(AdConversions instance) {
        this.mAccountId = instance.mAccountId;
        this.mAdgroupId = instance.mAdgroupId;
        this.mCampaignId = instance.mCampaignId;
        this.mValues = instance.mValues;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdConversions> getParser() {
        return new APIRequest.ResponseParser<AdConversions>(){

            @Override
            public APINodeList<AdConversions> parseResponse(String response, APIContext context, APIRequest<AdConversions> request) throws APIException.MalformedResponseException {
                return AdConversions.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdConversions> {
        AdConversions lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"account_id", "adgroup_id", "campaign_id", "values", "id"};

        @Override
        public AdConversions getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdConversions parseResponse(String response) throws APIException {
            return AdConversions.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdConversions execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdConversions execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdConversions> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdConversions> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdConversions>(){

                public AdConversions apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGet requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGet requestAdgroupIdField() {
            return this.requestAdgroupIdField(true);
        }

        public APIRequestGet requestAdgroupIdField(boolean value) {
            this.requestField("adgroup_id", value);
            return this;
        }

        public APIRequestGet requestCampaignIdField() {
            return this.requestCampaignIdField(true);
        }

        public APIRequestGet requestCampaignIdField(boolean value) {
            this.requestField("campaign_id", value);
            return this;
        }

        public APIRequestGet requestValuesField() {
            return this.requestValuesField(true);
        }

        public APIRequestGet requestValuesField(boolean value) {
            this.requestField("values", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

