/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdCampaignFrequencyControlSpecs
extends APINode {
    @SerializedName(value="event")
    private String mEvent = null;
    @SerializedName(value="interval_days")
    private Long mIntervalDays = null;
    @SerializedName(value="max_frequency")
    private Long mMaxFrequency = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    AdCampaignFrequencyControlSpecs() {
    }

    public AdCampaignFrequencyControlSpecs(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdCampaignFrequencyControlSpecs(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdCampaignFrequencyControlSpecs fetch() throws APIException {
        AdCampaignFrequencyControlSpecs newInstance = AdCampaignFrequencyControlSpecs.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdCampaignFrequencyControlSpecs fetchById(Long id, APIContext context) throws APIException {
        return AdCampaignFrequencyControlSpecs.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdCampaignFrequencyControlSpecs> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdCampaignFrequencyControlSpecs.fetchByIdAsync(id.toString(), context);
    }

    public static AdCampaignFrequencyControlSpecs fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdCampaignFrequencyControlSpecs> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdCampaignFrequencyControlSpecs> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdCampaignFrequencyControlSpecs>(context, "", "/", "GET", AdCampaignFrequencyControlSpecs.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdCampaignFrequencyControlSpecs>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdCampaignFrequencyControlSpecs>(context, "", "/", "GET", AdCampaignFrequencyControlSpecs.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdCampaignFrequencyControlSpecs loadJSON(String json, APIContext context) {
        AdCampaignFrequencyControlSpecs adCampaignFrequencyControlSpecs = (AdCampaignFrequencyControlSpecs)AdCampaignFrequencyControlSpecs.getGson().fromJson(json, AdCampaignFrequencyControlSpecs.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adCampaignFrequencyControlSpecs.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adCampaignFrequencyControlSpecs.context = context;
        adCampaignFrequencyControlSpecs.rawValue = json;
        return adCampaignFrequencyControlSpecs;
    }

    public static APINodeList<AdCampaignFrequencyControlSpecs> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdCampaignFrequencyControlSpecs> adCampaignFrequencyControlSpecss = new APINodeList<AdCampaignFrequencyControlSpecs>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adCampaignFrequencyControlSpecss.add(AdCampaignFrequencyControlSpecs.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adCampaignFrequencyControlSpecss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adCampaignFrequencyControlSpecss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adCampaignFrequencyControlSpecss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adCampaignFrequencyControlSpecss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adCampaignFrequencyControlSpecss.add(AdCampaignFrequencyControlSpecs.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adCampaignFrequencyControlSpecss.add(AdCampaignFrequencyControlSpecs.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adCampaignFrequencyControlSpecss.add(AdCampaignFrequencyControlSpecs.loadJSON(obj.toString(), context));
                        }
                    }
                    return adCampaignFrequencyControlSpecss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adCampaignFrequencyControlSpecss.add(AdCampaignFrequencyControlSpecs.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adCampaignFrequencyControlSpecss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adCampaignFrequencyControlSpecss.add(AdCampaignFrequencyControlSpecs.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adCampaignFrequencyControlSpecss;
                }
                adCampaignFrequencyControlSpecss.clear();
                adCampaignFrequencyControlSpecss.add(AdCampaignFrequencyControlSpecs.loadJSON(json, context));
                return adCampaignFrequencyControlSpecss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdCampaignFrequencyControlSpecs.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldEvent() {
        return this.mEvent;
    }

    public Long getFieldIntervalDays() {
        return this.mIntervalDays;
    }

    public Long getFieldMaxFrequency() {
        return this.mMaxFrequency;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdCampaignFrequencyControlSpecs copyFrom(AdCampaignFrequencyControlSpecs instance) {
        this.mEvent = instance.mEvent;
        this.mIntervalDays = instance.mIntervalDays;
        this.mMaxFrequency = instance.mMaxFrequency;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdCampaignFrequencyControlSpecs> getParser() {
        return new APIRequest.ResponseParser<AdCampaignFrequencyControlSpecs>(){

            @Override
            public APINodeList<AdCampaignFrequencyControlSpecs> parseResponse(String response, APIContext context, APIRequest<AdCampaignFrequencyControlSpecs> request) throws APIException.MalformedResponseException {
                return AdCampaignFrequencyControlSpecs.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdCampaignFrequencyControlSpecs> {
        AdCampaignFrequencyControlSpecs lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"event", "interval_days", "max_frequency", "id"};

        @Override
        public AdCampaignFrequencyControlSpecs getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdCampaignFrequencyControlSpecs parseResponse(String response) throws APIException {
            return AdCampaignFrequencyControlSpecs.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdCampaignFrequencyControlSpecs execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdCampaignFrequencyControlSpecs execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdCampaignFrequencyControlSpecs> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdCampaignFrequencyControlSpecs> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdCampaignFrequencyControlSpecs>(){

                public AdCampaignFrequencyControlSpecs apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestEventField() {
            return this.requestEventField(true);
        }

        public APIRequestGet requestEventField(boolean value) {
            this.requestField("event", value);
            return this;
        }

        public APIRequestGet requestIntervalDaysField() {
            return this.requestIntervalDaysField(true);
        }

        public APIRequestGet requestIntervalDaysField(boolean value) {
            this.requestField("interval_days", value);
            return this;
        }

        public APIRequestGet requestMaxFrequencyField() {
            return this.requestMaxFrequencyField(true);
        }

        public APIRequestGet requestMaxFrequencyField(boolean value) {
            this.requestField("max_frequency", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

