/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.OutcomePredictionPoint;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdCampaignDeliveryEstimate
extends APINode {
    @SerializedName(value="bid_estimate")
    private Object mBidEstimate = null;
    @SerializedName(value="daily_outcomes_curve")
    private List<OutcomePredictionPoint> mDailyOutcomesCurve = null;
    @SerializedName(value="estimate_dau")
    private Long mEstimateDau = null;
    @SerializedName(value="estimate_mau")
    private Long mEstimateMau = null;
    @SerializedName(value="estimate_ready")
    private Boolean mEstimateReady = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    AdCampaignDeliveryEstimate() {
    }

    public AdCampaignDeliveryEstimate(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdCampaignDeliveryEstimate(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdCampaignDeliveryEstimate fetch() throws APIException {
        AdCampaignDeliveryEstimate newInstance = AdCampaignDeliveryEstimate.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdCampaignDeliveryEstimate fetchById(Long id, APIContext context) throws APIException {
        return AdCampaignDeliveryEstimate.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdCampaignDeliveryEstimate> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdCampaignDeliveryEstimate.fetchByIdAsync(id.toString(), context);
    }

    public static AdCampaignDeliveryEstimate fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdCampaignDeliveryEstimate> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdCampaignDeliveryEstimate> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdCampaignDeliveryEstimate>(context, "", "/", "GET", AdCampaignDeliveryEstimate.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdCampaignDeliveryEstimate>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdCampaignDeliveryEstimate>(context, "", "/", "GET", AdCampaignDeliveryEstimate.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdCampaignDeliveryEstimate loadJSON(String json, APIContext context) {
        AdCampaignDeliveryEstimate adCampaignDeliveryEstimate = (AdCampaignDeliveryEstimate)AdCampaignDeliveryEstimate.getGson().fromJson(json, AdCampaignDeliveryEstimate.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adCampaignDeliveryEstimate.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adCampaignDeliveryEstimate.context = context;
        adCampaignDeliveryEstimate.rawValue = json;
        return adCampaignDeliveryEstimate;
    }

    public static APINodeList<AdCampaignDeliveryEstimate> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdCampaignDeliveryEstimate> adCampaignDeliveryEstimates = new APINodeList<AdCampaignDeliveryEstimate>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adCampaignDeliveryEstimates.add(AdCampaignDeliveryEstimate.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adCampaignDeliveryEstimates;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adCampaignDeliveryEstimates.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adCampaignDeliveryEstimates.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adCampaignDeliveryEstimates.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adCampaignDeliveryEstimates.add(AdCampaignDeliveryEstimate.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adCampaignDeliveryEstimates.add(AdCampaignDeliveryEstimate.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adCampaignDeliveryEstimates.add(AdCampaignDeliveryEstimate.loadJSON(obj.toString(), context));
                        }
                    }
                    return adCampaignDeliveryEstimates;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adCampaignDeliveryEstimates.add(AdCampaignDeliveryEstimate.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adCampaignDeliveryEstimates;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adCampaignDeliveryEstimates.add(AdCampaignDeliveryEstimate.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adCampaignDeliveryEstimates;
                }
                adCampaignDeliveryEstimates.clear();
                adCampaignDeliveryEstimates.add(AdCampaignDeliveryEstimate.loadJSON(json, context));
                return adCampaignDeliveryEstimates;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdCampaignDeliveryEstimate.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Object getFieldBidEstimate() {
        return this.mBidEstimate;
    }

    public List<OutcomePredictionPoint> getFieldDailyOutcomesCurve() {
        return this.mDailyOutcomesCurve;
    }

    public Long getFieldEstimateDau() {
        return this.mEstimateDau;
    }

    public Long getFieldEstimateMau() {
        return this.mEstimateMau;
    }

    public Boolean getFieldEstimateReady() {
        return this.mEstimateReady;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdCampaignDeliveryEstimate copyFrom(AdCampaignDeliveryEstimate instance) {
        this.mBidEstimate = instance.mBidEstimate;
        this.mDailyOutcomesCurve = instance.mDailyOutcomesCurve;
        this.mEstimateDau = instance.mEstimateDau;
        this.mEstimateMau = instance.mEstimateMau;
        this.mEstimateReady = instance.mEstimateReady;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdCampaignDeliveryEstimate> getParser() {
        return new APIRequest.ResponseParser<AdCampaignDeliveryEstimate>(){

            @Override
            public APINodeList<AdCampaignDeliveryEstimate> parseResponse(String response, APIContext context, APIRequest<AdCampaignDeliveryEstimate> request) throws APIException.MalformedResponseException {
                return AdCampaignDeliveryEstimate.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumOptimizationGoal {
        VALUE_NONE("NONE"),
        VALUE_APP_INSTALLS("APP_INSTALLS"),
        VALUE_BRAND_AWARENESS("BRAND_AWARENESS"),
        VALUE_AD_RECALL_LIFT("AD_RECALL_LIFT"),
        VALUE_CLICKS("CLICKS"),
        VALUE_ENGAGED_USERS("ENGAGED_USERS"),
        VALUE_EVENT_RESPONSES("EVENT_RESPONSES"),
        VALUE_IMPRESSIONS("IMPRESSIONS"),
        VALUE_LEAD_GENERATION("LEAD_GENERATION"),
        VALUE_LINK_CLICKS("LINK_CLICKS"),
        VALUE_OFFER_CLAIMS("OFFER_CLAIMS"),
        VALUE_OFFSITE_CONVERSIONS("OFFSITE_CONVERSIONS"),
        VALUE_PAGE_ENGAGEMENT("PAGE_ENGAGEMENT"),
        VALUE_PAGE_LIKES("PAGE_LIKES"),
        VALUE_POST_ENGAGEMENT("POST_ENGAGEMENT"),
        VALUE_REACH("REACH"),
        VALUE_SOCIAL_IMPRESSIONS("SOCIAL_IMPRESSIONS"),
        VALUE_VIDEO_VIEWS("VIDEO_VIEWS"),
        VALUE_APP_DOWNLOADS("APP_DOWNLOADS"),
        VALUE_LANDING_PAGE_VIEWS("LANDING_PAGE_VIEWS"),
        VALUE_VALUE("VALUE"),
        VALUE_REPLIES("REPLIES"),
        VALUE_DERIVED_EVENTS("DERIVED_EVENTS"),
        NULL(null);

        private String value;

        private EnumOptimizationGoal(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdCampaignDeliveryEstimate> {
        AdCampaignDeliveryEstimate lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"bid_estimate", "daily_outcomes_curve", "estimate_dau", "estimate_mau", "estimate_ready", "id"};

        @Override
        public AdCampaignDeliveryEstimate getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdCampaignDeliveryEstimate parseResponse(String response) throws APIException {
            return AdCampaignDeliveryEstimate.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdCampaignDeliveryEstimate execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdCampaignDeliveryEstimate execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdCampaignDeliveryEstimate> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdCampaignDeliveryEstimate> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdCampaignDeliveryEstimate>(){

                public AdCampaignDeliveryEstimate apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestBidEstimateField() {
            return this.requestBidEstimateField(true);
        }

        public APIRequestGet requestBidEstimateField(boolean value) {
            this.requestField("bid_estimate", value);
            return this;
        }

        public APIRequestGet requestDailyOutcomesCurveField() {
            return this.requestDailyOutcomesCurveField(true);
        }

        public APIRequestGet requestDailyOutcomesCurveField(boolean value) {
            this.requestField("daily_outcomes_curve", value);
            return this;
        }

        public APIRequestGet requestEstimateDauField() {
            return this.requestEstimateDauField(true);
        }

        public APIRequestGet requestEstimateDauField(boolean value) {
            this.requestField("estimate_dau", value);
            return this;
        }

        public APIRequestGet requestEstimateMauField() {
            return this.requestEstimateMauField(true);
        }

        public APIRequestGet requestEstimateMauField(boolean value) {
            this.requestField("estimate_mau", value);
            return this;
        }

        public APIRequestGet requestEstimateReadyField() {
            return this.requestEstimateReadyField(true);
        }

        public APIRequestGet requestEstimateReadyField(boolean value) {
            this.requestField("estimate_ready", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

