/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdAssetFeedSpecAssetLabel;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdAssetFeedSpecGroupRule
extends APINode {
    @SerializedName(value="body_label")
    private AdAssetFeedSpecAssetLabel mBodyLabel = null;
    @SerializedName(value="caption_label")
    private AdAssetFeedSpecAssetLabel mCaptionLabel = null;
    @SerializedName(value="description_label")
    private AdAssetFeedSpecAssetLabel mDescriptionLabel = null;
    @SerializedName(value="image_label")
    private AdAssetFeedSpecAssetLabel mImageLabel = null;
    @SerializedName(value="link_url_label")
    private AdAssetFeedSpecAssetLabel mLinkUrlLabel = null;
    @SerializedName(value="title_label")
    private AdAssetFeedSpecAssetLabel mTitleLabel = null;
    @SerializedName(value="video_label")
    private AdAssetFeedSpecAssetLabel mVideoLabel = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    AdAssetFeedSpecGroupRule() {
    }

    public AdAssetFeedSpecGroupRule(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdAssetFeedSpecGroupRule(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdAssetFeedSpecGroupRule fetch() throws APIException {
        AdAssetFeedSpecGroupRule newInstance = AdAssetFeedSpecGroupRule.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdAssetFeedSpecGroupRule fetchById(Long id, APIContext context) throws APIException {
        return AdAssetFeedSpecGroupRule.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdAssetFeedSpecGroupRule> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdAssetFeedSpecGroupRule.fetchByIdAsync(id.toString(), context);
    }

    public static AdAssetFeedSpecGroupRule fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdAssetFeedSpecGroupRule> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdAssetFeedSpecGroupRule> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdAssetFeedSpecGroupRule>(context, "", "/", "GET", AdAssetFeedSpecGroupRule.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdAssetFeedSpecGroupRule>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdAssetFeedSpecGroupRule>(context, "", "/", "GET", AdAssetFeedSpecGroupRule.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdAssetFeedSpecGroupRule loadJSON(String json, APIContext context) {
        AdAssetFeedSpecGroupRule adAssetFeedSpecGroupRule = (AdAssetFeedSpecGroupRule)AdAssetFeedSpecGroupRule.getGson().fromJson(json, AdAssetFeedSpecGroupRule.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adAssetFeedSpecGroupRule.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adAssetFeedSpecGroupRule.context = context;
        adAssetFeedSpecGroupRule.rawValue = json;
        return adAssetFeedSpecGroupRule;
    }

    public static APINodeList<AdAssetFeedSpecGroupRule> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdAssetFeedSpecGroupRule> adAssetFeedSpecGroupRules = new APINodeList<AdAssetFeedSpecGroupRule>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adAssetFeedSpecGroupRules.add(AdAssetFeedSpecGroupRule.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adAssetFeedSpecGroupRules;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adAssetFeedSpecGroupRules.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adAssetFeedSpecGroupRules.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adAssetFeedSpecGroupRules.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adAssetFeedSpecGroupRules.add(AdAssetFeedSpecGroupRule.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adAssetFeedSpecGroupRules.add(AdAssetFeedSpecGroupRule.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adAssetFeedSpecGroupRules.add(AdAssetFeedSpecGroupRule.loadJSON(obj.toString(), context));
                        }
                    }
                    return adAssetFeedSpecGroupRules;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adAssetFeedSpecGroupRules.add(AdAssetFeedSpecGroupRule.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adAssetFeedSpecGroupRules;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adAssetFeedSpecGroupRules.add(AdAssetFeedSpecGroupRule.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adAssetFeedSpecGroupRules;
                }
                adAssetFeedSpecGroupRules.clear();
                adAssetFeedSpecGroupRules.add(AdAssetFeedSpecGroupRule.loadJSON(json, context));
                return adAssetFeedSpecGroupRules;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdAssetFeedSpecGroupRule.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public AdAssetFeedSpecAssetLabel getFieldBodyLabel() {
        if (this.mBodyLabel != null) {
            this.mBodyLabel.context = this.getContext();
        }
        return this.mBodyLabel;
    }

    public AdAssetFeedSpecAssetLabel getFieldCaptionLabel() {
        if (this.mCaptionLabel != null) {
            this.mCaptionLabel.context = this.getContext();
        }
        return this.mCaptionLabel;
    }

    public AdAssetFeedSpecAssetLabel getFieldDescriptionLabel() {
        if (this.mDescriptionLabel != null) {
            this.mDescriptionLabel.context = this.getContext();
        }
        return this.mDescriptionLabel;
    }

    public AdAssetFeedSpecAssetLabel getFieldImageLabel() {
        if (this.mImageLabel != null) {
            this.mImageLabel.context = this.getContext();
        }
        return this.mImageLabel;
    }

    public AdAssetFeedSpecAssetLabel getFieldLinkUrlLabel() {
        if (this.mLinkUrlLabel != null) {
            this.mLinkUrlLabel.context = this.getContext();
        }
        return this.mLinkUrlLabel;
    }

    public AdAssetFeedSpecAssetLabel getFieldTitleLabel() {
        if (this.mTitleLabel != null) {
            this.mTitleLabel.context = this.getContext();
        }
        return this.mTitleLabel;
    }

    public AdAssetFeedSpecAssetLabel getFieldVideoLabel() {
        if (this.mVideoLabel != null) {
            this.mVideoLabel.context = this.getContext();
        }
        return this.mVideoLabel;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdAssetFeedSpecGroupRule copyFrom(AdAssetFeedSpecGroupRule instance) {
        this.mBodyLabel = instance.mBodyLabel;
        this.mCaptionLabel = instance.mCaptionLabel;
        this.mDescriptionLabel = instance.mDescriptionLabel;
        this.mImageLabel = instance.mImageLabel;
        this.mLinkUrlLabel = instance.mLinkUrlLabel;
        this.mTitleLabel = instance.mTitleLabel;
        this.mVideoLabel = instance.mVideoLabel;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdAssetFeedSpecGroupRule> getParser() {
        return new APIRequest.ResponseParser<AdAssetFeedSpecGroupRule>(){

            @Override
            public APINodeList<AdAssetFeedSpecGroupRule> parseResponse(String response, APIContext context, APIRequest<AdAssetFeedSpecGroupRule> request) throws APIException.MalformedResponseException {
                return AdAssetFeedSpecGroupRule.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdAssetFeedSpecGroupRule> {
        AdAssetFeedSpecGroupRule lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"body_label", "caption_label", "description_label", "image_label", "link_url_label", "title_label", "video_label", "id"};

        @Override
        public AdAssetFeedSpecGroupRule getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdAssetFeedSpecGroupRule parseResponse(String response) throws APIException {
            return AdAssetFeedSpecGroupRule.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdAssetFeedSpecGroupRule execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdAssetFeedSpecGroupRule execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdAssetFeedSpecGroupRule> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdAssetFeedSpecGroupRule> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdAssetFeedSpecGroupRule>(){

                public AdAssetFeedSpecGroupRule apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestBodyLabelField() {
            return this.requestBodyLabelField(true);
        }

        public APIRequestGet requestBodyLabelField(boolean value) {
            this.requestField("body_label", value);
            return this;
        }

        public APIRequestGet requestCaptionLabelField() {
            return this.requestCaptionLabelField(true);
        }

        public APIRequestGet requestCaptionLabelField(boolean value) {
            this.requestField("caption_label", value);
            return this;
        }

        public APIRequestGet requestDescriptionLabelField() {
            return this.requestDescriptionLabelField(true);
        }

        public APIRequestGet requestDescriptionLabelField(boolean value) {
            this.requestField("description_label", value);
            return this;
        }

        public APIRequestGet requestImageLabelField() {
            return this.requestImageLabelField(true);
        }

        public APIRequestGet requestImageLabelField(boolean value) {
            this.requestField("image_label", value);
            return this;
        }

        public APIRequestGet requestLinkUrlLabelField() {
            return this.requestLinkUrlLabelField(true);
        }

        public APIRequestGet requestLinkUrlLabelField(boolean value) {
            this.requestField("link_url_label", value);
            return this;
        }

        public APIRequestGet requestTitleLabelField() {
            return this.requestTitleLabelField(true);
        }

        public APIRequestGet requestTitleLabelField(boolean value) {
            this.requestField("title_label", value);
            return this;
        }

        public APIRequestGet requestVideoLabelField() {
            return this.requestVideoLabelField(true);
        }

        public APIRequestGet requestVideoLabelField(boolean value) {
            this.requestField("video_label", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

