/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdAccountDefaultObjective
extends APINode {
    @SerializedName(value="default_objective_for_user")
    private EnumDefaultObjectiveForUser mDefaultObjectiveForUser = null;
    @SerializedName(value="objective_for_level")
    private EnumObjectiveForLevel mObjectiveForLevel = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    AdAccountDefaultObjective() {
    }

    public AdAccountDefaultObjective(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdAccountDefaultObjective(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdAccountDefaultObjective fetch() throws APIException {
        AdAccountDefaultObjective newInstance = AdAccountDefaultObjective.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdAccountDefaultObjective fetchById(Long id, APIContext context) throws APIException {
        return AdAccountDefaultObjective.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdAccountDefaultObjective> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdAccountDefaultObjective.fetchByIdAsync(id.toString(), context);
    }

    public static AdAccountDefaultObjective fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdAccountDefaultObjective> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdAccountDefaultObjective> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdAccountDefaultObjective>(context, "", "/", "GET", AdAccountDefaultObjective.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdAccountDefaultObjective>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdAccountDefaultObjective>(context, "", "/", "GET", AdAccountDefaultObjective.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdAccountDefaultObjective loadJSON(String json, APIContext context) {
        AdAccountDefaultObjective adAccountDefaultObjective = (AdAccountDefaultObjective)AdAccountDefaultObjective.getGson().fromJson(json, AdAccountDefaultObjective.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adAccountDefaultObjective.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adAccountDefaultObjective.context = context;
        adAccountDefaultObjective.rawValue = json;
        return adAccountDefaultObjective;
    }

    public static APINodeList<AdAccountDefaultObjective> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdAccountDefaultObjective> adAccountDefaultObjectives = new APINodeList<AdAccountDefaultObjective>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adAccountDefaultObjectives.add(AdAccountDefaultObjective.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adAccountDefaultObjectives;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adAccountDefaultObjectives.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adAccountDefaultObjectives.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adAccountDefaultObjectives.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adAccountDefaultObjectives.add(AdAccountDefaultObjective.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adAccountDefaultObjectives.add(AdAccountDefaultObjective.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adAccountDefaultObjectives.add(AdAccountDefaultObjective.loadJSON(obj.toString(), context));
                        }
                    }
                    return adAccountDefaultObjectives;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adAccountDefaultObjectives.add(AdAccountDefaultObjective.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adAccountDefaultObjectives;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adAccountDefaultObjectives.add(AdAccountDefaultObjective.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adAccountDefaultObjectives;
                }
                adAccountDefaultObjectives.clear();
                adAccountDefaultObjectives.add(AdAccountDefaultObjective.loadJSON(json, context));
                return adAccountDefaultObjectives;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdAccountDefaultObjective.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public EnumDefaultObjectiveForUser getFieldDefaultObjectiveForUser() {
        return this.mDefaultObjectiveForUser;
    }

    public EnumObjectiveForLevel getFieldObjectiveForLevel() {
        return this.mObjectiveForLevel;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdAccountDefaultObjective copyFrom(AdAccountDefaultObjective instance) {
        this.mDefaultObjectiveForUser = instance.mDefaultObjectiveForUser;
        this.mObjectiveForLevel = instance.mObjectiveForLevel;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdAccountDefaultObjective> getParser() {
        return new APIRequest.ResponseParser<AdAccountDefaultObjective>(){

            @Override
            public APINodeList<AdAccountDefaultObjective> parseResponse(String response, APIContext context, APIRequest<AdAccountDefaultObjective> request) throws APIException.MalformedResponseException {
                return AdAccountDefaultObjective.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumObjectiveForLevel {
        VALUE_NONE("NONE"),
        VALUE_OFFER_CLAIMS("OFFER_CLAIMS"),
        VALUE_PAGE_LIKES("PAGE_LIKES"),
        VALUE_CANVAS_APP_INSTALLS("CANVAS_APP_INSTALLS"),
        VALUE_EVENT_RESPONSES("EVENT_RESPONSES"),
        VALUE_CANVAS_APP_ENGAGEMENT("CANVAS_APP_ENGAGEMENT"),
        VALUE_POST_ENGAGEMENT("POST_ENGAGEMENT"),
        VALUE_WEBSITE_CONVERSIONS("WEBSITE_CONVERSIONS"),
        VALUE_MOBILE_APP_INSTALLS("MOBILE_APP_INSTALLS"),
        VALUE_LINK_CLICKS("LINK_CLICKS"),
        VALUE_MOBILE_APP_ENGAGEMENT("MOBILE_APP_ENGAGEMENT"),
        VALUE_VIDEO_VIEWS("VIDEO_VIEWS"),
        VALUE_LOCAL_AWARENESS("LOCAL_AWARENESS"),
        VALUE_PRODUCT_CATALOG_SALES("PRODUCT_CATALOG_SALES"),
        VALUE_LEAD_GENERATION("LEAD_GENERATION"),
        VALUE_BRAND_AWARENESS("BRAND_AWARENESS"),
        VALUE_APP_INSTALLS("APP_INSTALLS"),
        VALUE_MESSAGES("MESSAGES"),
        NULL(null);

        private String value;

        private EnumObjectiveForLevel(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumDefaultObjectiveForUser {
        VALUE_NONE("NONE"),
        VALUE_OFFER_CLAIMS("OFFER_CLAIMS"),
        VALUE_PAGE_LIKES("PAGE_LIKES"),
        VALUE_CANVAS_APP_INSTALLS("CANVAS_APP_INSTALLS"),
        VALUE_EVENT_RESPONSES("EVENT_RESPONSES"),
        VALUE_CANVAS_APP_ENGAGEMENT("CANVAS_APP_ENGAGEMENT"),
        VALUE_POST_ENGAGEMENT("POST_ENGAGEMENT"),
        VALUE_WEBSITE_CONVERSIONS("WEBSITE_CONVERSIONS"),
        VALUE_MOBILE_APP_INSTALLS("MOBILE_APP_INSTALLS"),
        VALUE_LINK_CLICKS("LINK_CLICKS"),
        VALUE_MOBILE_APP_ENGAGEMENT("MOBILE_APP_ENGAGEMENT"),
        VALUE_VIDEO_VIEWS("VIDEO_VIEWS"),
        VALUE_LOCAL_AWARENESS("LOCAL_AWARENESS"),
        VALUE_PRODUCT_CATALOG_SALES("PRODUCT_CATALOG_SALES"),
        VALUE_LEAD_GENERATION("LEAD_GENERATION"),
        VALUE_BRAND_AWARENESS("BRAND_AWARENESS"),
        VALUE_APP_INSTALLS("APP_INSTALLS"),
        VALUE_MESSAGES("MESSAGES"),
        NULL(null);

        private String value;

        private EnumDefaultObjectiveForUser(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdAccountDefaultObjective> {
        AdAccountDefaultObjective lastResponse = null;
        public static final String[] PARAMS = new String[]{"adgroup_id", "campaign_group_id", "campaign_id"};
        public static final String[] FIELDS = new String[]{"default_objective_for_user", "objective_for_level", "id"};

        @Override
        public AdAccountDefaultObjective getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdAccountDefaultObjective parseResponse(String response) throws APIException {
            return AdAccountDefaultObjective.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdAccountDefaultObjective execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdAccountDefaultObjective execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdAccountDefaultObjective> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdAccountDefaultObjective> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdAccountDefaultObjective>(){

                public AdAccountDefaultObjective apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet setAdgroupId(String adgroupId) {
            this.setParam("adgroup_id", adgroupId);
            return this;
        }

        public APIRequestGet setCampaignGroupId(String campaignGroupId) {
            this.setParam("campaign_group_id", campaignGroupId);
            return this;
        }

        public APIRequestGet setCampaignId(String campaignId) {
            this.setParam("campaign_id", campaignId);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestDefaultObjectiveForUserField() {
            return this.requestDefaultObjectiveForUserField(true);
        }

        public APIRequestGet requestDefaultObjectiveForUserField(boolean value) {
            this.requestField("default_objective_for_user", value);
            return this;
        }

        public APIRequestGet requestObjectiveForLevelField() {
            return this.requestObjectiveForLevelField(true);
        }

        public APIRequestGet requestObjectiveForLevelField(boolean value) {
            this.requestField("objective_for_level", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

