/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdAccountContextualTargeting
extends APINode {
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="enabled_in_ui")
    private Boolean mEnabledInUi = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="key")
    private String mKey = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="parent")
    private String mParent = null;
    @SerializedName(value="path")
    private List<String> mPath = null;
    @SerializedName(value="type")
    private String mType = null;
    protected static Gson gson = null;

    AdAccountContextualTargeting() {
    }

    public AdAccountContextualTargeting(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdAccountContextualTargeting(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdAccountContextualTargeting fetch() throws APIException {
        AdAccountContextualTargeting newInstance = AdAccountContextualTargeting.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdAccountContextualTargeting fetchById(Long id, APIContext context) throws APIException {
        return AdAccountContextualTargeting.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdAccountContextualTargeting> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdAccountContextualTargeting.fetchByIdAsync(id.toString(), context);
    }

    public static AdAccountContextualTargeting fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdAccountContextualTargeting> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdAccountContextualTargeting> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdAccountContextualTargeting>(context, "", "/", "GET", AdAccountContextualTargeting.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdAccountContextualTargeting>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdAccountContextualTargeting>(context, "", "/", "GET", AdAccountContextualTargeting.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdAccountContextualTargeting loadJSON(String json, APIContext context) {
        AdAccountContextualTargeting adAccountContextualTargeting = (AdAccountContextualTargeting)AdAccountContextualTargeting.getGson().fromJson(json, AdAccountContextualTargeting.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adAccountContextualTargeting.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adAccountContextualTargeting.context = context;
        adAccountContextualTargeting.rawValue = json;
        return adAccountContextualTargeting;
    }

    public static APINodeList<AdAccountContextualTargeting> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdAccountContextualTargeting> adAccountContextualTargetings = new APINodeList<AdAccountContextualTargeting>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adAccountContextualTargetings.add(AdAccountContextualTargeting.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adAccountContextualTargetings;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adAccountContextualTargetings.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adAccountContextualTargetings.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adAccountContextualTargetings.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adAccountContextualTargetings.add(AdAccountContextualTargeting.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adAccountContextualTargetings.add(AdAccountContextualTargeting.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adAccountContextualTargetings.add(AdAccountContextualTargeting.loadJSON(obj.toString(), context));
                        }
                    }
                    return adAccountContextualTargetings;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adAccountContextualTargetings.add(AdAccountContextualTargeting.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adAccountContextualTargetings;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adAccountContextualTargetings.add(AdAccountContextualTargeting.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adAccountContextualTargetings;
                }
                adAccountContextualTargetings.clear();
                adAccountContextualTargetings.add(AdAccountContextualTargeting.loadJSON(json, context));
                return adAccountContextualTargetings;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdAccountContextualTargeting.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public Boolean getFieldEnabledInUi() {
        return this.mEnabledInUi;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldKey() {
        return this.mKey;
    }

    public String getFieldName() {
        return this.mName;
    }

    public String getFieldParent() {
        return this.mParent;
    }

    public List<String> getFieldPath() {
        return this.mPath;
    }

    public String getFieldType() {
        return this.mType;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdAccountContextualTargeting copyFrom(AdAccountContextualTargeting instance) {
        this.mDescription = instance.mDescription;
        this.mEnabledInUi = instance.mEnabledInUi;
        this.mId = instance.mId;
        this.mKey = instance.mKey;
        this.mName = instance.mName;
        this.mParent = instance.mParent;
        this.mPath = instance.mPath;
        this.mType = instance.mType;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdAccountContextualTargeting> getParser() {
        return new APIRequest.ResponseParser<AdAccountContextualTargeting>(){

            @Override
            public APINodeList<AdAccountContextualTargeting> parseResponse(String response, APIContext context, APIRequest<AdAccountContextualTargeting> request) throws APIException.MalformedResponseException {
                return AdAccountContextualTargeting.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdAccountContextualTargeting> {
        AdAccountContextualTargeting lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"description", "enabled_in_ui", "id", "key", "name", "parent", "path", "type"};

        @Override
        public AdAccountContextualTargeting getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdAccountContextualTargeting parseResponse(String response) throws APIException {
            return AdAccountContextualTargeting.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdAccountContextualTargeting execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdAccountContextualTargeting execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdAccountContextualTargeting> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdAccountContextualTargeting> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdAccountContextualTargeting>(){

                public AdAccountContextualTargeting apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestEnabledInUiField() {
            return this.requestEnabledInUiField(true);
        }

        public APIRequestGet requestEnabledInUiField(boolean value) {
            this.requestField("enabled_in_ui", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestKeyField() {
            return this.requestKeyField(true);
        }

        public APIRequestGet requestKeyField(boolean value) {
            this.requestField("key", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestParentField() {
            return this.requestParentField(true);
        }

        public APIRequestGet requestParentField(boolean value) {
            this.requestField("parent", value);
            return this;
        }

        public APIRequestGet requestPathField() {
            return this.requestPathField(true);
        }

        public APIRequestGet requestPathField(boolean value) {
            this.requestField("path", value);
            return this;
        }

        public APIRequestGet requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGet requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }
    }
}

