/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.APIResponse;
import com.facebook.ads.sdk.Page;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublisherSpace
extends APINode {
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="page")
    private Page mPage = null;
    @SerializedName(value="sections")
    private List<Object> mSections = null;
    protected static Gson gson = null;

    PublisherSpace() {
    }

    public PublisherSpace(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public PublisherSpace(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public PublisherSpace fetch() throws APIException {
        PublisherSpace newInstance = PublisherSpace.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static PublisherSpace fetchById(Long id, APIContext context) throws APIException {
        return PublisherSpace.fetchById(id.toString(), context);
    }

    public static ListenableFuture<PublisherSpace> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return PublisherSpace.fetchByIdAsync(id.toString(), context);
    }

    public static PublisherSpace fetchById(String id, APIContext context) throws APIException {
        PublisherSpace publisherSpace = new APIRequestGet(id, context).requestAllFields().execute();
        return publisherSpace;
    }

    public static ListenableFuture<PublisherSpace> fetchByIdAsync(String id, APIContext context) throws APIException {
        ListenableFuture<PublisherSpace> publisherSpace = new APIRequestGet(id, context).requestAllFields().executeAsync();
        return publisherSpace;
    }

    public static APINodeList<PublisherSpace> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<PublisherSpace>(context, "", "/", "GET", PublisherSpace.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<PublisherSpace>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        ListenableFuture<APIResponse> publisherSpace = new APIRequest<PublisherSpace>(context, "", "/", "GET", PublisherSpace.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
        return publisherSpace;
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static PublisherSpace loadJSON(String json, APIContext context) {
        PublisherSpace publisherSpace = (PublisherSpace)PublisherSpace.getGson().fromJson(json, PublisherSpace.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(publisherSpace.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        publisherSpace.context = context;
        publisherSpace.rawValue = json;
        return publisherSpace;
    }

    public static APINodeList<PublisherSpace> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<PublisherSpace> publisherSpaces = new APINodeList<PublisherSpace>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        publisherSpaces.add(PublisherSpace.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return publisherSpaces;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            publisherSpaces.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        publisherSpaces.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            publisherSpaces.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            publisherSpaces.add(PublisherSpace.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                publisherSpaces.add(PublisherSpace.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            publisherSpaces.add(PublisherSpace.loadJSON(obj.toString(), context));
                        }
                    }
                    return publisherSpaces;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        publisherSpaces.add(PublisherSpace.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return publisherSpaces;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        publisherSpaces.add(PublisherSpace.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return publisherSpaces;
                }
                publisherSpaces.clear();
                publisherSpaces.add(PublisherSpace.loadJSON(json, context));
                return publisherSpaces;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return PublisherSpace.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldId() {
        return this.mId;
    }

    public Page getFieldPage() {
        if (this.mPage != null) {
            this.mPage.context = this.getContext();
        }
        return this.mPage;
    }

    public List<Object> getFieldSections() {
        return this.mSections;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public PublisherSpace copyFrom(PublisherSpace instance) {
        this.mId = instance.mId;
        this.mPage = instance.mPage;
        this.mSections = instance.mSections;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<PublisherSpace> getParser() {
        return new APIRequest.ResponseParser<PublisherSpace>(){

            @Override
            public APINodeList<PublisherSpace> parseResponse(String response, APIContext context, APIRequest<PublisherSpace> request) throws APIException.MalformedResponseException {
                return PublisherSpace.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<PublisherSpace> {
        PublisherSpace lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"id", "page", "sections"};

        @Override
        public PublisherSpace getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public PublisherSpace parseResponse(String response) throws APIException {
            return PublisherSpace.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public PublisherSpace execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public PublisherSpace execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<PublisherSpace> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<PublisherSpace> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, PublisherSpace>(){

                public PublisherSpace apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestPageField() {
            return this.requestPageField(true);
        }

        public APIRequestGet requestPageField(boolean value) {
            this.requestField("page", value);
            return this;
        }

        public APIRequestGet requestSectionsField() {
            return this.requestSectionsField(true);
        }

        public APIRequestGet requestSectionsField(boolean value) {
            this.requestField("sections", value);
            return this;
        }
    }
}

