/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductFeedSchedule
extends APINode {
    @SerializedName(value="day_of_month")
    private Long mDayOfMonth = null;
    @SerializedName(value="day_of_week")
    private EnumDayOfWeek mDayOfWeek = null;
    @SerializedName(value="hour")
    private Long mHour = null;
    @SerializedName(value="interval")
    private EnumInterval mInterval = null;
    @SerializedName(value="interval_count")
    private Long mIntervalCount = null;
    @SerializedName(value="minute")
    private Long mMinute = null;
    @SerializedName(value="timezone")
    private String mTimezone = null;
    @SerializedName(value="url")
    private String mUrl = null;
    @SerializedName(value="username")
    private String mUsername = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static ProductFeedSchedule loadJSON(String json, APIContext context) {
        ProductFeedSchedule productFeedSchedule = (ProductFeedSchedule)ProductFeedSchedule.getGson().fromJson(json, ProductFeedSchedule.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(productFeedSchedule.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        productFeedSchedule.context = context;
        productFeedSchedule.rawValue = json;
        return productFeedSchedule;
    }

    public static APINodeList<ProductFeedSchedule> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ProductFeedSchedule> productFeedSchedules = new APINodeList<ProductFeedSchedule>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        productFeedSchedules.add(ProductFeedSchedule.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return productFeedSchedules;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            productFeedSchedules.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        productFeedSchedules.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            productFeedSchedules.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            productFeedSchedules.add(ProductFeedSchedule.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                productFeedSchedules.add(ProductFeedSchedule.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            productFeedSchedules.add(ProductFeedSchedule.loadJSON(obj.toString(), context));
                        }
                    }
                    return productFeedSchedules;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        productFeedSchedules.add(ProductFeedSchedule.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return productFeedSchedules;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        productFeedSchedules.add(ProductFeedSchedule.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return productFeedSchedules;
                }
                productFeedSchedules.clear();
                productFeedSchedules.add(ProductFeedSchedule.loadJSON(json, context));
                return productFeedSchedules;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ProductFeedSchedule.getGson().toJson((Object)this);
    }

    public Long getFieldDayOfMonth() {
        return this.mDayOfMonth;
    }

    public ProductFeedSchedule setFieldDayOfMonth(Long value) {
        this.mDayOfMonth = value;
        return this;
    }

    public EnumDayOfWeek getFieldDayOfWeek() {
        return this.mDayOfWeek;
    }

    public ProductFeedSchedule setFieldDayOfWeek(EnumDayOfWeek value) {
        this.mDayOfWeek = value;
        return this;
    }

    public Long getFieldHour() {
        return this.mHour;
    }

    public ProductFeedSchedule setFieldHour(Long value) {
        this.mHour = value;
        return this;
    }

    public EnumInterval getFieldInterval() {
        return this.mInterval;
    }

    public ProductFeedSchedule setFieldInterval(EnumInterval value) {
        this.mInterval = value;
        return this;
    }

    public Long getFieldIntervalCount() {
        return this.mIntervalCount;
    }

    public ProductFeedSchedule setFieldIntervalCount(Long value) {
        this.mIntervalCount = value;
        return this;
    }

    public Long getFieldMinute() {
        return this.mMinute;
    }

    public ProductFeedSchedule setFieldMinute(Long value) {
        this.mMinute = value;
        return this;
    }

    public String getFieldTimezone() {
        return this.mTimezone;
    }

    public ProductFeedSchedule setFieldTimezone(String value) {
        this.mTimezone = value;
        return this;
    }

    public String getFieldUrl() {
        return this.mUrl;
    }

    public ProductFeedSchedule setFieldUrl(String value) {
        this.mUrl = value;
        return this;
    }

    public String getFieldUsername() {
        return this.mUsername;
    }

    public ProductFeedSchedule setFieldUsername(String value) {
        this.mUsername = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ProductFeedSchedule copyFrom(ProductFeedSchedule instance) {
        this.mDayOfMonth = instance.mDayOfMonth;
        this.mDayOfWeek = instance.mDayOfWeek;
        this.mHour = instance.mHour;
        this.mInterval = instance.mInterval;
        this.mIntervalCount = instance.mIntervalCount;
        this.mMinute = instance.mMinute;
        this.mTimezone = instance.mTimezone;
        this.mUrl = instance.mUrl;
        this.mUsername = instance.mUsername;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ProductFeedSchedule> getParser() {
        return new APIRequest.ResponseParser<ProductFeedSchedule>(){

            @Override
            public APINodeList<ProductFeedSchedule> parseResponse(String response, APIContext context, APIRequest<ProductFeedSchedule> request) throws APIException.MalformedResponseException {
                return ProductFeedSchedule.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumInterval {
        VALUE_HOURLY("HOURLY"),
        VALUE_DAILY("DAILY"),
        VALUE_WEEKLY("WEEKLY"),
        VALUE_MONTHLY("MONTHLY"),
        NULL(null);

        private String value;

        private EnumInterval(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumDayOfWeek {
        VALUE_SUNDAY("SUNDAY"),
        VALUE_MONDAY("MONDAY"),
        VALUE_TUESDAY("TUESDAY"),
        VALUE_WEDNESDAY("WEDNESDAY"),
        VALUE_THURSDAY("THURSDAY"),
        VALUE_FRIDAY("FRIDAY"),
        VALUE_SATURDAY("SATURDAY"),
        NULL(null);

        private String value;

        private EnumDayOfWeek(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

