/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.ExternalEventSource;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductEventStat
extends APINode {
    @SerializedName(value="date_start")
    private String mDateStart = null;
    @SerializedName(value="date_stop")
    private String mDateStop = null;
    @SerializedName(value="device_type")
    private EnumDeviceType mDeviceType = null;
    @SerializedName(value="event")
    private EnumEvent mEvent = null;
    @SerializedName(value="event_source")
    private ExternalEventSource mEventSource = null;
    @SerializedName(value="total_content_ids_matched_other_catalogs")
    private Long mTotalContentIdsMatchedOtherCatalogs = null;
    @SerializedName(value="total_matched_content_ids")
    private Long mTotalMatchedContentIds = null;
    @SerializedName(value="total_unmatched_content_ids")
    private Long mTotalUnmatchedContentIds = null;
    @SerializedName(value="unique_content_ids_matched_other_catalogs")
    private Long mUniqueContentIdsMatchedOtherCatalogs = null;
    @SerializedName(value="unique_matched_content_ids")
    private Long mUniqueMatchedContentIds = null;
    @SerializedName(value="unique_unmatched_content_ids")
    private Long mUniqueUnmatchedContentIds = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static ProductEventStat loadJSON(String json, APIContext context) {
        ProductEventStat productEventStat = (ProductEventStat)ProductEventStat.getGson().fromJson(json, ProductEventStat.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(productEventStat.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        productEventStat.context = context;
        productEventStat.rawValue = json;
        return productEventStat;
    }

    public static APINodeList<ProductEventStat> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ProductEventStat> productEventStats = new APINodeList<ProductEventStat>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        productEventStats.add(ProductEventStat.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return productEventStats;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            productEventStats.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        productEventStats.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            productEventStats.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            productEventStats.add(ProductEventStat.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                productEventStats.add(ProductEventStat.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            productEventStats.add(ProductEventStat.loadJSON(obj.toString(), context));
                        }
                    }
                    return productEventStats;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        productEventStats.add(ProductEventStat.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return productEventStats;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        productEventStats.add(ProductEventStat.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return productEventStats;
                }
                productEventStats.clear();
                productEventStats.add(ProductEventStat.loadJSON(json, context));
                return productEventStats;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ProductEventStat.getGson().toJson((Object)this);
    }

    public String getFieldDateStart() {
        return this.mDateStart;
    }

    public ProductEventStat setFieldDateStart(String value) {
        this.mDateStart = value;
        return this;
    }

    public String getFieldDateStop() {
        return this.mDateStop;
    }

    public ProductEventStat setFieldDateStop(String value) {
        this.mDateStop = value;
        return this;
    }

    public EnumDeviceType getFieldDeviceType() {
        return this.mDeviceType;
    }

    public ProductEventStat setFieldDeviceType(EnumDeviceType value) {
        this.mDeviceType = value;
        return this;
    }

    public EnumEvent getFieldEvent() {
        return this.mEvent;
    }

    public ProductEventStat setFieldEvent(EnumEvent value) {
        this.mEvent = value;
        return this;
    }

    public ExternalEventSource getFieldEventSource() {
        if (this.mEventSource != null) {
            this.mEventSource.context = this.getContext();
        }
        return this.mEventSource;
    }

    public ProductEventStat setFieldEventSource(ExternalEventSource value) {
        this.mEventSource = value;
        return this;
    }

    public ProductEventStat setFieldEventSource(String value) {
        Type type = new TypeToken<ExternalEventSource>(){}.getType();
        this.mEventSource = (ExternalEventSource)ExternalEventSource.getGson().fromJson(value, type);
        return this;
    }

    public Long getFieldTotalContentIdsMatchedOtherCatalogs() {
        return this.mTotalContentIdsMatchedOtherCatalogs;
    }

    public ProductEventStat setFieldTotalContentIdsMatchedOtherCatalogs(Long value) {
        this.mTotalContentIdsMatchedOtherCatalogs = value;
        return this;
    }

    public Long getFieldTotalMatchedContentIds() {
        return this.mTotalMatchedContentIds;
    }

    public ProductEventStat setFieldTotalMatchedContentIds(Long value) {
        this.mTotalMatchedContentIds = value;
        return this;
    }

    public Long getFieldTotalUnmatchedContentIds() {
        return this.mTotalUnmatchedContentIds;
    }

    public ProductEventStat setFieldTotalUnmatchedContentIds(Long value) {
        this.mTotalUnmatchedContentIds = value;
        return this;
    }

    public Long getFieldUniqueContentIdsMatchedOtherCatalogs() {
        return this.mUniqueContentIdsMatchedOtherCatalogs;
    }

    public ProductEventStat setFieldUniqueContentIdsMatchedOtherCatalogs(Long value) {
        this.mUniqueContentIdsMatchedOtherCatalogs = value;
        return this;
    }

    public Long getFieldUniqueMatchedContentIds() {
        return this.mUniqueMatchedContentIds;
    }

    public ProductEventStat setFieldUniqueMatchedContentIds(Long value) {
        this.mUniqueMatchedContentIds = value;
        return this;
    }

    public Long getFieldUniqueUnmatchedContentIds() {
        return this.mUniqueUnmatchedContentIds;
    }

    public ProductEventStat setFieldUniqueUnmatchedContentIds(Long value) {
        this.mUniqueUnmatchedContentIds = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ProductEventStat copyFrom(ProductEventStat instance) {
        this.mDateStart = instance.mDateStart;
        this.mDateStop = instance.mDateStop;
        this.mDeviceType = instance.mDeviceType;
        this.mEvent = instance.mEvent;
        this.mEventSource = instance.mEventSource;
        this.mTotalContentIdsMatchedOtherCatalogs = instance.mTotalContentIdsMatchedOtherCatalogs;
        this.mTotalMatchedContentIds = instance.mTotalMatchedContentIds;
        this.mTotalUnmatchedContentIds = instance.mTotalUnmatchedContentIds;
        this.mUniqueContentIdsMatchedOtherCatalogs = instance.mUniqueContentIdsMatchedOtherCatalogs;
        this.mUniqueMatchedContentIds = instance.mUniqueMatchedContentIds;
        this.mUniqueUnmatchedContentIds = instance.mUniqueUnmatchedContentIds;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ProductEventStat> getParser() {
        return new APIRequest.ResponseParser<ProductEventStat>(){

            @Override
            public APINodeList<ProductEventStat> parseResponse(String response, APIContext context, APIRequest<ProductEventStat> request) throws APIException.MalformedResponseException {
                return ProductEventStat.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumBreakdowns {
        VALUE_DEVICE_TYPE("DEVICE_TYPE"),
        NULL(null);

        private String value;

        private EnumBreakdowns(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumEvent {
        VALUE_VIEWCONTENT("ViewContent"),
        VALUE_ADDTOCART("AddToCart"),
        VALUE_PURCHASE("Purchase"),
        VALUE_INITIATECHECKOUT("InitiateCheckout"),
        VALUE_SEARCH("Search"),
        VALUE_LEAD("Lead"),
        VALUE_ADDTOWISHLIST("AddToWishlist"),
        NULL(null);

        private String value;

        private EnumEvent(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumDeviceType {
        VALUE_DESKTOP("desktop"),
        VALUE_MOBILE_ANDROID_PHONE("mobile_android_phone"),
        VALUE_MOBILE_ANDROID_TABLET("mobile_android_tablet"),
        VALUE_MOBILE_IPAD("mobile_ipad"),
        VALUE_MOBILE_IPHONE("mobile_iphone"),
        VALUE_MOBILE_IPOD("mobile_ipod"),
        VALUE_MOBILE_PHONE("mobile_phone"),
        VALUE_MOBILE_TABLET("mobile_tablet"),
        VALUE_MOBILE_WINDOWS_PHONE("mobile_windows_phone"),
        VALUE_UNKNOWN("unknown"),
        NULL(null);

        private String value;

        private EnumDeviceType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

