/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Location
extends APINode {
    @SerializedName(value="city")
    private String mCity = null;
    @SerializedName(value="city_id")
    private Long mCityId = null;
    @SerializedName(value="country")
    private String mCountry = null;
    @SerializedName(value="country_code")
    private String mCountryCode = null;
    @SerializedName(value="latitude")
    private Double mLatitude = null;
    @SerializedName(value="located_in")
    private String mLocatedIn = null;
    @SerializedName(value="longitude")
    private Double mLongitude = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="region")
    private String mRegion = null;
    @SerializedName(value="region_id")
    private Long mRegionId = null;
    @SerializedName(value="state")
    private String mState = null;
    @SerializedName(value="street")
    private String mStreet = null;
    @SerializedName(value="zip")
    private String mZip = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static Location loadJSON(String json, APIContext context) {
        Location location = (Location)Location.getGson().fromJson(json, Location.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(location.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        location.context = context;
        location.rawValue = json;
        return location;
    }

    public static APINodeList<Location> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<Location> locations = new APINodeList<Location>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        locations.add(Location.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return locations;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            locations.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        locations.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            locations.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            locations.add(Location.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                locations.add(Location.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            locations.add(Location.loadJSON(obj.toString(), context));
                        }
                    }
                    return locations;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        locations.add(Location.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return locations;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        locations.add(Location.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return locations;
                }
                locations.clear();
                locations.add(Location.loadJSON(json, context));
                return locations;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return Location.getGson().toJson((Object)this);
    }

    public String getFieldCity() {
        return this.mCity;
    }

    public Location setFieldCity(String value) {
        this.mCity = value;
        return this;
    }

    public Long getFieldCityId() {
        return this.mCityId;
    }

    public Location setFieldCityId(Long value) {
        this.mCityId = value;
        return this;
    }

    public String getFieldCountry() {
        return this.mCountry;
    }

    public Location setFieldCountry(String value) {
        this.mCountry = value;
        return this;
    }

    public String getFieldCountryCode() {
        return this.mCountryCode;
    }

    public Location setFieldCountryCode(String value) {
        this.mCountryCode = value;
        return this;
    }

    public Double getFieldLatitude() {
        return this.mLatitude;
    }

    public Location setFieldLatitude(Double value) {
        this.mLatitude = value;
        return this;
    }

    public String getFieldLocatedIn() {
        return this.mLocatedIn;
    }

    public Location setFieldLocatedIn(String value) {
        this.mLocatedIn = value;
        return this;
    }

    public Double getFieldLongitude() {
        return this.mLongitude;
    }

    public Location setFieldLongitude(Double value) {
        this.mLongitude = value;
        return this;
    }

    public String getFieldName() {
        return this.mName;
    }

    public Location setFieldName(String value) {
        this.mName = value;
        return this;
    }

    public String getFieldRegion() {
        return this.mRegion;
    }

    public Location setFieldRegion(String value) {
        this.mRegion = value;
        return this;
    }

    public Long getFieldRegionId() {
        return this.mRegionId;
    }

    public Location setFieldRegionId(Long value) {
        this.mRegionId = value;
        return this;
    }

    public String getFieldState() {
        return this.mState;
    }

    public Location setFieldState(String value) {
        this.mState = value;
        return this;
    }

    public String getFieldStreet() {
        return this.mStreet;
    }

    public Location setFieldStreet(String value) {
        this.mStreet = value;
        return this;
    }

    public String getFieldZip() {
        return this.mZip;
    }

    public Location setFieldZip(String value) {
        this.mZip = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public Location copyFrom(Location instance) {
        this.mCity = instance.mCity;
        this.mCityId = instance.mCityId;
        this.mCountry = instance.mCountry;
        this.mCountryCode = instance.mCountryCode;
        this.mLatitude = instance.mLatitude;
        this.mLocatedIn = instance.mLocatedIn;
        this.mLongitude = instance.mLongitude;
        this.mName = instance.mName;
        this.mRegion = instance.mRegion;
        this.mRegionId = instance.mRegionId;
        this.mState = instance.mState;
        this.mStreet = instance.mStreet;
        this.mZip = instance.mZip;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<Location> getParser() {
        return new APIRequest.ResponseParser<Location>(){

            @Override
            public APINodeList<Location> parseResponse(String response, APIContext context, APIRequest<Location> request) throws APIException.MalformedResponseException {
                return Location.parseResponse(response, context, request);
            }
        };
    }
}

