/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.APIResponse;
import com.facebook.ads.sdk.AdSet;
import com.facebook.ads.sdk.Targeting;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectDeal
extends APINode {
    @SerializedName(value="adbreaks_enabled")
    private Boolean mAdbreaksEnabled = null;
    @SerializedName(value="adset")
    private AdSet mAdset = null;
    @SerializedName(value="advertiser")
    private Object mAdvertiser = null;
    @SerializedName(value="advertiser_lead_email")
    private String mAdvertiserLeadEmail = null;
    @SerializedName(value="advertiser_page")
    private String mAdvertiserPage = null;
    @SerializedName(value="cpe_amount")
    private Long mCpeAmount = null;
    @SerializedName(value="cpe_currency")
    private String mCpeCurrency = null;
    @SerializedName(value="end_time")
    private Long mEndTime = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="lifetime_budget_amount")
    private Long mLifetimeBudgetAmount = null;
    @SerializedName(value="lifetime_budget_currency")
    private String mLifetimeBudgetCurrency = null;
    @SerializedName(value="lifetime_impressions")
    private Long mLifetimeImpressions = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="pages")
    private List<String> mPages = null;
    @SerializedName(value="placements")
    private List<String> mPlacements = null;
    @SerializedName(value="priced_by")
    private String mPricedBy = null;
    @SerializedName(value="publisher_name")
    private String mPublisherName = null;
    @SerializedName(value="review_requirement")
    private String mReviewRequirement = null;
    @SerializedName(value="sales_lead_email")
    private String mSalesLeadEmail = null;
    @SerializedName(value="start_time")
    private Long mStartTime = null;
    @SerializedName(value="status")
    private String mStatus = null;
    @SerializedName(value="targeting")
    private Targeting mTargeting = null;
    protected static Gson gson = null;

    DirectDeal() {
    }

    public DirectDeal(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public DirectDeal(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public DirectDeal fetch() throws APIException {
        DirectDeal newInstance = DirectDeal.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static DirectDeal fetchById(Long id, APIContext context) throws APIException {
        return DirectDeal.fetchById(id.toString(), context);
    }

    public static ListenableFuture<DirectDeal> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return DirectDeal.fetchByIdAsync(id.toString(), context);
    }

    public static DirectDeal fetchById(String id, APIContext context) throws APIException {
        DirectDeal directDeal = new APIRequestGet(id, context).requestAllFields().execute();
        return directDeal;
    }

    public static ListenableFuture<DirectDeal> fetchByIdAsync(String id, APIContext context) throws APIException {
        ListenableFuture<DirectDeal> directDeal = new APIRequestGet(id, context).requestAllFields().executeAsync();
        return directDeal;
    }

    public static APINodeList<DirectDeal> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<DirectDeal>(context, "", "/", "GET", DirectDeal.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<DirectDeal>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        ListenableFuture<APIResponse> directDeal = new APIRequest<DirectDeal>(context, "", "/", "GET", DirectDeal.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
        return directDeal;
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static DirectDeal loadJSON(String json, APIContext context) {
        DirectDeal directDeal = (DirectDeal)DirectDeal.getGson().fromJson(json, DirectDeal.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(directDeal.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        directDeal.context = context;
        directDeal.rawValue = json;
        return directDeal;
    }

    public static APINodeList<DirectDeal> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<DirectDeal> directDeals = new APINodeList<DirectDeal>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        directDeals.add(DirectDeal.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return directDeals;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            directDeals.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        directDeals.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            directDeals.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            directDeals.add(DirectDeal.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                directDeals.add(DirectDeal.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            directDeals.add(DirectDeal.loadJSON(obj.toString(), context));
                        }
                    }
                    return directDeals;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        directDeals.add(DirectDeal.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return directDeals;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        directDeals.add(DirectDeal.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return directDeals;
                }
                directDeals.clear();
                directDeals.add(DirectDeal.loadJSON(json, context));
                return directDeals;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return DirectDeal.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Boolean getFieldAdbreaksEnabled() {
        return this.mAdbreaksEnabled;
    }

    public AdSet getFieldAdset() {
        if (this.mAdset != null) {
            this.mAdset.context = this.getContext();
        }
        return this.mAdset;
    }

    public Object getFieldAdvertiser() {
        return this.mAdvertiser;
    }

    public String getFieldAdvertiserLeadEmail() {
        return this.mAdvertiserLeadEmail;
    }

    public String getFieldAdvertiserPage() {
        return this.mAdvertiserPage;
    }

    public Long getFieldCpeAmount() {
        return this.mCpeAmount;
    }

    public String getFieldCpeCurrency() {
        return this.mCpeCurrency;
    }

    public Long getFieldEndTime() {
        return this.mEndTime;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Long getFieldLifetimeBudgetAmount() {
        return this.mLifetimeBudgetAmount;
    }

    public String getFieldLifetimeBudgetCurrency() {
        return this.mLifetimeBudgetCurrency;
    }

    public Long getFieldLifetimeImpressions() {
        return this.mLifetimeImpressions;
    }

    public String getFieldName() {
        return this.mName;
    }

    public List<String> getFieldPages() {
        return this.mPages;
    }

    public List<String> getFieldPlacements() {
        return this.mPlacements;
    }

    public String getFieldPricedBy() {
        return this.mPricedBy;
    }

    public String getFieldPublisherName() {
        return this.mPublisherName;
    }

    public String getFieldReviewRequirement() {
        return this.mReviewRequirement;
    }

    public String getFieldSalesLeadEmail() {
        return this.mSalesLeadEmail;
    }

    public Long getFieldStartTime() {
        return this.mStartTime;
    }

    public String getFieldStatus() {
        return this.mStatus;
    }

    public Targeting getFieldTargeting() {
        return this.mTargeting;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public DirectDeal copyFrom(DirectDeal instance) {
        this.mAdbreaksEnabled = instance.mAdbreaksEnabled;
        this.mAdset = instance.mAdset;
        this.mAdvertiser = instance.mAdvertiser;
        this.mAdvertiserLeadEmail = instance.mAdvertiserLeadEmail;
        this.mAdvertiserPage = instance.mAdvertiserPage;
        this.mCpeAmount = instance.mCpeAmount;
        this.mCpeCurrency = instance.mCpeCurrency;
        this.mEndTime = instance.mEndTime;
        this.mId = instance.mId;
        this.mLifetimeBudgetAmount = instance.mLifetimeBudgetAmount;
        this.mLifetimeBudgetCurrency = instance.mLifetimeBudgetCurrency;
        this.mLifetimeImpressions = instance.mLifetimeImpressions;
        this.mName = instance.mName;
        this.mPages = instance.mPages;
        this.mPlacements = instance.mPlacements;
        this.mPricedBy = instance.mPricedBy;
        this.mPublisherName = instance.mPublisherName;
        this.mReviewRequirement = instance.mReviewRequirement;
        this.mSalesLeadEmail = instance.mSalesLeadEmail;
        this.mStartTime = instance.mStartTime;
        this.mStatus = instance.mStatus;
        this.mTargeting = instance.mTargeting;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<DirectDeal> getParser() {
        return new APIRequest.ResponseParser<DirectDeal>(){

            @Override
            public APINodeList<DirectDeal> parseResponse(String response, APIContext context, APIRequest<DirectDeal> request) throws APIException.MalformedResponseException {
                return DirectDeal.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumStatus {
        VALUE_0("0"),
        VALUE_1("1"),
        VALUE_2("2"),
        VALUE_3("3"),
        VALUE_4("4"),
        VALUE_5("5"),
        VALUE_6("6"),
        NULL(null);

        private String value;

        private EnumStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<DirectDeal> {
        DirectDeal lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"adbreaks_enabled", "adset", "advertiser", "advertiser_lead_email", "advertiser_page", "cpe_amount", "cpe_currency", "end_time", "id", "lifetime_budget_amount", "lifetime_budget_currency", "lifetime_impressions", "name", "pages", "placements", "priced_by", "publisher_name", "review_requirement", "sales_lead_email", "start_time", "status", "targeting"};

        @Override
        public DirectDeal getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public DirectDeal parseResponse(String response) throws APIException {
            return DirectDeal.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public DirectDeal execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public DirectDeal execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<DirectDeal> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<DirectDeal> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, DirectDeal>(){

                public DirectDeal apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAdbreaksEnabledField() {
            return this.requestAdbreaksEnabledField(true);
        }

        public APIRequestGet requestAdbreaksEnabledField(boolean value) {
            this.requestField("adbreaks_enabled", value);
            return this;
        }

        public APIRequestGet requestAdsetField() {
            return this.requestAdsetField(true);
        }

        public APIRequestGet requestAdsetField(boolean value) {
            this.requestField("adset", value);
            return this;
        }

        public APIRequestGet requestAdvertiserField() {
            return this.requestAdvertiserField(true);
        }

        public APIRequestGet requestAdvertiserField(boolean value) {
            this.requestField("advertiser", value);
            return this;
        }

        public APIRequestGet requestAdvertiserLeadEmailField() {
            return this.requestAdvertiserLeadEmailField(true);
        }

        public APIRequestGet requestAdvertiserLeadEmailField(boolean value) {
            this.requestField("advertiser_lead_email", value);
            return this;
        }

        public APIRequestGet requestAdvertiserPageField() {
            return this.requestAdvertiserPageField(true);
        }

        public APIRequestGet requestAdvertiserPageField(boolean value) {
            this.requestField("advertiser_page", value);
            return this;
        }

        public APIRequestGet requestCpeAmountField() {
            return this.requestCpeAmountField(true);
        }

        public APIRequestGet requestCpeAmountField(boolean value) {
            this.requestField("cpe_amount", value);
            return this;
        }

        public APIRequestGet requestCpeCurrencyField() {
            return this.requestCpeCurrencyField(true);
        }

        public APIRequestGet requestCpeCurrencyField(boolean value) {
            this.requestField("cpe_currency", value);
            return this;
        }

        public APIRequestGet requestEndTimeField() {
            return this.requestEndTimeField(true);
        }

        public APIRequestGet requestEndTimeField(boolean value) {
            this.requestField("end_time", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestLifetimeBudgetAmountField() {
            return this.requestLifetimeBudgetAmountField(true);
        }

        public APIRequestGet requestLifetimeBudgetAmountField(boolean value) {
            this.requestField("lifetime_budget_amount", value);
            return this;
        }

        public APIRequestGet requestLifetimeBudgetCurrencyField() {
            return this.requestLifetimeBudgetCurrencyField(true);
        }

        public APIRequestGet requestLifetimeBudgetCurrencyField(boolean value) {
            this.requestField("lifetime_budget_currency", value);
            return this;
        }

        public APIRequestGet requestLifetimeImpressionsField() {
            return this.requestLifetimeImpressionsField(true);
        }

        public APIRequestGet requestLifetimeImpressionsField(boolean value) {
            this.requestField("lifetime_impressions", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestPagesField() {
            return this.requestPagesField(true);
        }

        public APIRequestGet requestPagesField(boolean value) {
            this.requestField("pages", value);
            return this;
        }

        public APIRequestGet requestPlacementsField() {
            return this.requestPlacementsField(true);
        }

        public APIRequestGet requestPlacementsField(boolean value) {
            this.requestField("placements", value);
            return this;
        }

        public APIRequestGet requestPricedByField() {
            return this.requestPricedByField(true);
        }

        public APIRequestGet requestPricedByField(boolean value) {
            this.requestField("priced_by", value);
            return this;
        }

        public APIRequestGet requestPublisherNameField() {
            return this.requestPublisherNameField(true);
        }

        public APIRequestGet requestPublisherNameField(boolean value) {
            this.requestField("publisher_name", value);
            return this;
        }

        public APIRequestGet requestReviewRequirementField() {
            return this.requestReviewRequirementField(true);
        }

        public APIRequestGet requestReviewRequirementField(boolean value) {
            this.requestField("review_requirement", value);
            return this;
        }

        public APIRequestGet requestSalesLeadEmailField() {
            return this.requestSalesLeadEmailField(true);
        }

        public APIRequestGet requestSalesLeadEmailField(boolean value) {
            this.requestField("sales_lead_email", value);
            return this;
        }

        public APIRequestGet requestStartTimeField() {
            return this.requestStartTimeField(true);
        }

        public APIRequestGet requestStartTimeField(boolean value) {
            this.requestField("start_time", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGet requestTargetingField() {
            return this.requestTargetingField(true);
        }

        public APIRequestGet requestTargetingField(boolean value) {
            this.requestField("targeting", value);
            return this;
        }
    }
}

