/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdgroupPlacementSpecificReviewFeedback;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdgroupReviewFeedback
extends APINode {
    @SerializedName(value="global")
    private Map<String, String> mGlobal = null;
    @SerializedName(value="placement_specific")
    private AdgroupPlacementSpecificReviewFeedback mPlacementSpecific = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static AdgroupReviewFeedback loadJSON(String json, APIContext context) {
        AdgroupReviewFeedback adgroupReviewFeedback = (AdgroupReviewFeedback)AdgroupReviewFeedback.getGson().fromJson(json, AdgroupReviewFeedback.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adgroupReviewFeedback.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adgroupReviewFeedback.context = context;
        adgroupReviewFeedback.rawValue = json;
        return adgroupReviewFeedback;
    }

    public static APINodeList<AdgroupReviewFeedback> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdgroupReviewFeedback> adgroupReviewFeedbacks = new APINodeList<AdgroupReviewFeedback>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adgroupReviewFeedbacks.add(AdgroupReviewFeedback.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adgroupReviewFeedbacks;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adgroupReviewFeedbacks.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adgroupReviewFeedbacks.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adgroupReviewFeedbacks.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adgroupReviewFeedbacks.add(AdgroupReviewFeedback.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adgroupReviewFeedbacks.add(AdgroupReviewFeedback.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adgroupReviewFeedbacks.add(AdgroupReviewFeedback.loadJSON(obj.toString(), context));
                        }
                    }
                    return adgroupReviewFeedbacks;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adgroupReviewFeedbacks.add(AdgroupReviewFeedback.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adgroupReviewFeedbacks;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adgroupReviewFeedbacks.add(AdgroupReviewFeedback.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adgroupReviewFeedbacks;
                }
                adgroupReviewFeedbacks.clear();
                adgroupReviewFeedbacks.add(AdgroupReviewFeedback.loadJSON(json, context));
                return adgroupReviewFeedbacks;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdgroupReviewFeedback.getGson().toJson((Object)this);
    }

    public Map<String, String> getFieldGlobal() {
        return this.mGlobal;
    }

    public AdgroupReviewFeedback setFieldGlobal(Map<String, String> value) {
        this.mGlobal = value;
        return this;
    }

    public AdgroupPlacementSpecificReviewFeedback getFieldPlacementSpecific() {
        return this.mPlacementSpecific;
    }

    public AdgroupReviewFeedback setFieldPlacementSpecific(AdgroupPlacementSpecificReviewFeedback value) {
        this.mPlacementSpecific = value;
        return this;
    }

    public AdgroupReviewFeedback setFieldPlacementSpecific(String value) {
        Type type = new TypeToken<AdgroupPlacementSpecificReviewFeedback>(){}.getType();
        this.mPlacementSpecific = (AdgroupPlacementSpecificReviewFeedback)AdgroupPlacementSpecificReviewFeedback.getGson().fromJson(value, type);
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdgroupReviewFeedback copyFrom(AdgroupReviewFeedback instance) {
        this.mGlobal = instance.mGlobal;
        this.mPlacementSpecific = instance.mPlacementSpecific;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdgroupReviewFeedback> getParser() {
        return new APIRequest.ResponseParser<AdgroupReviewFeedback>(){

            @Override
            public APINodeList<AdgroupReviewFeedback> parseResponse(String response, APIContext context, APIRequest<AdgroupReviewFeedback> request) throws APIException.MalformedResponseException {
                return AdgroupReviewFeedback.parseResponse(response, context, request);
            }
        };
    }
}

