/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.APIResponse;
import com.facebook.ads.sdk.ProductCatalog;
import com.facebook.ads.sdk.ProductItem;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductSet
extends APINode {
    @SerializedName(value="auto_creation_url")
    private String mAutoCreationUrl = null;
    @SerializedName(value="filter")
    private String mFilter = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="product_catalog")
    private ProductCatalog mProductCatalog = null;
    @SerializedName(value="product_count")
    private Long mProductCount = null;
    protected static Gson gson = null;

    ProductSet() {
    }

    public ProductSet(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public ProductSet(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public ProductSet fetch() throws APIException {
        ProductSet newInstance = ProductSet.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static ProductSet fetchById(Long id, APIContext context) throws APIException {
        return ProductSet.fetchById(id.toString(), context);
    }

    public static ListenableFuture<ProductSet> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return ProductSet.fetchByIdAsync(id.toString(), context);
    }

    public static ProductSet fetchById(String id, APIContext context) throws APIException {
        ProductSet productSet = new APIRequestGet(id, context).requestAllFields().execute();
        return productSet;
    }

    public static ListenableFuture<ProductSet> fetchByIdAsync(String id, APIContext context) throws APIException {
        ListenableFuture<ProductSet> productSet = new APIRequestGet(id, context).requestAllFields().executeAsync();
        return productSet;
    }

    public static APINodeList<ProductSet> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<ProductSet>(context, "", "/", "GET", ProductSet.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<ProductSet>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        ListenableFuture<APIResponse> productSet = new APIRequest<ProductSet>(context, "", "/", "GET", ProductSet.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
        return productSet;
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static ProductSet loadJSON(String json, APIContext context) {
        ProductSet productSet = (ProductSet)ProductSet.getGson().fromJson(json, ProductSet.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(productSet.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        productSet.context = context;
        productSet.rawValue = json;
        return productSet;
    }

    public static APINodeList<ProductSet> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ProductSet> productSets = new APINodeList<ProductSet>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        productSets.add(ProductSet.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return productSets;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            productSets.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        productSets.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            productSets.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            productSets.add(ProductSet.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                productSets.add(ProductSet.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            productSets.add(ProductSet.loadJSON(obj.toString(), context));
                        }
                    }
                    return productSets;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        productSets.add(ProductSet.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return productSets;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        productSets.add(ProductSet.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return productSets;
                }
                productSets.clear();
                productSets.add(ProductSet.loadJSON(json, context));
                return productSets;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ProductSet.getGson().toJson((Object)this);
    }

    public APIRequestGetProducts getProducts() {
        return new APIRequestGetProducts(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetVehicles getVehicles() {
        return new APIRequestGetVehicles(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDelete delete() {
        return new APIRequestDelete(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAutoCreationUrl() {
        return this.mAutoCreationUrl;
    }

    public String getFieldFilter() {
        return this.mFilter;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldName() {
        return this.mName;
    }

    public ProductCatalog getFieldProductCatalog() {
        if (this.mProductCatalog != null) {
            this.mProductCatalog.context = this.getContext();
        }
        return this.mProductCatalog;
    }

    public Long getFieldProductCount() {
        return this.mProductCount;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ProductSet copyFrom(ProductSet instance) {
        this.mAutoCreationUrl = instance.mAutoCreationUrl;
        this.mFilter = instance.mFilter;
        this.mId = instance.mId;
        this.mName = instance.mName;
        this.mProductCatalog = instance.mProductCatalog;
        this.mProductCount = instance.mProductCount;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ProductSet> getParser() {
        return new APIRequest.ResponseParser<ProductSet>(){

            @Override
            public APINodeList<ProductSet> parseResponse(String response, APIContext context, APIRequest<ProductSet> request) throws APIException.MalformedResponseException {
                return ProductSet.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestUpdate
    extends APIRequest<ProductSet> {
        ProductSet lastResponse = null;
        public static final String[] PARAMS = new String[]{"filter", "name"};
        public static final String[] FIELDS = new String[0];

        @Override
        public ProductSet getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ProductSet parseResponse(String response) throws APIException {
            return ProductSet.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public ProductSet execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ProductSet execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<ProductSet> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ProductSet> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, ProductSet>(){

                public ProductSet apply(String result) {
                    try {
                        return APIRequestUpdate.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setFilter(Object filter) {
            this.setParam("filter", filter);
            return this;
        }

        public APIRequestUpdate setFilter(String filter) {
            this.setParam("filter", filter);
            return this;
        }

        public APIRequestUpdate setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<ProductSet> {
        ProductSet lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"auto_creation_url", "filter", "id", "name", "product_catalog", "product_count"};

        @Override
        public ProductSet getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ProductSet parseResponse(String response) throws APIException {
            return ProductSet.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public ProductSet execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ProductSet execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<ProductSet> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ProductSet> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, ProductSet>(){

                public ProductSet apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAutoCreationUrlField() {
            return this.requestAutoCreationUrlField(true);
        }

        public APIRequestGet requestAutoCreationUrlField(boolean value) {
            this.requestField("auto_creation_url", value);
            return this;
        }

        public APIRequestGet requestFilterField() {
            return this.requestFilterField(true);
        }

        public APIRequestGet requestFilterField(boolean value) {
            this.requestField("filter", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestProductCatalogField() {
            return this.requestProductCatalogField(true);
        }

        public APIRequestGet requestProductCatalogField(boolean value) {
            this.requestField("product_catalog", value);
            return this;
        }

        public APIRequestGet requestProductCountField() {
            return this.requestProductCountField(true);
        }

        public APIRequestGet requestProductCountField(boolean value) {
            this.requestField("product_count", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDelete
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINode>(){

                public APINode apply(String result) {
                    try {
                        return APIRequestDelete.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDelete(String nodeId, APIContext context) {
            super(context, nodeId, "/", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDelete setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDelete setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDelete requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDelete requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetVehicles
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"bulk_pagination", "filter"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(String result) {
                    try {
                        return APIRequestGetVehicles.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetVehicles(String nodeId, APIContext context) {
            super(context, nodeId, "/vehicles", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetVehicles setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetVehicles setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetVehicles setBulkPagination(Boolean bulkPagination) {
            this.setParam("bulk_pagination", bulkPagination);
            return this;
        }

        public APIRequestGetVehicles setBulkPagination(String bulkPagination) {
            this.setParam("bulk_pagination", bulkPagination);
            return this;
        }

        public APIRequestGetVehicles setFilter(Object filter) {
            this.setParam("filter", filter);
            return this;
        }

        public APIRequestGetVehicles setFilter(String filter) {
            this.setParam("filter", filter);
            return this;
        }

        public APIRequestGetVehicles requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetVehicles requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetVehicles requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetVehicles requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetVehicles requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetVehicles requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetProducts
    extends APIRequest<ProductItem> {
        APINodeList<ProductItem> lastResponse = null;
        public static final String[] PARAMS = new String[]{"bulk_pagination", "filter"};
        public static final String[] FIELDS = new String[]{"additional_image_cdn_urls", "additional_image_urls", "additional_variant_attributes", "age_group", "applinks", "availability", "brand", "category", "color", "commerce_insights", "condition", "currency", "custom_data", "custom_label_0", "custom_label_1", "custom_label_2", "custom_label_3", "custom_label_4", "description", "expiration_date", "gender", "gtin", "id", "image_cdn_urls", "image_url", "inventory", "manufacturer_part_number", "material", "mobile_link", "name", "ordering_index", "pattern", "price", "product_catalog", "product_feed", "product_group", "product_type", "retailer_id", "retailer_product_group_id", "review_rejection_reasons", "review_status", "sale_price", "sale_price_end_date", "sale_price_start_date", "shipping_weight_unit", "shipping_weight_value", "short_description", "size", "start_date", "url", "visibility"};

        @Override
        public APINodeList<ProductItem> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<ProductItem> parseResponse(String response) throws APIException {
            return ProductItem.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<ProductItem> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<ProductItem> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<ProductItem>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<ProductItem>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<ProductItem>>(){

                public APINodeList<ProductItem> apply(String result) {
                    try {
                        return APIRequestGetProducts.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetProducts(String nodeId, APIContext context) {
            super(context, nodeId, "/products", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetProducts setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetProducts setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetProducts setBulkPagination(Boolean bulkPagination) {
            this.setParam("bulk_pagination", bulkPagination);
            return this;
        }

        public APIRequestGetProducts setBulkPagination(String bulkPagination) {
            this.setParam("bulk_pagination", bulkPagination);
            return this;
        }

        public APIRequestGetProducts setFilter(Object filter) {
            this.setParam("filter", filter);
            return this;
        }

        public APIRequestGetProducts setFilter(String filter) {
            this.setParam("filter", filter);
            return this;
        }

        public APIRequestGetProducts requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetProducts requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetProducts requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetProducts requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetProducts requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetProducts requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetProducts requestAdditionalImageCdnUrlsField() {
            return this.requestAdditionalImageCdnUrlsField(true);
        }

        public APIRequestGetProducts requestAdditionalImageCdnUrlsField(boolean value) {
            this.requestField("additional_image_cdn_urls", value);
            return this;
        }

        public APIRequestGetProducts requestAdditionalImageUrlsField() {
            return this.requestAdditionalImageUrlsField(true);
        }

        public APIRequestGetProducts requestAdditionalImageUrlsField(boolean value) {
            this.requestField("additional_image_urls", value);
            return this;
        }

        public APIRequestGetProducts requestAdditionalVariantAttributesField() {
            return this.requestAdditionalVariantAttributesField(true);
        }

        public APIRequestGetProducts requestAdditionalVariantAttributesField(boolean value) {
            this.requestField("additional_variant_attributes", value);
            return this;
        }

        public APIRequestGetProducts requestAgeGroupField() {
            return this.requestAgeGroupField(true);
        }

        public APIRequestGetProducts requestAgeGroupField(boolean value) {
            this.requestField("age_group", value);
            return this;
        }

        public APIRequestGetProducts requestApplinksField() {
            return this.requestApplinksField(true);
        }

        public APIRequestGetProducts requestApplinksField(boolean value) {
            this.requestField("applinks", value);
            return this;
        }

        public APIRequestGetProducts requestAvailabilityField() {
            return this.requestAvailabilityField(true);
        }

        public APIRequestGetProducts requestAvailabilityField(boolean value) {
            this.requestField("availability", value);
            return this;
        }

        public APIRequestGetProducts requestBrandField() {
            return this.requestBrandField(true);
        }

        public APIRequestGetProducts requestBrandField(boolean value) {
            this.requestField("brand", value);
            return this;
        }

        public APIRequestGetProducts requestCategoryField() {
            return this.requestCategoryField(true);
        }

        public APIRequestGetProducts requestCategoryField(boolean value) {
            this.requestField("category", value);
            return this;
        }

        public APIRequestGetProducts requestColorField() {
            return this.requestColorField(true);
        }

        public APIRequestGetProducts requestColorField(boolean value) {
            this.requestField("color", value);
            return this;
        }

        public APIRequestGetProducts requestCommerceInsightsField() {
            return this.requestCommerceInsightsField(true);
        }

        public APIRequestGetProducts requestCommerceInsightsField(boolean value) {
            this.requestField("commerce_insights", value);
            return this;
        }

        public APIRequestGetProducts requestConditionField() {
            return this.requestConditionField(true);
        }

        public APIRequestGetProducts requestConditionField(boolean value) {
            this.requestField("condition", value);
            return this;
        }

        public APIRequestGetProducts requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGetProducts requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGetProducts requestCustomDataField() {
            return this.requestCustomDataField(true);
        }

        public APIRequestGetProducts requestCustomDataField(boolean value) {
            this.requestField("custom_data", value);
            return this;
        }

        public APIRequestGetProducts requestCustomLabel0Field() {
            return this.requestCustomLabel0Field(true);
        }

        public APIRequestGetProducts requestCustomLabel0Field(boolean value) {
            this.requestField("custom_label_0", value);
            return this;
        }

        public APIRequestGetProducts requestCustomLabel1Field() {
            return this.requestCustomLabel1Field(true);
        }

        public APIRequestGetProducts requestCustomLabel1Field(boolean value) {
            this.requestField("custom_label_1", value);
            return this;
        }

        public APIRequestGetProducts requestCustomLabel2Field() {
            return this.requestCustomLabel2Field(true);
        }

        public APIRequestGetProducts requestCustomLabel2Field(boolean value) {
            this.requestField("custom_label_2", value);
            return this;
        }

        public APIRequestGetProducts requestCustomLabel3Field() {
            return this.requestCustomLabel3Field(true);
        }

        public APIRequestGetProducts requestCustomLabel3Field(boolean value) {
            this.requestField("custom_label_3", value);
            return this;
        }

        public APIRequestGetProducts requestCustomLabel4Field() {
            return this.requestCustomLabel4Field(true);
        }

        public APIRequestGetProducts requestCustomLabel4Field(boolean value) {
            this.requestField("custom_label_4", value);
            return this;
        }

        public APIRequestGetProducts requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetProducts requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetProducts requestExpirationDateField() {
            return this.requestExpirationDateField(true);
        }

        public APIRequestGetProducts requestExpirationDateField(boolean value) {
            this.requestField("expiration_date", value);
            return this;
        }

        public APIRequestGetProducts requestGenderField() {
            return this.requestGenderField(true);
        }

        public APIRequestGetProducts requestGenderField(boolean value) {
            this.requestField("gender", value);
            return this;
        }

        public APIRequestGetProducts requestGtinField() {
            return this.requestGtinField(true);
        }

        public APIRequestGetProducts requestGtinField(boolean value) {
            this.requestField("gtin", value);
            return this;
        }

        public APIRequestGetProducts requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetProducts requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetProducts requestImageCdnUrlsField() {
            return this.requestImageCdnUrlsField(true);
        }

        public APIRequestGetProducts requestImageCdnUrlsField(boolean value) {
            this.requestField("image_cdn_urls", value);
            return this;
        }

        public APIRequestGetProducts requestImageUrlField() {
            return this.requestImageUrlField(true);
        }

        public APIRequestGetProducts requestImageUrlField(boolean value) {
            this.requestField("image_url", value);
            return this;
        }

        public APIRequestGetProducts requestInventoryField() {
            return this.requestInventoryField(true);
        }

        public APIRequestGetProducts requestInventoryField(boolean value) {
            this.requestField("inventory", value);
            return this;
        }

        public APIRequestGetProducts requestManufacturerPartNumberField() {
            return this.requestManufacturerPartNumberField(true);
        }

        public APIRequestGetProducts requestManufacturerPartNumberField(boolean value) {
            this.requestField("manufacturer_part_number", value);
            return this;
        }

        public APIRequestGetProducts requestMaterialField() {
            return this.requestMaterialField(true);
        }

        public APIRequestGetProducts requestMaterialField(boolean value) {
            this.requestField("material", value);
            return this;
        }

        public APIRequestGetProducts requestMobileLinkField() {
            return this.requestMobileLinkField(true);
        }

        public APIRequestGetProducts requestMobileLinkField(boolean value) {
            this.requestField("mobile_link", value);
            return this;
        }

        public APIRequestGetProducts requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetProducts requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetProducts requestOrderingIndexField() {
            return this.requestOrderingIndexField(true);
        }

        public APIRequestGetProducts requestOrderingIndexField(boolean value) {
            this.requestField("ordering_index", value);
            return this;
        }

        public APIRequestGetProducts requestPatternField() {
            return this.requestPatternField(true);
        }

        public APIRequestGetProducts requestPatternField(boolean value) {
            this.requestField("pattern", value);
            return this;
        }

        public APIRequestGetProducts requestPriceField() {
            return this.requestPriceField(true);
        }

        public APIRequestGetProducts requestPriceField(boolean value) {
            this.requestField("price", value);
            return this;
        }

        public APIRequestGetProducts requestProductCatalogField() {
            return this.requestProductCatalogField(true);
        }

        public APIRequestGetProducts requestProductCatalogField(boolean value) {
            this.requestField("product_catalog", value);
            return this;
        }

        public APIRequestGetProducts requestProductFeedField() {
            return this.requestProductFeedField(true);
        }

        public APIRequestGetProducts requestProductFeedField(boolean value) {
            this.requestField("product_feed", value);
            return this;
        }

        public APIRequestGetProducts requestProductGroupField() {
            return this.requestProductGroupField(true);
        }

        public APIRequestGetProducts requestProductGroupField(boolean value) {
            this.requestField("product_group", value);
            return this;
        }

        public APIRequestGetProducts requestProductTypeField() {
            return this.requestProductTypeField(true);
        }

        public APIRequestGetProducts requestProductTypeField(boolean value) {
            this.requestField("product_type", value);
            return this;
        }

        public APIRequestGetProducts requestRetailerIdField() {
            return this.requestRetailerIdField(true);
        }

        public APIRequestGetProducts requestRetailerIdField(boolean value) {
            this.requestField("retailer_id", value);
            return this;
        }

        public APIRequestGetProducts requestRetailerProductGroupIdField() {
            return this.requestRetailerProductGroupIdField(true);
        }

        public APIRequestGetProducts requestRetailerProductGroupIdField(boolean value) {
            this.requestField("retailer_product_group_id", value);
            return this;
        }

        public APIRequestGetProducts requestReviewRejectionReasonsField() {
            return this.requestReviewRejectionReasonsField(true);
        }

        public APIRequestGetProducts requestReviewRejectionReasonsField(boolean value) {
            this.requestField("review_rejection_reasons", value);
            return this;
        }

        public APIRequestGetProducts requestReviewStatusField() {
            return this.requestReviewStatusField(true);
        }

        public APIRequestGetProducts requestReviewStatusField(boolean value) {
            this.requestField("review_status", value);
            return this;
        }

        public APIRequestGetProducts requestSalePriceField() {
            return this.requestSalePriceField(true);
        }

        public APIRequestGetProducts requestSalePriceField(boolean value) {
            this.requestField("sale_price", value);
            return this;
        }

        public APIRequestGetProducts requestSalePriceEndDateField() {
            return this.requestSalePriceEndDateField(true);
        }

        public APIRequestGetProducts requestSalePriceEndDateField(boolean value) {
            this.requestField("sale_price_end_date", value);
            return this;
        }

        public APIRequestGetProducts requestSalePriceStartDateField() {
            return this.requestSalePriceStartDateField(true);
        }

        public APIRequestGetProducts requestSalePriceStartDateField(boolean value) {
            this.requestField("sale_price_start_date", value);
            return this;
        }

        public APIRequestGetProducts requestShippingWeightUnitField() {
            return this.requestShippingWeightUnitField(true);
        }

        public APIRequestGetProducts requestShippingWeightUnitField(boolean value) {
            this.requestField("shipping_weight_unit", value);
            return this;
        }

        public APIRequestGetProducts requestShippingWeightValueField() {
            return this.requestShippingWeightValueField(true);
        }

        public APIRequestGetProducts requestShippingWeightValueField(boolean value) {
            this.requestField("shipping_weight_value", value);
            return this;
        }

        public APIRequestGetProducts requestShortDescriptionField() {
            return this.requestShortDescriptionField(true);
        }

        public APIRequestGetProducts requestShortDescriptionField(boolean value) {
            this.requestField("short_description", value);
            return this;
        }

        public APIRequestGetProducts requestSizeField() {
            return this.requestSizeField(true);
        }

        public APIRequestGetProducts requestSizeField(boolean value) {
            this.requestField("size", value);
            return this;
        }

        public APIRequestGetProducts requestStartDateField() {
            return this.requestStartDateField(true);
        }

        public APIRequestGetProducts requestStartDateField(boolean value) {
            this.requestField("start_date", value);
            return this;
        }

        public APIRequestGetProducts requestUrlField() {
            return this.requestUrlField(true);
        }

        public APIRequestGetProducts requestUrlField(boolean value) {
            this.requestField("url", value);
            return this;
        }

        public APIRequestGetProducts requestVisibilityField() {
            return this.requestVisibilityField(true);
        }

        public APIRequestGetProducts requestVisibilityField(boolean value) {
            this.requestField("visibility", value);
            return this;
        }
    }
}

