/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndroidAppLink
extends APINode {
    @SerializedName(value="app_name")
    private String mAppName = null;
    @SerializedName(value="class")
    private String mClass = null;
    @SerializedName(value="package")
    private String mPackage = null;
    @SerializedName(value="url")
    private String mUrl = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static AndroidAppLink loadJSON(String json, APIContext context) {
        AndroidAppLink androidAppLink = (AndroidAppLink)AndroidAppLink.getGson().fromJson(json, AndroidAppLink.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(androidAppLink.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        androidAppLink.context = context;
        androidAppLink.rawValue = json;
        return androidAppLink;
    }

    public static APINodeList<AndroidAppLink> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AndroidAppLink> androidAppLinks = new APINodeList<AndroidAppLink>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        androidAppLinks.add(AndroidAppLink.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return androidAppLinks;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            androidAppLinks.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        androidAppLinks.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            androidAppLinks.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            androidAppLinks.add(AndroidAppLink.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                androidAppLinks.add(AndroidAppLink.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            androidAppLinks.add(AndroidAppLink.loadJSON(obj.toString(), context));
                        }
                    }
                    return androidAppLinks;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        androidAppLinks.add(AndroidAppLink.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return androidAppLinks;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        androidAppLinks.add(AndroidAppLink.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return androidAppLinks;
                }
                androidAppLinks.clear();
                androidAppLinks.add(AndroidAppLink.loadJSON(json, context));
                return androidAppLinks;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AndroidAppLink.getGson().toJson((Object)this);
    }

    public String getFieldAppName() {
        return this.mAppName;
    }

    public AndroidAppLink setFieldAppName(String value) {
        this.mAppName = value;
        return this;
    }

    public String getFieldClass() {
        return this.mClass;
    }

    public AndroidAppLink setFieldClass(String value) {
        this.mClass = value;
        return this;
    }

    public String getFieldPackage() {
        return this.mPackage;
    }

    public AndroidAppLink setFieldPackage(String value) {
        this.mPackage = value;
        return this;
    }

    public String getFieldUrl() {
        return this.mUrl;
    }

    public AndroidAppLink setFieldUrl(String value) {
        this.mUrl = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AndroidAppLink copyFrom(AndroidAppLink instance) {
        this.mAppName = instance.mAppName;
        this.mClass = instance.mClass;
        this.mPackage = instance.mPackage;
        this.mUrl = instance.mUrl;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AndroidAppLink> getParser() {
        return new APIRequest.ResponseParser<AndroidAppLink>(){

            @Override
            public APINodeList<AndroidAppLink> parseResponse(String response, APIContext context, APIRequest<AndroidAppLink> request) throws APIException.MalformedResponseException {
                return AndroidAppLink.parseResponse(response, context, request);
            }
        };
    }
}

