/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import java.io.PrintStream;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class APIContext {
    public static final String DEFAULT_API_BASE = "https://graph.facebook.com";
    public static final String DEFAULT_API_VERSION = "v3.0";
    public static final String DEFAULT_VIDEO_API_BASE = "https://graph-video.facebook.com";
    private String endpointBase;
    private String videoEndpointBase;
    private String accessToken;
    private String appSecret;
    private String version;
    protected boolean isDebug = false;
    protected PrintStream logger = System.out;

    public APIContext(String endpointBase, String videoEndpointBase, String version, String accessToken, String appSecret) {
        this.version = version;
        this.endpointBase = endpointBase;
        this.videoEndpointBase = videoEndpointBase;
        this.accessToken = accessToken;
        this.appSecret = appSecret;
    }

    public APIContext(String accessToken) {
        this(DEFAULT_API_BASE, DEFAULT_VIDEO_API_BASE, DEFAULT_API_VERSION, accessToken, null);
    }

    public APIContext(String accessToken, String appSecret) {
        this(DEFAULT_API_BASE, DEFAULT_VIDEO_API_BASE, DEFAULT_API_VERSION, accessToken, appSecret);
    }

    public String getEndpointBase() {
        return this.endpointBase;
    }

    public String getVideoEndpointBase() {
        return this.videoEndpointBase;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public boolean hasAppSecret() {
        return this.appSecret != null;
    }

    public String getAppSecretProof() {
        return APIContext.sha256(this.appSecret, this.accessToken);
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public APIContext enableDebug(boolean isDebug) {
        this.isDebug = isDebug;
        return this;
    }

    public PrintStream getLogger() {
        return this.logger;
    }

    public APIContext setLogger(PrintStream logger) {
        this.logger = logger;
        return this;
    }

    public void log(String s) {
        if (this.isDebug && this.logger != null) {
            this.logger.println(s);
        }
    }

    public static String sha256(String secret, String message) {
        try {
            Mac sha256HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKey = new SecretKeySpec(secret.getBytes(), "HmacSHA256");
            sha256HMAC.init(secretKey);
            byte[] bytes = sha256HMAC.doFinal(message.getBytes());
            return APIContext.toHex(bytes);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The provided app secret or access token is invalid!");
        }
    }

    public static String toHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%1$02x", b));
        }
        return sb.toString();
    }
}

