/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.login;

import android.content.Context;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import com.facebook.FacebookSdk;
import com.facebook.internal.CustomTabUtils;
import com.facebook.internal.NativeProtocol;
import com.facebook.login.DefaultAudience;
import com.facebook.login.LoginBehavior;
import com.facebook.login.LoginClient;
import com.facebook.login.NativeAppLoginMethodHandler;
import java.util.List;

class KatanaProxyLoginMethodHandler
extends NativeAppLoginMethodHandler {
    public static final Parcelable.Creator<KatanaProxyLoginMethodHandler> CREATOR = new Parcelable.Creator<KatanaProxyLoginMethodHandler>(){

        public KatanaProxyLoginMethodHandler createFromParcel(Parcel source) {
            return new KatanaProxyLoginMethodHandler(source);
        }

        public KatanaProxyLoginMethodHandler[] newArray(int size) {
            return new KatanaProxyLoginMethodHandler[size];
        }
    };

    KatanaProxyLoginMethodHandler(LoginClient loginClient) {
        super(loginClient);
    }

    @Override
    String getNameForLogging() {
        return "katana_proxy_auth";
    }

    @Override
    int tryAuthorize(LoginClient.Request request) {
        LoginBehavior behavior = request.getLoginBehavior();
        boolean ignoreAppSwitchToLoggedOut = FacebookSdk.ignoreAppSwitchToLoggedOut && CustomTabUtils.getChromePackage() != null && behavior.allowsCustomTabAuth();
        String e2e = LoginClient.getE2E();
        List intents = NativeProtocol.createProxyAuthIntents((Context)this.loginClient.getActivity(), (String)request.getApplicationId(), request.getPermissions(), (String)e2e, (boolean)request.isRerequest(), (boolean)request.hasPublishPermission(), (DefaultAudience)request.getDefaultAudience(), (String)this.getClientState(request.getAuthId()), (String)request.getAuthType(), (boolean)ignoreAppSwitchToLoggedOut);
        this.addLoggingExtra("e2e", e2e);
        for (int i = 0; i < intents.size(); ++i) {
            boolean launchedIntent = this.tryIntent((Intent)intents.get(i), LoginClient.getLoginRequestCode());
            if (!launchedIntent) continue;
            return i + 1;
        }
        return 0;
    }

    @Override
    public boolean shouldKeepTrackOfMultipleIntents() {
        return true;
    }

    KatanaProxyLoginMethodHandler(Parcel source) {
        super(source);
    }

    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
    }
}

