/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.webkit.WebView;
import com.facebook.internal.BundleJSONConverter;
import com.facebook.internal.NativeProtocol;
import com.facebook.internal.Utility;
import com.facebook.internal.WebDialog;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import org.json.JSONException;
import org.json.JSONObject;

public class FacebookWebFallbackDialog
extends WebDialog {
    private static final String TAG = FacebookWebFallbackDialog.class.getName();
    private static final int OS_BACK_BUTTON_RESPONSE_TIMEOUT_MILLISECONDS = 1500;
    private boolean waitingForDialogToClose;

    public static FacebookWebFallbackDialog newInstance(Context context, String url, String expectedRedirectUrl) {
        WebDialog.initDefaultTheme(context);
        return new FacebookWebFallbackDialog(context, url, expectedRedirectUrl);
    }

    private FacebookWebFallbackDialog(Context context, String url, String expectedRedirectUrl) {
        super(context, url);
        this.setExpectedRedirectUrl(expectedRedirectUrl);
    }

    @Override
    protected Bundle parseResponseUri(String url) {
        Uri responseUri = Uri.parse((String)url);
        Bundle queryParams = Utility.parseUrlQueryString((String)responseUri.getQuery());
        String bridgeArgsJSONString = queryParams.getString("bridge_args");
        queryParams.remove("bridge_args");
        if (!Utility.isNullOrEmpty((String)bridgeArgsJSONString)) {
            try {
                JSONObject bridgeArgsJSON = new JSONObject(bridgeArgsJSONString);
                Bundle bridgeArgs = BundleJSONConverter.convertToBundle((JSONObject)bridgeArgsJSON);
                queryParams.putBundle("com.facebook.platform.protocol.BRIDGE_ARGS", bridgeArgs);
            }
            catch (JSONException je) {
                Utility.logd((String)TAG, (String)"Unable to parse bridge_args JSON", (Throwable)je);
            }
        }
        String methodResultsJSONString = queryParams.getString("method_results");
        queryParams.remove("method_results");
        if (!Utility.isNullOrEmpty((String)methodResultsJSONString)) {
            methodResultsJSONString = Utility.isNullOrEmpty((String)methodResultsJSONString) ? "{}" : methodResultsJSONString;
            try {
                JSONObject methodArgsJSON = new JSONObject(methodResultsJSONString);
                Bundle methodResults = BundleJSONConverter.convertToBundle((JSONObject)methodArgsJSON);
                queryParams.putBundle("com.facebook.platform.protocol.RESULT_ARGS", methodResults);
            }
            catch (JSONException je) {
                Utility.logd((String)TAG, (String)"Unable to parse bridge_args JSON", (Throwable)je);
            }
        }
        queryParams.remove("version");
        queryParams.putInt("com.facebook.platform.protocol.PROTOCOL_VERSION", NativeProtocol.getLatestKnownVersion());
        return queryParams;
    }

    @Override
    public void cancel() {
        WebView webView = this.getWebView();
        if (!this.isPageFinished() || this.isListenerCalled() || webView == null || !webView.isShown()) {
            super.cancel();
            return;
        }
        if (this.waitingForDialogToClose) {
            return;
        }
        this.waitingForDialogToClose = true;
        String eventJS = "(function() {  var event = document.createEvent('Event');  event.initEvent('fbPlatformDialogMustClose',true,true);  document.dispatchEvent(event);})();";
        webView.loadUrl("javascript:" + eventJS);
        Handler handler = new Handler(Looper.getMainLooper());
        handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (CrashShieldHandler.isObjectCrashing((Object)this)) {
                    return;
                }
                try {
                    FacebookWebFallbackDialog.super.cancel();
                    return;
                }
                catch (Throwable throwable) {
                    CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
                    return;
                }
            }
        }, 1500L);
    }
}

