/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.content.Intent;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.util.UUID;

public class AppCall {
    private static AppCall currentPendingCall;
    private UUID callId;
    private Intent requestIntent;
    private int requestCode;

    public static AppCall getCurrentPendingCall() {
        if (CrashShieldHandler.isObjectCrashing(AppCall.class)) {
            return null;
        }
        try {
            return currentPendingCall;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, AppCall.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static synchronized AppCall finishPendingCall(UUID uUID, int n) {
        if (CrashShieldHandler.isObjectCrashing(AppCall.class)) {
            return null;
        }
        try {
            void requestCode;
            UUID callId;
            AppCall pendingCall = AppCall.getCurrentPendingCall();
            if (pendingCall == null || !pendingCall.getCallId().equals(callId) || pendingCall.getRequestCode() != requestCode) {
                return null;
            }
            AppCall.setCurrentPendingCall(null);
            return pendingCall;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, AppCall.class);
            return null;
        }
    }

    private static synchronized boolean setCurrentPendingCall(AppCall appCall) {
        if (CrashShieldHandler.isObjectCrashing(AppCall.class)) {
            return false;
        }
        try {
            AppCall appCall2;
            AppCall oldAppCall = AppCall.getCurrentPendingCall();
            currentPendingCall = appCall2;
            return oldAppCall != null;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, AppCall.class);
            return false;
        }
    }

    public AppCall(int requestCode) {
        this(requestCode, UUID.randomUUID());
    }

    public AppCall(int requestCode, UUID callId) {
        this.callId = callId;
        this.requestCode = requestCode;
    }

    public Intent getRequestIntent() {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return null;
        }
        try {
            return this.requestIntent;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return null;
        }
    }

    public UUID getCallId() {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return null;
        }
        try {
            return this.callId;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return null;
        }
    }

    public int getRequestCode() {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return 0;
        }
        try {
            return this.requestCode;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setRequestCode(int n) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void requestCode;
            this.requestCode = requestCode;
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setRequestIntent(Intent intent) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void requestIntent;
            this.requestIntent = requestIntent;
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    public boolean setPending() {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return false;
        }
        try {
            return AppCall.setCurrentPendingCall(this);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return false;
        }
    }
}

