/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.net.Uri;
import android.os.Bundle;
import com.facebook.AccessToken;
import com.facebook.FacebookException;
import com.facebook.GraphRequest;
import com.facebook.HttpMethod;
import com.facebook.share.internal.OpenGraphJSONUtility;
import com.facebook.share.model.ShareOpenGraphObject;
import com.facebook.share.model.SharePhoto;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class ShareGraphRequest {
    public static GraphRequest createOpenGraphObject(ShareOpenGraphObject openGraphObject) throws FacebookException {
        String type = openGraphObject.getString("type");
        if (type == null) {
            type = openGraphObject.getString("og:type");
        }
        if (type == null) {
            throw new FacebookException("Open graph object type cannot be null");
        }
        try {
            JSONObject stagedObject = (JSONObject)OpenGraphJSONUtility.toJSONValue(openGraphObject, new OpenGraphJSONUtility.PhotoJSONProcessor(){

                @Override
                public JSONObject toJSONObject(SharePhoto photo) {
                    Uri photoUri = photo.getImageUrl();
                    JSONObject photoJSONObject = new JSONObject();
                    try {
                        photoJSONObject.put("url", (Object)photoUri.toString());
                    }
                    catch (Exception e) {
                        throw new FacebookException("Unable to attach images", (Throwable)e);
                    }
                    return photoJSONObject;
                }
            });
            String ogType = type;
            Bundle parameters = new Bundle();
            parameters.putString("object", stagedObject.toString());
            String graphPath = String.format(Locale.ROOT, "%s/%s", "me", "objects/" + ogType);
            return new GraphRequest(AccessToken.getCurrentAccessToken(), graphPath, parameters, HttpMethod.POST);
        }
        catch (JSONException e) {
            throw new FacebookException(e.getMessage());
        }
    }
}

